<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Sc\Entities\DocumentNumber;
use Modules\Sc\Entities\GoodsTransferAttachmentMR;
use Modules\Sc\Entities\GoodsTransferDataMR;
use Modules\Sc\Entities\GoodsTransferHeaderMR;
use Modules\Sc\Entities\GrnHeader;
use Modules\Sc\Entities\MaterialRequisitionData;
use Modules\Sc\Entities\ProductHistory;
use Modules\Sc\Entities\ProductHistorySetoff;
use Modules\Sc\Entities\PurchaseOrderHeader;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\Suppliers;

class GoodsTransferMRController extends Controller
{
    public function allEmployees()
    {
        try {
            $employees = Employee::all();
            $result = array();
            foreach ($employees as $emp) {
                array_push($result, [
                    "img" => "",
                    "id" => $emp->employee_id,
                    "value" => $emp->name_withinitial,
                ]);
            }
            $responseBody = $this->responseBody(true, "GoodsTransferController", "allEmployees", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function allSuppliers()
    {
        try {
            $products =  Suppliers::select('supplier_id As id', 'supplier_name As value0')->get();
            return $this->responseBody(true, "GrnHeaderController", "allSuppliers", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "GoodsTransferController", "error", $exception);
        }
    }


    public function allProduct()
    {
        try {
            $products =  Product::select('product_primary_id As id', 'product_id As value0', 'product_name As value1')->get();
            return $this->responseBody(true, "GoodsTransferController", "allProduct", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "GoodsTransferController", "error", $exception);
        }
    }


    public function maxID($store_id, $document_no)
    {
        try {
            $grn = GrnHeader::where('document_no', '=', $document_no)->get();
            $id = $grn[count($grn) - 1]['internal_id'] + 1;
            $store = StoreLocation::find($store_id);
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
            }
            $responseBody = $this->responseBody(true, "GoodsTransferController", "allProductUnit", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function allStores()
    {
        try {
            $stores =  StoreLocation::all();
            $responseBody = $this->responseBody(true, "GoodsTransferController", "allStores", $stores);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function save(Request $request)
    {
        try {
            $prefix = $this->getPrefix('410');
            $material_request_id = $request->get('mr_internal_id');
            $material_request_data = MaterialRequisitionData::where('internal_id', '=', $material_request_id)->get();
            $goods_transfer = new GoodsTransferHeaderMR();
            $goods_transfer->external_id = $prefix . "" . $request->get('external_id');
            $goods_transfer->ref_external_id = $prefix . "" . $request->get('ref_extenal_id');
            $goods_transfer->trans_date = $request->get('trans_date');
            $goods_transfer->store_from_id = $request->get('store_from_id');
            $goods_transfer->store_to_id = $request->get('store_to_id');
            $goods_transfer->mr_internal_id = $request->get('mr_internal_id');

            $goods_transfer->first_weight = $request->get('first_weight');
            $goods_transfer->second_weight = $request->get('second_weight');
            $goods_transfer->first_weight_time = $request->get('first_weight_time');
            $goods_transfer->second_weight_time = $request->get('second_weight_time');

            $goods_transfer->document_no = 410;
            $goods_transfer->Status = 0;
            $goods_transfer->user_id = Auth::user()->id;
            if ($goods_transfer->save()) {
                $goods_transfer = GoodsTransferHeaderMR::find($goods_transfer->internal_id);
                $goods_transfer->ref_internal_id = $goods_transfer->internal_id;
                $goods_transfer->update();
                $grn_arr = $request->get("grn_data");
                for ($i = 0; $i < count($grn_arr); $i++) {
                    $grnData = json_decode($grn_arr[$i]);
                    $goods_transfer_data = new GoodsTransferDataMR();
                    $goods_transfer_data->internal_id = $goods_transfer->internal_id;
                    $goods_transfer_data->external_id = $goods_transfer->external_id;
                    $goods_transfer_data->product_id =  $grnData->product_id;
                    $goods_transfer_data->unit_id =  $grnData->unit_id;
                    $goods_transfer_data->quantity =  $grnData->qty;
                    $goods_transfer_data->comments =  $grnData->comments;
                    $goods_transfer_data->save();

                    foreach ($material_request_data as $data) {
                        if ($data->product_id == $grnData->product_id) {
                            $mrItem = MaterialRequisitionData::find($data->mr_data_id);
                            if ($mrItem) {
                                $mrItem->transfer_quantity = ($mrItem->transfer_quantity + $grnData->qty);
                                $mrItem->update();
                            }
                        }
                    }

                    if ($goods_transfer->second_weight  > 0) {
                        $this->addProductHistory($goods_transfer, $goods_transfer_data);
                    }
                }


                $attachmnet_token = $request->get("attachment_token");
                $attachments = GoodsTransferAttachmentMR::where('token', '=', $attachmnet_token)->get();
                foreach ($attachments as $attachmnet) {
                    if ($attachmnet) {
                        $attachmnet->goods_transfer_mr_id = $goods_transfer->internal_id;
                        $attachmnet->update();
                    }
                }
            }
            $responseBody = $this->responseBody(true, "GoodsTransferController", "saveGrnHeaderTemp", $material_request_data);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    public function getGoodsTransfer($id)
    {
        try {
            $grn = GoodsTransferHeaderMR::find($id);
            if (count(array_filter(explode("-", $grn->external_id))) == 2) {
                $grn->external_id = explode("-", $grn->external_id)[1];
            }
            $grn_data = GoodsTransferDataMR::where('internal_id', '=', $id)->get();
            foreach ($grn_data as $data) {
                $product = Product::find($data->product_id);
                $data->product = $product->product_name;
                $uom = ProductUnit::find($data->unit_id);
                $uom_arr = [];
                if ($uom) {
                    array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
                }
                $data->uom = $uom_arr;
                $data->product_primary_id = $product->product_primary_id;
                $data->product_id = $product->product_id;
            }
            $grn->data = $grn_data;
            $responseBody = $this->responseBody(true, "GoodsTransferController", "getGrn", $grn);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function update(Request $request, $id)
    {

        try {

            $old_qty = $this->getOldQuantity($id);
            if ($this->delete($id)) {
                $prefix = $this->getPrefix('410');
                $gtr = GoodsTransferHeaderMR::find($id);
                $material_request_id = $gtr->mr_internal_id;
                $material_request_data = MaterialRequisitionData::where('internal_id', '=', $material_request_id)->get();


                $gtr->external_id = $prefix . "" . $request->get('external_id');
                $gtr->ref_external_id = $prefix . "" . $request->get('ref_extenal_id');
                $gtr->trans_date = $request->get('trans_date');
                $gtr->store_from_id = $request->get('store_from_id');
                $gtr->store_to_id = $request->get('store_to_id');

                $gtr->first_weight = $request->get('first_weight');
                $gtr->second_weight = $request->get('second_weight');
                $gtr->first_weight_time = $request->get('first_weight_time');
                $gtr->second_weight_time = $request->get('second_weight_time');
                if ($gtr->update()) {
                    $this->removeProductHistory($gtr);
                    $this->removeProductHistorySetoff($gtr);
                    $grn_arr = $request->get("grn_data");
                    if ($grn_arr) {
                        for ($i = 0; $i < count($grn_arr); $i++) {
                            $gtrData = json_decode($grn_arr[$i]);
                            $gtr_data = new GoodsTransferDataMR();
                            $gtr_data->internal_id = $gtr->internal_id;
                            $gtr_data->external_id = $gtr->external_id;
                            $gtr_data->product_id =  $gtrData->product_id;
                            $gtr_data->unit_id =  $gtrData->unit_id;
                            $gtr_data->quantity =  $gtrData->qty;
                            $gtr_data->comments =  $gtrData->comments;
                            $gtr_data->save();

                            foreach ($material_request_data as $data) {
                                if ($data->product_id == $gtrData->product_id) {
                                    $mrItem = MaterialRequisitionData::find($data->mr_data_id);
                                    if ($mrItem) {
                                        $mrItem->transfer_quantity = (($mrItem->transfer_quantity - $old_qty) + $gtrData->qty);
                                        $mrItem->update();
                                    }
                                }
                            }

                            if ($gtr->second_weight > 0) {
                                $this->updateProductHistory($gtr, $gtr_data);
                            }
                        }
                    }
                }


                $attachmnet_token = $request->get("attachment_token");
                $attachments = GoodsTransferAttachmentMR::where('token', '=', $attachmnet_token)->get();
                foreach ($attachments as $attachmnet) {
                    if ($attachmnet) {
                        $attachmnet->goods_transfer_mr_id = $gtr->internal_id;
                        $attachmnet->update();
                    }
                }
            }

            $responseBody = $this->responseBody(true, "GoodsTransferController", "update", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function delete($id)
    {
        try {
            GoodsTransferDataMR::where('internal_id', '=', $id)->delete();
            return true;
        } catch (Exception $exception) {
            return false;
        }
    }


    public function getOldQuantity($id)
    {
        $qty = 0;

        $goods_transfer_mr = GoodsTransferDataMR::where('internal_id', '=', $id)->first();
        if ($goods_transfer_mr) {
            $qty = $goods_transfer_mr->quantity;
        }
        return $qty;
    }






    private function removeProductFromSetoff($id)
    {
        $product_histories = ProductHistory::where('internal_id', '=', $id)->get();
        foreach ($product_histories as $data) {
            $data->delete();
        }
    }





    public function getUom($id)
    {
        try {
            $product =  Product::where('product_primary_id', '=', $id)->first();

            $data = [
                "id" => "0",
                "value" => "",
            ];
            if ($product) {
                $uom =  ProductUnit::find($product->uom_id);
                if ($uom) {
                    $data["id"] = $uom->id;
                    $data["value"] = $uom->name;
                }
            }

            $responseBody = $this->responseBody(true, "GoodsTransferController", "getUom", $data);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function uploadAttachment(Request $request)
    {

        // $id = $request->get('grn_id');
        $token = $request->get('attachmnet_token');
        $file = $request->file('file');
        $file_name = $file->getClientOriginalName();
        $filename = uniqid() . '_' . time() . '.' . $file_name;
        $filename = str_replace(' ','',str_replace('\'','',$filename));
        $file->move(public_path('grn'), $filename);

        $grn_attachment = new GoodsTransferAttachmentMR();
        $grn_attachment->goods_transfer_mr_id = 0;
        $grn_attachment->path = $filename;
        $grn_attachment->token = $token;
        return $grn_attachment->save();
    }



    public function allAttachment($id, $token)
    {
        try {

            $attachment = DB::select('SELECT *FROM sc_goods_transfer_attachment_m_rs WHERE  goods_transfer_mr_id = "' . $id . '" OR token = "' . $token . '"');
            $responseBody = $this->responseBody(true, "GoodsTransferController", "allAttachment", $attachment);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferController", "allAttachment", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function getPoFromSupplier($id)
    {
        try {

            $po = PurchaseOrderHeader::where('supplier_id', '=', $id)->get();
            $responseBody = $this->responseBody(true, "GoodsTransferController", "getPoFromSupplier", $po);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferController", "getPoFromSupplier", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    private function removeProductHistory($goods_transfer)
    {
        $document_no = $goods_transfer->document_no;
        $internal_no = $goods_transfer->internal_id;
        $external_no = $goods_transfer->external_id;
        ProductHistory::where([['document_no', '=', $document_no], ['internal_id', '=', $internal_no], ['external_id', '=', $external_no]])->delete();
    }

    private function removeProductHistorySetoff($goods_transfer)
    {
        $document_no = $goods_transfer->document_no;
        $internal_no = $goods_transfer->internal_id;
        $external_no = $goods_transfer->external_id;
        $setoff_array = ProductHistorySetoff::where([['document_no', '=', $document_no], ['internal_id', '=', $internal_no], ['external_id', '=', $external_no]])->get();
        foreach ($setoff_array as $setoff) {
            $obj = ProductHistorySetoff::find($setoff->transaction_id);
            if ($obj) {
                if ($obj->quantity < 0) {
                    $ref_document_no = $obj->ref_document_no;
                    $ref_internal_no = $obj->ref_internal_id;
                    $ref_external_no = $obj->ref_external_id;
                    $result = ProductHistorySetoff::where([['document_no', '=', $ref_document_no], ['internal_id', '=', $ref_internal_no], ['external_id', '=', $ref_external_no]])->first();
                    $obj2 = ProductHistorySetoff::find($result->transaction_id);
                    if ($obj2) {
                        $obj2->setoff_quantity = ($obj2->setoff_quantity - abs($obj->quantity));
                        $obj2->update();
                    }
                }
                $obj->delete();
            }
        }
    }

    private function addProductHistory($header, $data)
    {



        $product_history_setoff = new ProductHistorySetOffController();

        $product_history = new ProductHistory();
        $product_history->internal_id = $header->internal_id;
        $product_history->external_id = $header->external_id;
        $product_history->document_no = $header->document_no;
        $product_history->description = "Goods Transfer MR";
        $product_history->product_id = $data->product_id;
        $product_history->unit_id = $data->unit_id;
        $product_history->quantity = ($data->quantity * -1);
        $product_history->set_off = 0;
        $product_history->cost_price = 0;
        $product_history->store_id = $header->store_from_id;
        $product_history->user_id = Auth::user()->id;
        if ($product_history->save()) {
            $product_history_setoff->saveGoodsTransferMR($product_history, $header->store_from_id, $header->store_to_id);
        }




        $product_history = new ProductHistory();
        $product_history->internal_id = $header->internal_id;
        $product_history->external_id = $header->external_id;
        $product_history->document_no = $header->document_no;
        $product_history->description = "Goods Transfer MR";
        $product_history->product_id = $data->product_id;
        $product_history->unit_id = $data->unit_id;
        $product_history->quantity = $data->quantity;
        $product_history->set_off = 0;
        $product_history->cost_price = 0;
        $product_history->store_id = $header->store_to_id;
        $product_history->user_id = Auth::user()->id;
        $product_history->save();
    }





    private function updateProductHistory($header, $new_data)
    {



        $product_history_setoff = new ProductHistorySetOffController();

        $product_history = new ProductHistory();
        $product_history->internal_id = $header->internal_id;
        $product_history->external_id = $header->external_id;
        $product_history->document_no = $header->document_no;
        $product_history->description = "Goods Transfer MR";
        $product_history->product_id = $new_data->product_id;
        $product_history->unit_id = $new_data->unit_id;
        $product_history->quantity = ($new_data->quantity * -1);
        $product_history->set_off = 0;
        $product_history->cost_price = 0;
        $product_history->store_id = $header->store_from_id;
        $product_history->user_id = Auth::user()->id;
        if ($product_history->save()) {
            $product_history_setoff->updateGoodsTransferMR($product_history, $header->store_from_id, $header->store_to_id);
        }




        $product_history = new ProductHistory();
        $product_history->internal_id = $header->internal_id;
        $product_history->external_id = $header->external_id;
        $product_history->document_no = $header->document_no;
        $product_history->description = "Goods Transfer MR";
        $product_history->product_id = $new_data->product_id;
        $product_history->unit_id = $new_data->unit_id;
        $product_history->quantity = $new_data->quantity;
        $product_history->set_off = 0;
        $product_history->cost_price = 0;
        $product_history->store_id = $header->store_to_id;
        $product_history->user_id = Auth::user()->id;
        $product_history->save();
    }


    public function getQty($product_id, $store_id)
    {
        try {
            $query = "SELECT SUM(quantity) AS quantity FROM sc_product_histories WHERE product_id = '" . $product_id . "' AND store_id = '" . $store_id . "'";
            $result = DB::select($query);
            $quantity = 0;
            foreach ($result as $data) {
                if ($data->quantity) {
                    $quantity = $data->quantity;
                }
            }
            $responseBody = $this->responseBody(true, "GoodsTransferController", "getQty", $quantity);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function getQtyUpdate($product_id, $store_id)
    {
        try {
            $query = "SELECT SUM(quantity) AS quantity FROM sc_product_histories WHERE quantity >0 AND product_id = '" . $product_id . "' AND store_id = '" . $store_id . "'";
            $result = DB::select($query);
            $quantity = 0;
            foreach ($result as $data) {
                if ($data->quantity) {
                    $quantity = $data->quantity;
                }
            }
            $responseBody = $this->responseBody(true, "GoodsTransferController", "getQty", $quantity);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    private function updateProductHistorySetOff($ref_internal_id, $product_id, $store_id, $setoff_quantity)
    {

        $product_history = ProductHistory::where([['product_id', '=', $product_id], ['store_id', '=', $store_id], ['document_no', '=', '100']])->get();

        $setoff = $setoff_quantity;

        foreach ($product_history as $data) {
            $setoff += $data->set_off;
            if ($setoff >= $data->quantity) {
                $data->set_off = $data->quantity;
                $data->update();
                $setoff = ($setoff - $data->quantity);
            } else {
                $data->set_off = $setoff;
                $data->update();
                $setoff = ($setoff - $setoff_quantity);
            }
        }
    }




    public function deleteGoodsTransfer($id)
    {

        try {
            $goods_transfer = GoodsTransferHeaderMR::find($id);
            if ($goods_transfer) {
                if ($this->delete($goods_transfer->external_id)) {
                    $this->removeProductHistory($goods_transfer);
                    $this->removeProductHistorySetoff($goods_transfer);
                    $goods_transfer->delete();
                }
            }
            $responseBody = $this->responseBody(true, "GoodsTransferController", "deleteGoodsTransfer", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferController", "deleteGoodsTransfer", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function change_status(Request $request, $id)
    {

        try {

            $transfer_header = GoodsTransferHeaderMR::find($id);
            $transfer_header->status = $request->get('status');
            $transfer_header->update();

            $responseBody = $this->responseBody(true, "GoodsTransferController", "approve", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function isApproved($id)
    {
        try {
            $transfer = GoodsTransferHeaderMR::find($id);
            if ($transfer) {
                $responseBody = $this->responseBody(true, "GoodsTransferController", "isApproved", $transfer->status);
            }
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function isValiedToUpdate($id)
    {

        $bool = true;
        $query = 'SELECT SUM(setoff_quantity) AS quantity FROM sc_product_history_setoffs WHERE document_no = "410" AND internal_id = "' . $id . '"';
        $setoff = DB::select($query)[0];
        if ($setoff->quantity > 0) {
            $bool = false;
        }
        return response()->json(["canUpdate" => $bool]);
    }





    private function getPrefix($document_no)
    {
        $document_no = DocumentNumber::where('document_number', '=', $document_no)->first();
        $prefix = "";
        if ($document_no) {
            $prefix = $document_no->prefix;
        }

        return $prefix;
    }





    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
