<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Sc\Entities\GoodsTransferDataMR;
use Modules\Sc\Entities\GoodsTransferHeaderMR;
use Modules\Sc\Entities\StoreLocation;

class GoodsTransferMRListController extends Controller
{
    public function allGoodsTransfer()
    {
        try {
            $goods_transfers = GoodsTransferHeaderMR::select('*')->orderBy('internal_id', 'DESC')->get();
            foreach ($goods_transfers as $goods_transfer) {
                $store_from = StoreLocation::find($goods_transfer->store_from_id);
                $store_to = StoreLocation::find($goods_transfer->store_to_id);
                $goods_transfer->store_from = $store_from->name;
                $goods_transfer->store_to = $store_to->name;
            }
            $responseBody = $this->responseBody(true, "GoodsTransferMRListController", "allGoodsTransfer", $goods_transfers);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferMRListController", "allGoodsTransfer", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function delete($id)
    {
        try {
            GoodsTransferDataMR::where('internal_id', '=', $id)->delete();
            GoodsTransferHeaderMR::find($id)->delete();
            $responseBody = $this->responseBody(true, "GoodsTransferMRListController", "delete", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferMRListController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
