<?php

namespace Modules\Sc\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Hr\Entities\Employee;
use Modules\Pp\Entities\Machinary;
use Modules\Sc\Entities\Department;
use Modules\Sc\Entities\GrnData;
use Modules\Sc\Entities\GrnHeader;
use Modules\Sc\Entities\ProductHistorySetoff;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\Suppliers;
use Modules\St\Entities\Uom;
use PDO;

class GrnListController extends Controller
{


    public function allGrn()
    {
        try {
            $grnList = GrnHeader::where('document_no', '=', '100')->orderBy('internal_id', 'DESC')->get();
            foreach ($grnList as $grn) {
                $supplier = Suppliers::find($grn->supplier_Id);
                $grn->supplier = $supplier->supplier_name;
            }
            $responseBody = $this->responseBody(true, "GrnListController", "allGrn", $grnList);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnListController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function goodsReceivedReport($id)
    {
        try {
            $grn = GrnHeader::find($id);

            $header = [
                "referance_no" => "",
                "date" => "",
                "supplier" => "",
                "received_by" => "",
                "store" => "",
                "supplier_ref_no" => "",
                "po_no" => "",
                "transport_by" => "",
                "vehicle_no" => "",
                "no_of_items" => "0.00",
            ];


            if ($grn) {

                if ($grn->external_id) {
                    $header["referance_no"] = $grn->external_id;
                }
                if ($grn->trans_date) {
                    $header["date"] = $grn->trans_date;
                }
                if ($this->getSupplier($grn->supplier_Id)) {
                    $header["supplier"] = $this->getSupplier($grn->supplier_Id);
                }
                if ($this->getReceivedBy($grn->received_by)) {
                    $header["received_by"] = $this->getReceivedBy($grn->received_by);
                }
                if ($this->getStore($grn->store_id)) {
                    $header["store"] = $this->getStore($grn->store_id);
                }
                if ($grn->supplier_ref_no) {
                    $header["supplier_ref_no"] = $grn->supplier_ref_no;
                }
                if ($grn->purchase_order_no) {
                    $header["po_no"] = $grn->purchase_order_no;
                }
                if ($grn->transport_by) {
                    $header["transport_by"] = $grn->transport_by;
                }
                if ($grn->vehicle_no) {
                    $header["vehicle_no"] = $grn->vehicle_no;
                }
            }

            $data = GrnData::where('internal_id', '=', $id)->get();
            $total_value = 0.0;
            foreach ($data as $dd) {
                $dd->cost_price = 0.00;
                $product = Product::find($dd->product_id);
                $dd->product_id = $product->product_id;
                $dd->product = $product->product_name;
                $uom = ProductUnit::find($dd->unit_id);
                
                if ($uom) {
                    $dd->unit = $uom->name;
                } else {
                    $dd->unit = '';
                }
                $product_history = ProductHistorySetoff::where('internal_id','=', $dd->internal_id)->first();
                if($product_history){
                    $dd->cost_price = $product_history->cost_price;
                }
                $total_value+= $dd->quantity * $dd->cost_price;
            }
            $header["total_value"] = $total_value;


            $responseBody = $this->responseBody(true, "GrnListController", "goodsReceivedReport", ["header" => $header, "body" => ["data" => $data]]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnListController", "goodsReceivedReport", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    private function getSupplier($id)
    {

        $supplier = Suppliers::find($id);
        if ($supplier) {
            return $supplier->supplier_name;
        }
        return "";
    }


    private function getReceivedBy($id)
    {

        $received = Employee::find($id);
        if ($received) {
            return $received->name_withinitial;
        }
        return "";
    }



    private function getDepartment($id)
    {

        $department = Department::find($id);
        if ($department) {
            return $department->department;
        }
        return "";
    }


    private function getStore($id)
    {
        $store = StoreLocation::find($id);
        if ($store) {
            return $store->name;
        }
        return "";
    }



    private function getType($id)
    {
        if ($id == 0) {
            return "General";
        } else if ($id == 1) {
            return "Production";
        } else if ($id == 2) {
            return "Maintenance";
        }
        return "";
    }



    private function getMachine($id)
    {
        $machine = Machinary::find($id);
        if ($machine) {
            return $machine->machinery_no;
        }
        return "";
    }

    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
