<?php

namespace Modules\Sc\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Exception;
use Modules\Sc\Entities\Product;
use Illuminate\Support\Facades\DB;

class NotificationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Renderable
     */
    public function getProductReorderNotification()
    {
        try{
            $query = "  SELECT 
                            st_products.product_primary_id,
                            st_products.product_name,
                            st_products.product_description,
                            st_products.reorder_quantity,
                            st_group_level_1.group_level_1,
                            st_group_level_2.group_level_2,
                            ROUND(COALESCE(ph.total_qty, 0), 2) as available_qty
                        FROM st_products
                        JOIN st_group_level_1 ON st_products.group_id_level_1 = st_group_level_1.group_level_1_id
                        JOIN st_group_level_2 ON st_products.group_id_level_2 = st_group_level_2.group_level_2_id
                        LEFT JOIN (
                            SELECT 
                                product_id,
                                SUM(quantity) as total_qty
                            FROM sc_product_histories 
                            GROUP BY product_id
                        ) ph ON st_products.product_primary_id = ph.product_id
                        WHERE ROUND(COALESCE(ph.total_qty, 0), 2) <= st_products.reorder_quantity
                        AND st_products.reorder_quantity > 0";

            $notifications = DB::select($query);

            if (empty($notifications)) {
                $responseBody = $this->responseBody(false, "NotificationController", "No Reorder Notification Found", []);
            } else {
                $responseBody = $this->responseBody(true, "NotificationController", "Reorder Notification Found", $notifications);
            }
        }
        catch (Exception $exception) {
        $responseBody = $this->responseBody(false, "NotificationController", "ReorderNotification", $exception);
    }
    return response()->json(["data" => $responseBody]);
    }


    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
  
}
