<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeDepartment;
use Modules\Sc\Entities\Department;
use Modules\Sc\Entities\PurchaseRequestData;
use Modules\Sc\Entities\PurchaseRequestHeader;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\Uom;

class PurchaseRequestListController extends Controller
{
    public function allPurchaseRequest()
    {
        try {
            $purchaseList = PurchaseRequestHeader::select('*')->orderBy('internal_id', 'DESC')->get();
            /*foreach ($purchaseList as $mi) {
                $employee = Employee::find($mi->request_by);
                $mi->request_by = $employee->name_withinitial;
            }*/
            $responseBody = $this->responseBody(true, "PurchaseRequestListController", "allPurchaseRequest", $purchaseList);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestListController", "allPurchaseRequest", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    public function allPr()
    {
        try {
            $pr_header =  PurchaseRequestHeader::where('status', '=', 1)->get();
            foreach ($pr_header as $pr) {
                $supervisor = Employee::find($pr->supervisor_id);
                $pr->reference = $pr->external_id;
                $pr->request = $pr->employee_name;
                $pr->date = $pr->trans_date;
                $pr->value1 = "0";
            }
            return $this->responseBody(true, "MaterialReturnController", "allPr", $pr_header);
        } catch (Exception $exception) {
            return $this->responseBody(false, "MaterialReturnController", "error", $exception);
        }
    }

    public function deletePurchaseRequest($id)
    {
        try {

            $purchase_data = PurchaseRequestData::where('internal_id', '=', $id)->get();
            foreach ($purchase_data as $data) {
                $data->delete();
            }

            $purchase_data = PurchaseRequestData::where('internal_id', '=', $id)->get();
            if (count($purchase_data) == 0) {
                $purchase = PurchaseRequestHeader::find($id);
                $purchase->delete();
            }

            $responseBody = $this->responseBody(true, "PurchaseRequestController", "delete", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function purchaseRequestReport($id)
    {
        try {
            $purchase_request_header = PurchaseRequestHeader::find($id);

            $header = [
                "referance_no" => "",
                "date" => "",
                "department" => "",
                "store" => "",
                "type" => "",
                "manufacturing_order" => "",
                "request_by" => "",
            ];


            if ($purchase_request_header) {
                $header["referance_no"] = $purchase_request_header->external_id;
                $header["date"] = $purchase_request_header->trans_date;
                // $header["request_by"] = $this->getRequestBy($purchase_request_header->request_by);
                $header["request_by"] = $purchase_request_header->employee_name;
                $header["department"] = $this->getDepartment($purchase_request_header->dept_id);
                $header["store"] = $this->getStore($purchase_request_header->store_id);
                $header["type"] = $this->getType($purchase_request_header->mi_type);
                $header["manufacturing_order"] = $purchase_request_header->manufacturing_order_number;
            }

            $data = PurchaseRequestData::where('internal_id', '=', $id)->get();
            foreach ($data as $dd) {
                $product = Product::find($dd->product_id);
                $dd->product_id = $product->product_id;
                $dd->product = $product->product_name;
                $uom = ProductUnit::find($dd->unit_id);
                if ($uom) {
                    $dd->unit = $uom->name;
                } else {
                    $dd->unit = "";
                }
            }


            $responseBody = $this->responseBody(true, "PurchaseRequestController", "purchaseRequestReport", ["header" => $header, "body" => ["data" => $data]]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "purchaseRequestReport", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    private function getRequestBy($id)
    {

        $request_by = Employee::find($id);
        if ($request_by) {
            return $request_by->name_withinitial;
        }
        return "";
    }



    private function getDepartment($id)
    {

        $department = EmployeeDepartment::find($id);
        if ($department) {
            return $department->department;
        }
        return "";
    }


    private function getStore($id)
    {
        $store = StoreLocation::find($id);
        if ($store) {
            return $store->name;
        }
        return "";
    }



    private function getType($id)
    {
        if ($id == 0) {
            return "General";
        } else if ($id == 1) {
            return "Production";
        } else if ($id == 2) {
            return "Maintenance";
        }
        return "";
    }



    public function change_status(Request $request, $id)
    {

        try {

            $pr_header = PurchaseRequestHeader::find($id);
            $pr_header->status = $request->get('status');
            $pr_header->update();

            $responseBody = $this->responseBody(true, "PurchaseRequestController", "change_status", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
