<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\GroupLevel1;
use Modules\St\Entities\GroupLevel2;
use Modules\St\Entities\GroupLevel3;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductType;

class StockReportController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('sc::index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('sc::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('sc::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('sc::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }




    public function allSettings()
    {

        try {
            $settings = [
                "site" => $this->site(),
                "stores" => $this->stores(),
                "producttype" => $this->producttype(),
                "grouplevel1" => $this->grouplevel1(),
                "grouplevel2" => $this->grouplevel2(),
                "grouplevel3" => $this->grouplevel3(),
                "productname" => $this->productname(),
            ];
            $responseBody = $this->responseBody(true, "AllSettings", "all", ["settings" => $settings]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AllSettings", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function site()
    {

        try {
            $site = EmployeeSite::all();
            $collection = [];
            for ($i = 0; $i < count($site); $i++) {
                array_push($collection, ["id" => $site[$i]['site_id'], "value" => $site[$i]['site']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    public function stores()
    {

        try {
            $store = StoreLocation::all();
            $collection = [];
            for ($i = 0; $i < count($store); $i++) {
                array_push($collection, ["id" => $store[$i]['id'], "value" => $store[$i]['name']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    public function producttype()
    {

        try {
            $type = ProductType::all();
            $collection = [];
            for ($i = 0; $i < count($type); $i++) {
                array_push($collection, ["id" => $type[$i]['product_type_id'], "value" => $type[$i]['product_type']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }



    public function grouplevel1()
    {

        try {
            $groupLevel = GroupLevel1::all();
            $collection = [];
            for ($i = 0; $i < count($groupLevel); $i++) {
                array_push($collection, ["id" => $groupLevel[$i]['group_level_1_id'], "value" => $groupLevel[$i]['group_level_1']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    public function grouplevel2()
    {

        try {
            $groupLevel = GroupLevel2::all();
            $collection = [];
            for ($i = 0; $i < count($groupLevel); $i++) {
                array_push($collection, ["id" => $groupLevel[$i]['group_level_2_id'], "value" => $groupLevel[$i]['group_level_2']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }



    public function grouplevel3()
    {

        try {
            $groupLevel = GroupLevel3::all();
            $collection = [];
            for ($i = 0; $i < count($groupLevel); $i++) {
                array_push($collection, ["id" => $groupLevel[$i]['group_level_3_id'], "value" => $groupLevel[$i]['group_level_3']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }



    public function productname()
    {

        try {
            $product = Product::all();
            $collection = [];
            for ($i = 0; $i < count($product); $i++) {
                array_push($collection, ["id" => $product[$i]['product_id'], "value" => $product[$i]['product_name']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }




    function stockBalanceReport($setting, $date_form, $date_to)
    {
        try {
            $title = '';
            $setting_aaray =  json_decode($setting);
            $site = $setting_aaray->site;
            $stores = $setting_aaray->stores;
            $producttype = $setting_aaray->producttype;
            $grouplevel1 = $setting_aaray->grouplevel1;
            $grouplevel2 = $setting_aaray->grouplevel2;
            $grouplevel3 = $setting_aaray->grouplevel3;
            $without0 = $setting_aaray->without0;
            $productname = $setting_aaray->productname;

            ini_set('max_execution_time', '0'); // for infinite time of execution

            $query = "SELECT st_products.product_id,
            sc_product_histories.external_id,
            st_products.product_name,
            st_product_units.`name` AS unit_of_mesurment,
            SUM(sc_product_histories.quantity) AS quantity 
            FROM sc_product_histories 
            INNER JOIN st_products ON sc_product_histories.product_id = st_products.product_primary_id
            INNER JOIN st_product_units ON sc_product_histories.unit_id = st_product_units.id WHERE  ";



            if ($stores != '') {
                $query .= "sc_product_histories.store_id = '" . $stores . "' AND ";
                $title = '';
            }

            if ($producttype != '') {
                $query .= "st_products.product_type_id = '" . $producttype . "' AND ";
                $title = '';
            }

            if ($grouplevel1 != '') {
                $query .= "st_products.group_id_level_1 = '" . $grouplevel1 . "' AND ";
                $title = '';
            }

            if ($grouplevel2 != '') {
                $query .= "st_products.group_id_level_2 = '" . $grouplevel2 . "' AND ";
                $title = '';
            }

            if ($grouplevel3 != '') {
                $query .= "st_products.group_id_level_3 = '" . $grouplevel3 . "' AND ";
                $title = '';
            }

            if ($productname != '') {
                $query .= "st_products.product_id = '" . $productname . "' AND ";
                $title = '';
            }

            

            $query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
            $query .= " GROUP BY sc_product_histories.product_id";

            $stockBalance = DB::select($query);
            $responseBody = $this->responseBody(true, $query, "Report", [
                'body' => $stockBalance,
                'title' => $title,
                "query" => $query,
            ]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "StockReportController", "Report", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    function stockBalanceAsAtReport($setting, $date_form, $date_to)
    {
        try {
            $title = '';
            $setting_aaray =  json_decode($setting);
            $site = $setting_aaray->site;
            $stores = $setting_aaray->stores;
            $producttype = $setting_aaray->producttype;
            $grouplevel1 = $setting_aaray->grouplevel1;
            $grouplevel2 = $setting_aaray->grouplevel2;
            $grouplevel3 = $setting_aaray->grouplevel3;
            $without0 = $setting_aaray->without0;
            $productname = $setting_aaray->productname;

            ini_set('max_execution_time', '0'); // for infinite time of execution

            $query = "SELECT st_products.product_id,
            sc_product_histories.external_id,
            st_products.product_name,
            st_product_units.`name` AS unit_of_mesurment,
            SUM(sc_product_histories.quantity) AS quantity 
            FROM sc_product_histories 
            INNER JOIN st_products ON sc_product_histories.product_id = st_products.product_primary_id
            INNER JOIN st_product_units ON sc_product_histories.unit_id = st_product_units.id WHERE  ";



            if ($stores != '') {
                $query .= "sc_product_histories.store_id = '" . $stores . "' AND ";
                $title = '';
            }

            if ($producttype != '') {
                $query .= "st_products.product_type_id = '" . $producttype . "' AND ";
                $title = '';
            }

            if ($grouplevel1 != '') {
                $query .= "st_products.group_id_level_1 = '" . $grouplevel1 . "' AND ";
                $title = '';
            }

            if ($grouplevel2 != '') {
                $query .= "st_products.group_id_level_2 = '" . $grouplevel2 . "' AND ";
                $title = '';
            }

            if ($grouplevel3 != '') {
                $query .= "st_products.group_id_level_3 = '" . $grouplevel3 . "' AND ";
                $title = '';
            }

            if ($productname != '') {
                $query .= "st_products.product_id = '" . $productname . "' AND ";
                $title = '';
            }

            if ($date_to != '') {
                $query .= "sc_product_histories.transaction_date <= '" . $date_to . "' AND ";
                $title = ''; 
            }

            

            $query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
            $query .= " GROUP BY sc_product_histories.product_id";

            $stockBalance = DB::select($query);
            $responseBody = $this->responseBody(true, $query, "Report", [
                'body' => $stockBalance,
                'title' => $title,
                "query" => $query,
            ]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "StockReportController", "Report", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    
    function purchaseOrderReport($setting, $date_form, $date_to)
    {
        try {
            $title = '';
            $setting_aaray =  json_decode($setting);
            $site = $setting_aaray->site;
            $stores = $setting_aaray->stores;
            $producttype = $setting_aaray->producttype;
            $grouplevel1 = $setting_aaray->grouplevel1;
            $grouplevel2 = $setting_aaray->grouplevel2;
            $grouplevel3 = $setting_aaray->grouplevel3;
            $without0 = $setting_aaray->without0;
            $productname = $setting_aaray->productname;

            ini_set('max_execution_time', '0'); // for infinite time of execution

            $query = "SELECT DISTINCT st_products.product_id,st_products.product_name,st_product_units.`name` AS unit_of_mesurment,SUM(sc_product_histories.quantity) AS quantity FROM st_products 
            INNER JOIN sc_product_histories ON st_products.product_id = sc_product_histories.product_id
            INNER JOIN st_product_units ON sc_product_histories.unit_id = st_product_units.id WHERE  ";



            if ($stores != '') {
                $query .= "sc_product_histories.store_id = '" . $stores . "' AND ";
                $title = '';
            }

            if ($producttype != '') {
                $query .= "st_products.product_type_id = '" . $producttype . "' AND ";
                $title = '';
            }

            if ($grouplevel1 != '') {
                $query .= "st_products.group_id_level_1 = '" . $grouplevel1 . "' AND ";
                $title = '';
            }

            if ($grouplevel2 != '') {
                $query .= "st_products.group_id_level_2 = '" . $grouplevel2 . "' AND ";
                $title = '';
            }

            if ($grouplevel3 != '') {
                $query .= "st_products.group_id_level_3 = '" . $grouplevel3 . "' AND ";
                $title = '';
            }

            if ($productname != '') {
                $query .= "st_products.product_id = '" . $productname . "' AND ";
                $title = '';
            }

            

            $query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
            $query .= " GROUP BY sc_product_histories.product_id";

            $stockBalance = DB::select($query);
            $responseBody = $this->responseBody(true, $query, "Report", [
                'body' => $stockBalance,
                'title' => $title,
                "report_date" => "(" . $date_form . " - " . $date_to . ")",
            ]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "StockReportController", "Report", $query);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
