$(document).ready(function () {
    loadReorderNotifications();
});


function loadReorderNotifications() {
    $.ajax({
        type: "GET",
        url: "/sc/NotificationController/getProductReorderNotification",
        success: function (response) {
            if (response.data.success) {
                console.log(response);
                const notifications = response.data.result;
                let count = notifications.length;
                let listHtml = '';

                notifications.forEach(item => {
                    listHtml += `
                        <li class="px-4 py-3 list-group-item">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1">
                                    <p class="mb-0 line-height-20 d-flex justify-content-between text-danger">
                                        🔔 <strong>${item.product_name}</strong> has low stock 
                                        <i title="Auto-generated" class="fa fa-circle font-size-11"></i>
                                    </p>
                                    <small class="text-muted">
                                        Available: ${item.available_qty}, Reorder level: ${item.reorder_quantity}
                                    </small>
                                </div>
                            </div>
                        </li>`;
                });

                // Inject notifications
                $('#notification_content').prepend(listHtml);
                $('#notify-count').text(count);
                $('#notification_count').text(`${count} unread notifications`);
            }
        },
        error: function (error) {
            console.error("Error loading reorder notifications", error);
        }
    });
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
