var action = "save";
var supplierChooser = null;
var productChooser = null;
var update_id = undefined;
var GR_MR_ID = undefined;
$(document).ready(function () {
    $('.status_btn').hide();

    $('input[name="date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });


    supplierChooser = $('#supplierChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
        ],
        columnDefs: [
            { width: 200, targets: 0 },
            { width: 300, targets: 1 },
        ],
    });
    var supplier_data = allSuppliers();
    //console.log(product_data);
    supplierChooser.setDataSource(supplier_data);


    supplierChooser.on('select', function (event, data) {
        var input = supplierChooser.getInput();
        input.focus();

        var supplier_id = data[0];
        var supplier_name = data[1];
        input.attr("data-id", supplier_id);
        input.val(supplier_name);

    });





    productChooser = $('#productChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
        ],
        columnDefs: [
            { width: 200, targets: 0 },
            { width: 300, targets: 1 },
        ],
    });

    var product_data = allProduct();
    console.log(product_data);
    productChooser.setDataSource(product_data);


    productChooser.on('select', function (event, data) {
        var input = productChooser.getInput();
        input.focus();

        var product_id = data[0];
        var product_name = data[1];
        input.attr("data-id", product_id);
        input.val(product_name);

    });


    $('input[name="firstWeightTime"]').daterangepicker({
        singleDatePicker: true,
        timePicker: true,
        startDate: moment().startOf('hour'),
        endDate: moment().startOf('hour').add(32, 'hour'),
        locale: {
            format: 'YYYY-MM-DD hh:mm:ss'
        }
    });


    $('input[name="secondWeightTime"]').daterangepicker({
        singleDatePicker: true,
        timePicker: true,
        startDate: moment().startOf('hour'),
        endDate: moment().startOf('hour').add(32, 'hour'),
        locale: {
            format: 'YYYY-MM-DD hh:mm:ss'
        }
    });



    allStores();
    sites();
    

    $('#cmbStores').on('change', function () {
        newReferanceID($(this).val());
    });

    $('#txtSupplier').on('input', function () {
        showSupplierChooser('txtSupplier');
    });


    $('#txtItem').on('input', function () {
        showProductChooser('txtItem');
    });

    newReferanceID($('#cmbStores').val());






    if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('?');
        var id = param[0].split('=')[1].split('&')[0];
        var action = param[0].split('=')[2].split('&')[0];
        GR_MR_ID = id;
        getSelectedGoodsReceivedMR(id);
        if (action == 'edit') {
            update_id = id;
            $('#btnAction').text('Update');
            $('.status_btn').hide();
        } else if (action == 'view') {
            $('#btnAction').hide();
            $('.status_btn').show();
        }



    }




    $('#btnAction').on('click', function () {


        if($('#dateMR').val().trim() == ''){
            showWarningMessage('Please enter date.');
            return;
        }

        if($('#txtSupplier').val().trim() == '' || $('#txtSupplier').attr('data-id') == ''){
            showWarningMessage('Please select supplier.');
            return;
        }


        if($('#txtItem').val().trim() == '' || $('#txtItem').attr('data-id') == ''){
            showWarningMessage('Please select item.');
            return;
        }

        if($('#txtFirstWeight').val().trim() == ''){
            showWarningMessage('Please enter first weight.');
            return;
        }

        if($('#txtSecondWeight').val().trim() == ''){
            showWarningMessage('Please enter second weight.');
            return;
        }


        if($('#txtReceivedBy').val().trim() == ''){
            showWarningMessage('Please enter received by.');
            return;
        }

        if ($(this).text() == 'Save') {
            save();
        }else if ($(this).text() == 'Update') {
            update(update_id);
        }

    });


    $('#btnApprove').on('click', function () {
        change_status_confirmation(GR_MR_ID, 1, "Are you sure want to approve?");
    });
    $('#btnReject').on('click', function () {
        change_status_confirmation(GR_MR_ID, 2, "Are you sure want to reject?");
    });







});




function showSupplierChooser(id) {
    supplierChooser.showChooser($('#' + id));
}

function showProductChooser(id) {
    productChooser.showChooser($('#' + id));
}


function newReferanceID(storeID) {
    var referanceID = newID("/sc/ReferenceIDController/goodsReceivedMrMaxID", storeID);
    $('#txtRefferance').val(referanceID);
}



function allStores() {
    $.ajax({
        type: "GET",
        url: "/sc/GoodsReceivedMrController/allStores",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbStores').append('<option value="' + res[i].id + '">' + res[i].name + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function sites() {
    $.ajax({
        type: 'GET',
        url: '/sc/GoodsReceivedMrController/sites',
        async: false,
        success: function (response) {
            console.log(response.data.result);
            $('#cmbSite').empty();
            if (response.data.success) {

                var html = '';
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.site_id + '">' + value.site + '</option>';
                })
                $('#cmbSite').html(html);
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}




function allSuppliers() {
    var product_data = [];
    $.ajax({
        type: "GET",
        url: "/sc/GoodsReceivedMrController/allSuppliers",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            product_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

    return product_data;
}




function allProduct() {
    var product_data = [];
    $.ajax({
        type: "GET",
        url: "/sc/GoodsReceivedMrController/allProduct",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            product_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

    return product_data;
}




function save() {
    newReferanceID($('#cmbStores').val());
    $.ajax({
        type: "POST",
        url: '/sc/GoodsReceivedMrController/save',
        data: {
            'refferance_no': $('#txtRefferance').val(),
            'trans_date': $('#dateMR').val(),
            'supplier_id': $('#txtSupplier').attr('data-id'),
            'received_by': $('#txtReceivedBy').val(),
            'site_id': $('#cmbSite').val(),
            'store_id': $('#cmbStores').val(),
            'supplier_reff_no': $('#txtSupplierReffNo').val(),
            'po_no': $('#txtPO').val(),
            'vehicle_no': $('#txtVehicleNO').val(),
            'driver_name': $('#txtDriver').val(),
            'weigh_bill_no': $('#txtWeighBillNo').val(),
            'product_primary_id': $('#txtItem').attr('data-id'),
            'first_weight': $('#txtFirstWeight').val(),
            'first_weight_time': $('#txtFirstWeightTime').val(),
            'second_weight': $('#txtSecondWeight').val(),
            'second_weight_time': $('#txtSecondWeightTime').val(),
            'net_weight': $('#txtNetWeight').val(),
            'comment': $('#txtComment').val(),
            'wastage': $('#txtWastage').val(),
            'moisture': $('#txtMoisture').val(),
            'sand': $('#txtSand').val(),
            'ec_level': $('#txtEClevel').val(),


        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Saved data.');
                $('#formMR').trigger("reset");
                newReferanceID($('#cmbStores').val());
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}






function update(id) {
    if(id == undefined){
        showWarningMessage('Invalied goods received m.r.');
        return;
    }
    $.ajax({
        type: "PUT",
        url: '/sc/GoodsReceivedMrController/update/'+id,
        data: {
            'refferance_no': $('#txtRefferance').val(),
            'trans_date': $('#dateMR').val(),
            'supplier_id': $('#txtSupplier').attr('data-id'),
            'received_by': $('#txtReceivedBy').val(),
            'site_id': $('#cmbSite').val(),
            'store_id': $('#cmbStores').val(),
            'supplier_reff_no': $('#txtSupplierReffNo').val(),
            'po_no': $('#txtPO').val(),
            'vehicle_no': $('#txtVehicleNO').val(),
            'driver_name': $('#txtDriver').val(),
            'weigh_bill_no': $('#txtWeighBillNo').val(),
            'product_primary_id': $('#txtItem').attr('data-id'),
            'first_weight': $('#txtFirstWeight').val(),
            'first_weight_time': $('#txtFirstWeightTime').val(),
            'second_weight': $('#txtSecondWeight').val(),
            'second_weight_time': $('#txtSecondWeightTime').val(),
            'net_weight': $('#txtNetWeight').val(),
            'comment': $('#txtComment').val(),
            'wastage': $('#txtWastage').val(),
            'moisture': $('#txtMoisture').val(),
            'sand': $('#txtSand').val(),
            'ec_level': $('#txtEClevel').val(),


        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Updated data.');
                $('#formMR').trigger("reset");
                location.href='/sc/goods_received_mr_list';
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}






function getSelectedGoodsReceivedMR(id) {
    $.ajax({
        type: "GET",
        url: "/sc/GoodsReceivedMrController/getSelectedGoodsReceivedMR/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            $('#txtRefferance').val(res.refferance_no);
            $('#dateMR').val(res.trans_date);
            $('#txtSupplier').attr('data-id', res.supplier_id);
            $('#txtSupplier').val(res.supplier_name);
            $('#txtReceivedBy').val(res.received_by);
            setSelectedOption('cmbSite', res.site_id);
            setSelectedOption('cmbStores', res.store_id);
            $('#txtSupplierReffNo').val(res.supplier_reff_no);
            $('#txtPO').val(res.po_no);
            $('#txtVehicleNO').val(res.vehicle_no);
            $('#txtDriver').val(res.driver_name);
            $('#txtWeighBillNo').val(res.weigh_bill_no);
            $('#txtItem').attr('data-id', res.product_primary_id);
            $('#txtItem').val(res.product_name);
            $('#txtFirstWeight').val(res.first_weight);
            $('#txtFirstWeightTime').val(res.first_weight_time);
            $('#txtSecondWeight').val(res.second_weight);
            $('#txtSecondWeightTime').val(res.second_weight_time);
            $('#txtNetWeight').val(res.net_weight);
            $('#txtComment').val(res.comment);
            $('#txtWastage').val(res.wastage);
            $('#txtMoisture').val(res.moisture);
            $('#txtSand').val(res.sand);
            $('#txtEClevel').val(res.ec_level);

        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}






function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}



function computeNetWeight(){
    
    var f_weight = parseFloat($('#txtFirstWeight').val());
    var s_weight = parseFloat($('#txtSecondWeight').val());

    var n_weight = 0;
    $('#txtNetWeight').val(n_weight);

    if(!isNaN(f_weight) && !isNaN(s_weight)){
        n_weight = f_weight - s_weight;
    }

    if(!isNaN(n_weight)){
        $('#txtNetWeight').val(Math.abs(n_weight));
    }else{
        $('#txtNetWeight').val(0);
    }
}




function change_status_confirmation(id, status, msg) {
    swal({
        title: msg,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                change_status(id, status);
            }
        });

}

function change_status(id, status) {

    $.ajax({
        type: "PUT",
        url: '/sc/GoodsReceivedMrController/change_status/' + id,
        data: {
            status: status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            // document.getElementById('btnApproveGrn').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                if (status == 1) {
                    toastr.success("Goods Received M.R approved.");
                } else if (status == 2) {
                    toastr.success("Goods Received M.R rejected.");
                }

            } else {
                showErrorMessage();
            }
            location.href = '/sc/goods_received_mr_list';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
            // document.getElementById('approve'+id).innerHTML = '<i class="fa fa-times" aria-hidden="true"></i>';
        }

    });
}




/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}


