$(document).ready(function () {

    var table = $('#tableMR').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "reference_no" },
            { "data": "supplier" },
            { "data": "date" },
            { "data": "item" },
            { "data": "quantity" },
            { "data": "edit" },
            { "data": "view" },
            { "data": "approve"},
            { "data": "delete", },
        ],
        columnDefs: [
            { width: 150, targets: 0 },
            { width: 100, targets: 2 },
            { width: 100, targets: 4 },
            { width: 30, targets: 5 },
            { width: 30, targets: 6 },
            { width: 30, targets: 7 },
            { width: 30, targets: 8 },
        ],
    });
    //table.column(7).visible(false);

    allGoodsReceivedMR();

});



function allGoodsReceivedMR() {
    $.ajax({
        type: "GET",
        url: "/sc/GoodsReceivedMrListController/allGoodsReceivedMR",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['internal_id'];
                    var reference_no = response.data.result[i]['refferance_no'];
                    var supplier_name = response.data.result[i]['supplier_name'];
                    var date = response.data.result[i]['trans_date'];
                    var item_name = response.data.result[i]['product_name'];
                    var wastage = response.data.result[i]['wastage'];
                    var status = response.data.result[i]['status'];
                    var string_id = "'" + id + "'";

                    var approve_icon = '';
                    var disabled = "";
                    if (status == 1) {
                        approve_icon = '<i class="fa fa-check-circle-o fa-3x text-success" aria-hidden="true"></i>';
                        disabled = "disabled";
                    } else if (status == 2) {
                        approve_icon = '<i class="fa fa-times-circle-o fa-3x text-danger" aria-hidden="true"></i>';
                        disabled = "disabled";
                    }

                    data.push({
                        "reference_no": reference_no,
                        "supplier": supplier_name,
                        "date": date,
                        "item": item_name,
                        "quantity": wastage,
                        "edit": '<button class="btn btn-primary" onclick="edit(' + string_id + ')" '+disabled+'><i class="fa fa-pencil" aria-hidden="true"></i></button>',
                        "view": '<button class="btn btn-success" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        "approve": approve_icon,
                        "delete": '<button class="btn btn-danger" onclick="delete_confirmation(' + string_id + ')" '+disabled+'><i class="fa fa-trash" aria-hidden="true"></i></button>'
                    });
                }

                var table = $('#tableMR').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },

        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function edit(id) {
    location.href = "/sc/goods_received_mr?id=" + id + "&action=edit";
}



function view(id) {
    location.href = "/sc/goods_received_mr?id=" + id + "&action=view";
}



function _delete(id){

    $.ajax({
        type: 'DELETE',
        url: '/sc/GoodsReceivedMrListController/delete/' + id,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Data has been deleted successfully...")
                allGoodsReceivedMR();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    }); 
}


function delete_confirmation(id) {
    swal({
        title: "Are you sure want delete?",
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                _delete(id);
            }
        });

}




/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
