$(document).ready(function () {

    var table = $('#myTable').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "reference_no" },
            { "data": "store_from" },
            { "data": "store_to" },
            { "data": "date" },
            { "data": "approve", className: "approve" },
            { "data": "reject", className: "reject" },
            { "data": "approve_status", className: "approve_status" },
        ],
        columnDefs: [
            { width: 200, targets: 0 },
            { width: 200, targets: 3 },
            { width: 30, targets: 4 },
            { width: 30, targets: 5 },
        ],
    });

    allGoodsTransfer();

});


function allGoodsTransfer() {
    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferListController/allGoodsTransfer",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['internal_id'];
                    var reference_no = response.data.result[i]['external_id'];
                    var store_from = response.data.result[i]['store_from'];
                    var store_to = response.data.result[i]['store_to'];
                    var date = response.data.result[i]['trans_date'];
                    var status = response.data.result[i]['status'];
                    var string_id = "'" + id + "'";

                    var approve_icon = '';
                    var disabled = "";
                    var disable_reject = "";
                    if (status == 1) {
                        approve_icon = '<i class="fa fa-check-circle-o fa-3x text-success" aria-hidden="true"></i>';
                        disabled = "disabled";
                    } else if (status == 2) {
                        approve_icon = '<i class="fa fa-times-circle-o fa-3x text-danger" aria-hidden="true"></i>';
                        disabled = "disabled";
                        disable_reject = "disabled"
                    }

                    data.push({
                        "reference_no": reference_no,
                        "store_from": store_from,
                        "store_to": store_to,
                        "date": date,
                        "approve": `<button class="btn btn-success" onclick="change_status_confirmation('${id}', 1,'Are you sure want to approve?')" ${disabled}>
                            Approve
                            </button > `,
                        "reject": ` <button class="btn btn-danger" onclick="change_status_confirmation('${id}', 2,'Are you sure want to reject?')" ${disable_reject}>
                            Reject
                            </button>`,
                        "approve_status":approve_icon,
                    });
                }

                var table = $('#myTable').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },

        error: function (error) {
            console.log(error);
        },
        
    });
}


function change_status_confirmation(id, status, msg) {
    swal({
        title: msg,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                change_status(id, status);
            }
        });

}

function change_status(id, status) {

    $.ajax({
        type: "PUT",
        url: '/sc/GoodsTransferController/change_status/' + id,
        data: {
            status: status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                if (status == 1) {
                    toastr.success("Goods Transfer approved.");
                } else if (status == 2) {
                    toastr.success("Goods Transfer rejected.");
                }

            } else {
                showErrorMessage();
            }
            location.href = '/sc/goods_transfer_approval';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {}
    });
}


/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}


/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}



