
var action = "save";
var tableData = undefined;
var tableOther = undefined;
var MI_ID = undefined;
var PRODUCT_ID = undefined;

$(document).ready(function () {
    $('.status_btn').hide();

    var productChooser = $('#productChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
            { "data": "value1" },
        ],
        columnDefs: [
            { width: 50, targets: 0 },
            { width: 200, targets: 1 },
            { width: 300, targets: 2 },
        ],
    });

    var product_data = allProduct();
    console.log(product_data);
    productChooser.setDataSource(product_data);




    tableData = $('#tblData').transactionTable({
        thead: ['ProductPrimaryID', 'ProductID', 'Product Name', 'Unit', 'Qty', 'Comment','Transfer Qty','Issued Qty','Status', 'Remove'],
        data_chooser: [{ 'col': 2 }],
        chooser: productChooser,
        column_def: { 1: 100 },
        auto_focus: 2,
        row_type: [
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '100%' },
            {
                'type': 'select', 'value': [], 'align': 'left', 'width': '100px'
            },
            { 'type': 'text', 'value': '', 'align': 'right', 'width': '80px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '200px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '80px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '80px' },
            { 'type': 'icon', 'value': '', 'align': 'left', 'width': '80px' },
            { 'type': 'remove', 'value': 'X', 'align': 'center', 'width': '50px' }],
    });



    tableOther = $('#tblOther').transactionTable({
        thead: ['', 'Description', 'Quantity', 'Remove'],
        auto_focus: 1,
        row_type: [
            { 'type': 'text', 'value': '' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '100%' },
            { 'type': 'text', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'remove', 'value': 'X', 'align': 'center', 'width': '50px' }],
    });




    productChooser.on('select', function (event, data) {
        var selected_row = tableData.getSelectedRow();
        var cells = selected_row.getElementsByTagName('td');
        cells[0].childNodes[0].value = data[0];
        cells[1].childNodes[0].value = data[1];
        cells[2].childNodes[0].value = data[2];
        var input = productChooser.getInput();
        input.focus();


        var product_id = data[0];
        var uom = getProduct_Uom(product_id);
        $('#' + cells[3].childNodes[0].id).empty();
        $('#' + cells[3].childNodes[0].id).append('<option value="' + uom.id + '">' + uom.value + '</option>');
    });






    $('input[name="trans_date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });

    //allEmployees();
    allDepartment();
    allStores();
    allMachine();
    newReferanceID($('#cmbStores').val());
    checkDisableType(0);
    allMaterialRequestReason();




    $('#cmbMiType').on('change', function () {
        checkDisableType($(this).val());
    });



    $('#btnSave').on('click', function () {


        if ($(this).text() == 'Save') {
            saveMaterialRequisition();
        } else {
            updateMaterialRequisition();
        }
    });




    if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('?');
        var id = param[0].split('=')[1].split('&')[0];
        action = param[0].split('=')[2].split('&')[0];
        MI_ID = id;
        getMaterialRequisition(id);
        if (action == 'edit') {
            $('#btnSave').text('Update');
            $('.status_btn').hide();
        } else if (action == 'view') {
            $('#btnSave').hide();
            $('.status_btn').hide();
        } else if (action == 'approval') {
            $('#btnSave').hide();
            $('.status_btn').show();
        }

    } else {
        tableData.add_empty_row();
        tableOther.add_empty_row();
    }



    $('#cmbStores').on('change', function () {
        newReferanceID($(this).val());
    });

    $('#btnRetrieveMR').hide();

    $('#cmbMiType').on('change', function () {

        if ($(this).val() == '3') {
            $('#txtVehicleNo').prop('disabled', false);
        } else if ($(this).val() == '1') {
            $('#btnRetrieveMR').show();
        } else {
            $('#txtVehicleNo').prop('disabled', true);
            $('#txtVehicleNo').val('');
            $('#btnRetrieveMR').hide();
        }
    });

    $('#btnRetrieveMR').on('click', function () {

        showMaterialModal('', '', '');
    });



    $('#btnApprove').on('click', function () {
        change_status_confirmation(MI_ID, 1, "Are you sure want to approve?");
    });
    $('#btnReject').on('click', function () {
        change_status_confirmation(MI_ID, 2, "Are you sure want to reject?");
    });



});



function checkDisableType(id) {
    if (id == 1) {
        $('#cmbManufacturingOrder').prop("disabled", false);
        $('#cmbProjectCode').prop("disabled", true);
        $('#cmbProjectCode').empty();
        allManufacturingOrder();
    } else if (id == 2) {
        $('#cmbProjectCode').prop("disabled", false);
        $('#cmbManufacturingOrder').prop("disabled", true);
        $('#cmbManufacturingOrder').empty();
        allProjects();
    } else {
        $('#cmbManufacturingOrder').prop("disabled", true);
        $('#cmbManufacturingOrder').empty();
        $('#cmbProjectCode').prop("disabled", true);
        $('#cmbProjectCode').empty();
    }
}



function allEmployees() {
    $.ajax({
        type: "GET",
        url: "/sc/materialRequisitionController/allEmployees",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            //$('#txtSupervisor').setData(res);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function allProjects() {
    $.ajax({
        type: "GET",
        url: "/sc/materialRequisitionController/allProjects",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                var code = res[i].code + " - " + res[i].name;
                $('#cmbProjectCode').append('<option value="' + res[i].project_id + '">' + code + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function allDepartment() {
    $.ajax({
        type: "GET",
        url: "/sc/materialRequisitionController/allDepartment",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbDepartment').append('<option value="' + res[i].department_id + '">' + res[i].department + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function allStores() {
    $.ajax({
        type: "GET",
        url: "/sc/materialRequisitionController/allStores",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbStores').append('<option value="' + res[i].id + '">' + res[i].name + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function newReferanceID(storeID) {
    var referanceID = newID("/sc/ReferenceIDController/materialRequisitionMaxIDMaxID", storeID);
    $('#txtExternal_id').val(referanceID);
}





function allManufacturingOrder() {

    $.ajax({
        type: "GET",
        url: "/sc/materialRequisitionController/getScheduledFactoryPO",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            $('#cmbManufacturingOrder').empty();
            for (var i = 0; i < res.length; i++) {
                var manufacturing_num = res[i].factory_po_num + '-' + res[i].product_name;
                $('#cmbManufacturingOrder').append('<option value="' + res[i].customer_order_plan_id + '">' + manufacturing_num + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}





function allMachine() {
    $.ajax({
        type: "GET",
        url: "/sc/materialRequisitionController/allMachine",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbMachine').append('<option value="' + res[i].machinery_id + '">' + res[i].machinery_no + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function allMaterialRequestReason() {
    $.ajax({
        type: "GET",
        url: "/sc/materialRequisitionController/allMaterialRequestReason",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbReason').append('<option value="' + res[i].material_request_reason_id + '">' + res[i].reason + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function allProduct() {
    var product_data = [];
    $.ajax({
        type: "GET",
        url: "/sc/materialRequisitionController/allProduct",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            product_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

    return product_data;
}




function saveMaterialRequisition() {

    newReferanceID($('#cmbStores').val());
    if ($('#txtSupervisor').val() == '') {
        showWarningMessage("Please Enter Supervisor");
        return;
    }
    var mrq_data = {};
    var mrq_data_arr = tableData.dataSource();

    if (mrq_data_arr.length == 0) {
        showWarningMessage("Invalied Material Request (Empty list)");
        return;
    }

    for (var i = 0; i < mrq_data_arr.length; i++) {
        if (!mrq_data_arr[i][0]) {
            showWarningMessage("You shuld fill empty row in The list");
            return;
        }
        if (!mrq_data_arr[i][3]) {
            showWarningMessage(mrq_data_arr[i][1] + " Invalied Quantity");
            return;
        }
        mrq_data[i] = JSON.stringify({ "product_id": mrq_data_arr[i][0], "product_name": mrq_data_arr[i][2], "unit_id": mrq_data_arr[i][3], "qty": mrq_data_arr[i][4], "comments": mrq_data_arr[i][5], });
    }

    var request_other = {};
    var requeat_other_arr = tableOther.dataSource();
    for (var i = 0; i < requeat_other_arr.length; i++) {
        request_other[i] = { "description": requeat_other_arr[i][1], "quantity": requeat_other_arr[i][2] };
    }


    $.ajax({
        type: "POST",
        url: '/sc/materialRequisitionController/save',
        data: {
            'external_id': $('#txtExternal_id').val(),
            'ref_external_id': $('#txtExternal_id').val(),
            'trans_date': $('#txtGrnDate').val(),
            'dept_id': $('#cmbDepartment').val(),
            'machine_id': '',
            'store_id': $('#cmbStores').val(),
            'employee_name': $('#txtSupervisor').val(),
            'mr_internal_id': '0',
            'mr_extenal_id': '0',
            'mi_type': $('#cmbMiType').val(),
            'manufacturing_order_number': '',
            'customer_order_plan_id': $('#cmbManufacturingOrder').val(),
            'reason': $('#cmbReason').val(),
            'project_code': $('#cmbProjectCode').val(),
            'remarks': $('#txtRemarks').val(),
            'vehicle_no': $('#txtVehicleNo').val(),
            'mrq_data': mrq_data,
            'request_other': request_other,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            toastr.success('data saved');
            location.href = '/sc/materialRequisition';
            //location.reload();

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}



function getMaterialRequisition(id) {
    $.ajax({
        type: "GET",
        url: "/sc/materialRequisitionController/getMaterialRequisition/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            grn_id = res.internal_id
            referanceID = res.external_id;

            $('#txtExternal_id').val(res.external_id);
            $('#txtGrnDate').val(res.trans_date);
            setSelectedOption('cmbDepartment', res.dept_id);
            //setSelectedOption('cmbMachine', res.machine_id);
            $('#txtSupervisor').val(res.employee_name);
            $('#txtRemarks').val(res.remarks);
            $('#txtVehicleNo').val(res.vehicle_no);
            var mr_internal_id = res.mr_internal_id;
            var mr_extenal_id = res.mr_extenal_id;
            setSelectedOption('cmbStores', res.store_id);
            setSelectedOption('cmbMiType', res.mi_type);
            $('#cmbMiType').change();
            setSelectedOption('cmbReason', res.material_request_reason_id);
            if (res.mi_type == 1) {
                setSelectedOption('cmbManufacturingOrder', res.customer_order_plan_id);
            } else if (res.mi_type == 2) {
                allProjects();
                setSelectedOption('cmbProjectCode', res.project_code);
            }
            //checkDisableType(res.mi_type);
            if (res.mi_type == 3) {
                $('#txtVehicleNo').prop('disabled', false);
            }

            

            var request_data = res.data;

            for (var i = 0; i < request_data.length; i++) {

                
                var approve_icon = '';
                if(request_data[i].status == 1){
                    approve_icon = '<i class="fa fa-check-circle-o fa-3x text-success" aria-hidden="true"></i>';
                }else if(request_data[i].status == 2){
                    approve_icon = '<i class="fa fa-times-circle-o fa-3x text-danger" aria-hidden="true"></i>';
                }

                tableData.addRow(
                    [
                        { 'type': 'string', 'val': request_data[i].product_primary_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'string', 'val': request_data[i].product_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].product, 'align': 'left', 'width': '100%' },
                        {
                            'type': 'select', 'val': request_data[i].uom, 'align': 'left', 'width': '100px'
                        },
                        { 'type': 'text', 'val': request_data[i].quantity, 'align': 'right', 'width': '80px' },
                        { 'type': 'text', 'val': request_data[i].comments, 'align': 'left', 'width': '200px' },
                        { 'type': 'text', 'val': request_data[i].transfer_quantity, 'align': 'right', 'width': '80px' },
                        { 'type': 'text', 'val': request_data[i].issues_quantity, 'align': 'right', 'width': '80px' },
                        { 'type': 'icon', 'val': approve_icon, 'align': 'left', 'width': '80px' },
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );
            }


            var request_other = res.request_other;
            //console.log(request_other);
            for (var i = 0; i < request_other.length; i++) {
                var description = request_other[i].description;
                if (description == null) {
                    description = "";
                }
                var quantity = request_other[i].quantity;
                if (quantity == null) {
                    quantity = "";
                }
                tableOther.addRow(
                    [
                        { 'type': 'text', 'val': '' },
                        { 'type': 'text', 'val': description, 'align': 'left', 'width': '100%' },
                        { 'type': 'text', 'val': quantity, 'align': 'right', 'width': '100px' },
                        /*{ 'type': 'text', 'val': request_other[i].price },
                        { 'type': 'text', 'val': request_other[i].discount },
                        { 'type': 'string', 'val': request_other[i].value },*/
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );
            }

        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

}





function updateMaterialRequisition() {

    if ($('#txtSupervisor').val() == '') {
        showWarningMessage("Please Enter Supervisor");
        return;
    }
    var mrq_data = {};
    var mrq_data_arr = tableData.dataSource();
    if (mrq_data_arr.length == 0) {
        showWarningMessage("Invalied Material Request (Empty list)");
        return;
    }
    for (var i = 0; i < mrq_data_arr.length; i++) {
        if (!mrq_data_arr[i][0]) {
            showWarningMessage("You shuld fill empty row in The list");
            return;
        }
        if (!mrq_data_arr[i][3]) {
            showWarningMessage(mrq_data_arr[i][1] + " Invalied Quantity");
            return;
        }
        mrq_data[i] = JSON.stringify({ "product_id": mrq_data_arr[i][0], "product_name": mrq_data_arr[i][2], "unit_id": mrq_data_arr[i][3], "qty": mrq_data_arr[i][4], "comments": mrq_data_arr[i][5], });
    }

    var request_other = {};
    var requeat_other_arr = tableOther.dataSource();
    for (var i = 0; i < requeat_other_arr.length; i++) {
        request_other[i] = { "description": requeat_other_arr[i][1], "quantity": requeat_other_arr[i][2] };
    }


    if (MI_ID == undefined) {
        showWarningMessage('Material Issue not selected...!');
        return;
    }

    $.ajax({
        type: "PUT",
        url: '/sc/materialRequisitionController/update/' + MI_ID,
        data: {
            'external_id': $('#txtExternal_id').val(),
            'ref_external_id': $('#txtExternal_id').val(),
            'trans_date': $('#txtGrnDate').val(),
            'dept_id': $('#cmbDepartment').val(),
            'machine_id': '',
            'store_id': $('#cmbStores').val(),
            'employee_name': $('#txtSupervisor').val(),
            'mr_internal_id': '0',
            'mr_extenal_id': '0',
            'mi_type': $('#cmbMiType').val(),
            'manufacturing_order_number': '',
            'customer_order_plan_id': $('#cmbManufacturingOrder').val(),
            'reason': $('#cmbReason').val(),
            'project_code': $('#cmbProjectCode').val(),
            'remarks': $('#txtRemarks').val(),
            'vehicle_no': $('#txtVehicleNo').val(),
            'mrq_data': mrq_data,
            'request_other': request_other,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            toastr.success('data updated');
            location.href = '/sc/materialRequisitionList';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}





function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}





function getProduct_Uom(id) {
    var unit = undefined;
    $.ajax({
        type: "GET",
        url: "/sc/materialRequisitionController/getUom/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            unit = response.data.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return unit;
}


function triggerRowInputs(id, selected_row) {

    /*if (id == "tblData") {
        var cells = selected_row.getElementsByTagName('td');
        var product = $('#' + cells[0].childNodes[0].id);
        var quantity = $('#' + cells[3].childNodes[0].id);
        quantity.on('input', function () {
            var av_qty = getAvailableQty(product.val(), $('#cmbStores').val());
            var qty = parseFloat(quantity.val());
            if (qty > av_qty) {
                showAlert("Available quantity is " + av_qty);
                quantity.val(av_qty);
            }
        });
    }*/

}




function getAvailableQty(product_id, store_id) {
    var qty = 0;
    $.ajax({
        type: "GET",
        url: "/sc/materialRequisitionController/getQty/" + product_id + "/" + store_id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            qty = response.data.result;
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {

        }

    });
    return qty;
}



function showAlert(message) {
    swal({
        title: message,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    });

    $('.swal-button').on('click', function () {

    });

}


function showMaterialModal(order_id, product_id, machine_id) {


    var bomModal = new BomModal($('#bomModalDiv'));
    //bomModal.getSelectedModalData(order_id, product_id, machine_id);
    bomModal.show();
    getScheduledFactoryPO();

    $('#cmbFactoryPO').on('change', function () {
        //getProductFromOrder($(this).val());
        //$('#cmbProduct').change();
        getBomHeader($('#cmbFactoryPO').val());
    });

    $('#cmbFactoryPO').change();


    /*$('#cmbProduct').on('change', function () {
        getBomHeader($('#cmbFactoryPO').val(), $(this).val());
    });*/

    $('#cmbProduct').change();

    $('#btnGetBOM').on('click', function () {
        setSelectedOption('cmbManufacturingOrder', $('#cmbFactoryPO').val());
        $('#cmbManufacturingOrder').prop("disabled", true);
        setScheduleBom($(this).attr('data-id'), PRODUCT_ID);
    });

}



function getScheduledFactoryPO() {

    $.ajax({
        type: "GET",
        url: "/sc/materialRequisitionController/getScheduledFactoryPO",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            $('#cmbFactoryPO').empty();
            for (var i = 0; i < res.length; i++) {
                console.log(res[i].order_id);
                var manufacturing_num = res[i].factory_po_num + '-' + res[i].product_name;
                $('#cmbFactoryPO').append('<option value="' + res[i].customer_order_plan_id + '">' + manufacturing_num + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function getProductFromOrder(id) {

    $.ajax({
        type: "GET",
        url: "/sc/materialRequisitionController/getProductFromOrder/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            $('#cmbProduct').empty();
            for (var i = 0; i < res.length; i++) {
                console.log(res[i].order_id);
                $('#cmbProduct').append('<option value="' + res[i].product_primary_id + '">' + res[i].product_id + '-' + res[i].product_name + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function getBomHeader(order_id) {

    $('#lblProductName').text("");
    $('#lblBOMCustomerPO').text("");
    $('#lblBOMAllocateQty').text("0");
    $('#lblBOMProductionQty').text("0");
    $.ajax({
        type: "GET",
        url: "/sc/materialRequisitionController/getBomHeader/" + order_id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            PRODUCT_ID = res.product_id;
            var allocated_quantity = res.allocated_quantity;
            var bom_header_quantity = res.bom_header_quantity;
            var bom_data = res.bom_data;
            console.log(bom_data);

            $('#lblProductName').text(res.product_name);
            $('#lblBOMCustomerPO').text(res.customer_po);
            $('#lblBOMAllocateQty').text(allocated_quantity);
            $('#lblBOMProductionQty').text(bom_header_quantity);
            $('#btnGetBOM').attr('data-id', res.customer_order_plan_data_id);


            $('#tblMaterialBOM').empty();
            for (var i = 0; i < bom_data.length; i++) {
                var material_id = bom_data[i]['product_id'];
                var material = bom_data[i]['product_name'];
                var uom = bom_data[i]['uom_name'];
                var requirment = parseFloat(bom_data[i]['quantity']).toFixed(2);
                if (isNaN(requirment)) {
                    requirment = 0.00;
                }
                var stock_in_hand = parseFloat(bom_data[i]['stock_in_h']).toFixed(2);
                if (isNaN(stock_in_hand)) {
                    stock_in_hand = 0.00;
                }
                var pending_order = 0;
                var field_operation = 0;
                var shortage = 0;

                var row = '<tr><td>' + material_id + '</td>';
                row += '<td>' + material + '</td>';
                row += '<td>' + uom + '</td>';
                row += '<td style="text-align:right;">' + requirment + '</td>';
                row += '<td style="text-align:right;">' + stock_in_hand + '</td>';
                row += '<td style="text-align:right;">' + pending_order + '</td>';
                //row += '<td style="text-align:right;">' + field_operation + '</td>';
                row += '<td>' + shortage + '</td></tr>';
                if (material) {
                    $('#tblMaterialBOM').append(row);
                }
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}





function setScheduleBom(order_data_id, fg_product_id) {

    $.ajax({
        type: "GET",
        url: "/sc/materialRequisitionController/setScheduleBom/" + order_data_id + "/" + fg_product_id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var request_data = response.data.result;
            console.log(request_data);
            tableData.clear();
            for (var i = 0; i < request_data.length; i++) {
                tableData.addRow(
                    [
                        { 'type': 'string', 'val': request_data[i].product_primary_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'string', 'val': request_data[i].product_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].product_name, 'align': 'left', 'width': '100%' },
                        {
                            'type': 'select', 'val': request_data[i].uom, 'align': 'left', 'width': '100px'
                        },
                        { 'type': 'text', 'val': request_data[i].quantity, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': '', 'align': 'left', 'width': '200px' },
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );
            }

        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

}




function change_status_confirmation(id, status, msg) {
    swal({
        title: msg,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                change_status(id, status);
            }
        });

}

function change_status(id, status) {

    $.ajax({
        type: "PUT",
        url: '/sc/materialRequisitionListController/change_status/' + id,
        data: {
            status: status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            // document.getElementById('btnApproveGrn').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                if (status == 1) {
                    toastr.success("Material Requisition approved.");
                } else if (status == 2) {
                    toastr.success("Material Requisition rejected.");
                }

            } else {
                showErrorMessage();
            }
            location.href = '/sc/material_requisition_approval_list';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
            // document.getElementById('approve'+id).innerHTML = '<i class="fa fa-times" aria-hidden="true"></i>';
        }

    });
}




/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "0000",
        2: "000",
        3: "00",
        4: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}