
var action = "save";
var tableData = undefined;
var tableOther = undefined;
var PURCHASE_REQUEST_ID = undefined;
const TOKEN = Math.floor(Math.random() * 212345);
$(document).ready(function () {
    $('.status_btn').hide();
    $('#cmbManufacturingOrder').select2();

    $('#tblPurchaseRequestAttachment').DataTable({
        responsive: true,
        "order": [],
        "columns": [
            { "data": "file" },
            { "data": "view" },
            { "data": "download" },
            { "data": "delete" },
        ],
        columnDefs: [
            { width: 80, targets: 1 },
            { width: 80, targets: 2 },
            { width: 80, targets: 3 },
        ],
    });

    $('#attachmnet_token').val(TOKEN);

    $('#btnAttachment').on('click', function () {
        $('#attachmentAddModal').modal('toggle');
        //showWarningMessage('Please save purchase order to before upload attachmnet...!');
    });

    var productChooser = $('#productChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
            { "data": "value1" },
        ],
        columnDefs: [
            { width: 200, targets: 1 },
            { width: 300, targets: 2 },
        ],
    });

    var product_data = allProduct();
    console.log(product_data);
    productChooser.setDataSource(product_data);




    tableData = $('#tblData').transactionTable({
        thead: ['ProductPrimaryID','ProductID', 'Product Name', 'Unit', 'Qty', 'Comment', 'Remove'],
        data_chooser: [{ 'col': 2 }],
        chooser: productChooser,
        // column_def: { 0: 100 },
        auto_focus: 2,
        row_type: [
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '100%' },
            {
                'type': 'select', 'value': [], 'align': 'left', 'width': '100px'
            },
            { 'type': 'text', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '300px' },
            { 'type': 'remove', 'value': 'X', 'align': 'center', 'width': '50px' }],
    });




    productChooser.on('select', function (event, data) {
        var selected_row = tableData.getSelectedRow();
        var cells = selected_row.getElementsByTagName('td');
        cells[0].childNodes[0].value = data[0];
        cells[1].childNodes[0].value = data[1];
        cells[2].childNodes[0].value = data[2];
        var input = productChooser.getInput();
        input.focus();


        var product_id = data[0];
        var uom = getProduct_Uom(product_id);
        $('#' + cells[3].childNodes[0].id).empty();
        $('#' + cells[3].childNodes[0].id).append('<option value="' + uom.id + '">' + uom.value + '</option>');
    });






    tableOther = $('#tblOther').transactionTable({
        thead: ['','Description', 'Quantity', 'Remove'],
        //data_chooser: [{ 'col': 1 }],
        //chooser : supplerChooser,
        //column_def: { 1: 200, 2: 100 },
        auto_focus: 1,
        row_type: [
            { 'type': 'text', 'value': ''},
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '100%' },
            { 'type': 'text', 'value': '', 'align': 'right', 'width': '100px' },
            /*{ 'type': 'text', 'value': '' },
            { 'type': 'text', 'value': '' },
            { 'type': 'string', 'value': '' },*/
            { 'type': 'remove', 'value': 'X', 'align': 'center', 'width': '50px' }],
    });


    $('input[name="trans_date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });

    //allEmployees();
    allDepartment();
    allStores();
    newReferanceID($('#cmbStores').val());
    checkDisableType(0);




    $('#cmbMiType').on('change', function () {
        checkDisableType($(this).val());
    });



    $('#btnSave').on('click', function () {


        if ($(this).text() == 'Save') {
            savePurchaseRequestHeader();
        } else {
            updatePurchaseRequestHeader();
        }
    });




    if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('?');
        var id = param[0].split('=')[1].split('&')[0];
        action = param[0].split('=')[2].split('&')[0];
        getPurchaseRequest(id);
        if (action == 'edit') {
            $('#btnSave').text('Update');
            $('.status_btn').hide();
        } else if (action == 'view') {
            $('#btnSave').hide();
            $('.status_btn').show();
        }

    } else {
        tableData.add_empty_row();
        tableOther.add_empty_row();
    }


    $('#cmbStores').on('change', function () {
        newReferanceID($(this).val());
    });

    $('#btnApprove').on('click', function () {
        change_status_confirmation(PURCHASE_REQUEST_ID, 1, "Are you sure want to approve?");
    });
    $('#btnReject').on('click', function () {
        change_status_confirmation(PURCHASE_REQUEST_ID, 2, "Are you sure want to reject?");
    });



});




Dropzone.options.myDropzone = {
    dictDefaultMessage: 'Drop file here or click to upload!!!!!!!!',
    addRemoveLinks: true,
    init: function () {
        this.on("complete", function (file) {
            allAttachment(1, TOKEN);
        });
    }
};



function checkDisableType(id) {
    if (id == 1) {
        $('#cmbManufacturingOrder').prop("disabled", false);
        $('#cmbProjectCode').prop("disabled", true);
        $('#cmbProjectCode').empty();
        allManufacturingOrder();
    } else if (id == 2) {
        $('#cmbProjectCode').prop("disabled", false);
        $('#cmbManufacturingOrder').prop("disabled", true);
        $('#cmbManufacturingOrder').empty();
        allProjects();
    } else {
        $('#cmbManufacturingOrder').prop("disabled", true);
        $('#cmbManufacturingOrder').empty();
        $('#cmbProjectCode').prop("disabled", true);
        $('#cmbProjectCode').empty();
    }
}

/*function allUnit() {
    var data = [];
    $.ajax({
        type: "GET",
        url: "/sc/perchaseRequestHeaderController/allProductUnit",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response.data.result);
            for (var i = 0; i < response.data.result.length; i++) {
                data.push({ 'value': response.data.result[i].id, 'text': response.data.result[i].name });
            }

        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return data;
}*/




function allEmployees() {
    $.ajax({
        type: "GET",
        url: "/sc/perchaseRequestHeaderController/allEmployees",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            //$('#txtRequestBy').setData(res);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function allProjects() {
    $.ajax({
        type: "GET",
        url: "/sc/perchaseRequestHeaderController/allProjects",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                var code = res[i].code + " - " + res[i].name;
                $('#cmbProjectCode').append('<option value="' + res[i].project_id + '">' + code + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function allDepartment() {
    $.ajax({
        type: "GET",
        url: "/sc/perchaseRequestHeaderController/allDepartment",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbDepartment').append('<option value="' + res[i].department_id + '">' + res[i].department + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function allStores() {
    $.ajax({
        type: "GET",
        url: "/sc/perchaseRequestHeaderController/allStores",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbStores').append('<option value="' + res[i].id + '">' + res[i].name + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function newReferanceID(storeID) {
    var referanceID = newID("/sc/ReferenceIDController/purchaseRequestMaxID", storeID);
    $('#txtExternal_id').val(referanceID);
}





function allManufacturingOrder() {
    $.ajax({
        type: "GET",
        url: "/sc/perchaseRequestHeaderController/allProductCustomer",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbManufacturingOrder').append('<option value="' + res[i].customer_order_plan_id + '">' + res[i].manufacturing_order_number + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function allProduct() {
    var product_data = [];
    $.ajax({
        type: "GET",
        url: "/sc/perchaseRequestHeaderController/allProduct",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            product_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

    return product_data;
}




function savePurchaseRequestHeader() {

    newReferanceID($('#cmbStores').val());
    var is_data_arr = null;
    var is_other_arr = null;
    var request_data = {};
    var requeat_data_arr = tableData.dataSource();
    if ($('#txtRequestBy').val() == '') {
        showWarningMessage("Please Enter Request By");
        return;
    }
    if (requeat_data_arr.length == 0) {
        showWarningMessage("Invalied Purchase request (Empty list)");
        return;
    }

    var request_other = {};
    var requeat_other_arr = tableOther.dataSource();
    for (var i = 0; i < requeat_other_arr.length; i++) {
        is_other_arr = requeat_other_arr[i][1];
        request_other[i] = { "description": requeat_other_arr[i][1], "quantity": requeat_other_arr[i][2] };
    }
   
        for (var i = 0; i < requeat_data_arr.length; i++) {
            is_data_arr = requeat_data_arr[i][0];

            if (!requeat_data_arr[i][0] && !is_other_arr) {
                showWarningMessage("You should fill empty row in The list");
                return;
            }

            if (!requeat_data_arr[i][3] && !is_other_arr) {
                showWarningMessage(requeat_data_arr[i][1] + " Invalied Quantity");
                return;
            }
            request_data[i] = { "product_id": requeat_data_arr[i][0], "product_name": requeat_data_arr[i][2], "unit_id": requeat_data_arr[i][3], "qty": requeat_data_arr[i][4], "comments": requeat_data_arr[i][5], };
        }

    $.ajax({
        type: "POST",
        url: '/sc/perchaseRequestHeaderController/save',
        data: {
            'external_id': $('#txtExternal_id').val(),
            'ref_external_id': $('#txtExternal_id').val(),
            'trans_date': $('#txtGrnDate').val(),
            'dept_id': $('#cmbDepartment').val(),
            'store_id': $('#cmbStores').val(),
            'request_by': $('#txtRequestBy').val(),
            'mr_internal_id': '0',
            'mr_extenal_id': '0',
            'mi_type': $('#cmbMiType').val(),
            'manufacturing_order_number': $('#cmbManufacturingOrder').val(),
            'project_code': $('#cmbProjectCode').val(),
            'remarks': $('#txtRemarks').val(),
            'attachment_token': TOKEN,
            'request_data': request_data,
            'request_other': request_other,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                toastr.success('data saved');
                location.href = '/sc/PurchaseRequest';
            } else {
                showErrorMessage();
            }
            //location.reload();

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}



function getPurchaseRequest(id) {
    $.ajax({
        type: "GET",
        url: "/sc/perchaseRequestHeaderController/getPurchaseRequest/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            PURCHASE_REQUEST_ID = res.internal_id
            referanceID = res.external_id;

            $('#txtExternal_id').val(res.external_id);
            $('#txtGrnDate').val(res.trans_date);
            setSelectedOption('cmbDepartment', res.dept_id);
            //$('#txtRequestBy').attr("data-id", res.request_by);
            $('#txtRequestBy').val(res.employee_name);
            $('#txtRemarks').val(res.remarks);
            var mr_internal_id = res.mr_internal_id;
            var mr_extenal_id = res.mr_extenal_id;
            setSelectedOption('cmbStores', res.store_id);
            setSelectedOption('cmbMiType', res.mi_type);

            if (res.mi_type == 1) {
                allManufacturingOrder();
                setSelectedOption('cmbManufacturingOrder', res.manufacturing_order_number);
            } else if (res.mi_type == 2) {
                allProjects();
                setSelectedOption('cmbProjectCode', res.project_code);
            }
            checkDisableType(res.mi_type);
            allAttachment(id, 0);


            var request_data = res.request_data;

            for (var i = 0; i < request_data.length; i++) {
                var comments = request_data[i].comments;
                if (comments == null) {
                    comments = "";
                }
                tableData.addRow(
                    [
                        { 'type': 'string', 'val': request_data[i].product_primary_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'string', 'val': request_data[i].product_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].product, 'align': 'left', 'width': '100%' },
                        {
                            'type': 'select', 'val': request_data[i].uom, 'align': 'left', 'width': '100px'
                        },
                        { 'type': 'text', 'val': request_data[i].quantity, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': comments, 'align': 'left', 'width': '300px' },
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );
            }



            var request_other = res.request_other;
            //console.log(request_other);
            for (var i = 0; i < request_other.length; i++) {
                var description = request_other[i].description;
                if (description == null) {
                    description = "";
                }
                var quantity = request_other[i].quantity;
                if (quantity == null) {
                    quantity = "";
                }
                tableOther.addRow(
                    [
                        { 'type': 'text', 'val': ''},
                        { 'type': 'text', 'val': description, 'align': 'left', 'width': '100%' },
                        { 'type': 'text', 'val': quantity, 'align': 'right', 'width': '100px' },
                        /*{ 'type': 'text', 'val': request_other[i].price },
                        { 'type': 'text', 'val': request_other[i].discount },
                        { 'type': 'string', 'val': request_other[i].value },*/
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );
            }



        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}





function updatePurchaseRequestHeader() {

    var request_data = {};
    var requeat_data_arr = tableData.dataSource();
    if ($('#txtRequestBy').val() == '') {
        showWarningMessage("Please Enter Request By");
        return;
    }
    if (requeat_data_arr.length == 0) {
        showWarningMessage("Invalied Purchase request (Empty list)");
        return;
    }
    for (var i = 0; i < requeat_data_arr.length; i++) {
        if (!requeat_data_arr[i][0]) {
            showWarningMessage("You shuld fill empty row in The list");
            return;
        }
        if (!requeat_data_arr[i][3]) {
            showWarningMessage(requeat_data_arr[i][1] + " Invalied Quantity");
            return;
        }
        request_data[i] = { "product_id": requeat_data_arr[i][0], "product_name": requeat_data_arr[i][2], "unit_id": requeat_data_arr[i][3], "qty": requeat_data_arr[i][4], "comments": requeat_data_arr[i][5], };
    }
    var request_other = {};
    var requeat_other_arr = tableOther.dataSource();
    for (var i = 0; i < requeat_other_arr.length; i++) {
        request_other[i] = { "description": requeat_other_arr[i][1], "quantity": requeat_other_arr[i][2] };
    }
    $.ajax({
        type: "PUT",
        url: '/sc/perchaseRequestHeaderController/update/' + PURCHASE_REQUEST_ID,
        data: {
            'external_id': $('#txtExternal_id').val(),
            'ref_external_id': $('#txtExternal_id').val(),
            'trans_date': $('#txtGrnDate').val(),
            'dept_id': $('#cmbDepartment').val(),
            'store_id': $('#cmbStores').val(),
            'request_by': $('#txtRequestBy').val(),
            'mr_internal_id': '0',
            'mr_extenal_id': '0',
            'mi_type': $('#cmbMiType').val(),
            'manufacturing_order_number': $('#cmbManufacturingOrder').val(),
            'project_code': $('#cmbProjectCode').val(),
            'remarks': $('#txtRemarks').val(),
            'attachment_token': TOKEN,
            'request_data': request_data,
            'request_other': request_other,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                toastr.success('data updated');
                location.href = '/sc/PurchaseRequestList';
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}





function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}


function triggerRowInputs(id, selected_row) {

    if (id == "tblData") {
        var cells = selected_row.getElementsByTagName('td');
        var quantity = $('#' + cells[1].childNodes[0].id);
        quantity.on('input', function () {
            var qty = parseFloat(quantity.val());
            var prc = parseFloat(price.val());
            var disc = parseFloat(discount.val());
            var amount = (qty * prc);
            var disc_amount = (amount * disc) / 100.0;
            var val = (amount - disc_amount);
            if (!isNaN(val)) {
                value.val(val);
            }


        });
        /*price.on('input', function () {
            var qty = parseFloat(quantity.val());
            var prc = parseFloat(price.val());
            var disc = parseFloat(discount.val());
            var amount = (qty * prc);
            var disc_amount = (amount * disc) / 100.0;
            var val = (amount - disc_amount);
            if (!isNaN(val)) {
                value.val(val);
            }
        });*/
        /*discount.on('input', function () {
            var qty = parseFloat(quantity.val());
            var prc = parseFloat(price.val());
            var disc = parseFloat(discount.val());
            var amount = (qty * prc);
            var disc_amount = (amount * disc) / 100.0;
            var val = (amount - disc_amount);
            if (!isNaN(val)) {
                value.val(val);
            }
        });*/
    } else if (id == "tblData") {
        var cells = selected_row.getElementsByTagName('td');
        var quantity = $('#' + cells[1].childNodes[0].id);
        var price = $('#' + cells[2].childNodes[0].id);
        var discount = $('#' + cells[3].childNodes[0].id);
        var value = $('#' + cells[4].childNodes[0].id);
        quantity.on('input', function () {
            var qty = parseFloat(quantity.val());
            var prc = parseFloat(price.val());
            var disc = parseFloat(discount.val());
            var amount = (qty * prc);
            var disc_amount = (amount * disc) / 100.0;
            var val = (amount - disc_amount);
            if (!isNaN(val)) {
                value.val(val);
            }


        });
        price.on('input', function () {
            var qty = parseFloat(quantity.val());
            var prc = parseFloat(price.val());
            var disc = parseFloat(discount.val());
            var amount = (qty * prc);
            var disc_amount = (amount * disc) / 100.0;
            var val = (amount - disc_amount);
            if (!isNaN(val)) {
                value.val(val);
            }
        });
        discount.on('input', function () {
            var qty = parseFloat(quantity.val());
            var prc = parseFloat(price.val());
            var disc = parseFloat(discount.val());
            var amount = (qty * prc);
            var disc_amount = (amount * disc) / 100.0;
            var val = (amount - disc_amount);
            if (!isNaN(val)) {
                value.val(val);
            }
        });
    }


}




function getProduct_Uom(id) {
    var unit = undefined;
    $.ajax({
        type: "GET",
        url: "/sc/perchaseOrderController/getUom/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            unit = response.data.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return unit;
}




function allAttachment(purchase_request_id, token) {

    $.ajax({
        type: "GET",
        url: "/sc/perchaseRequestHeaderController/allAttachment/" + purchase_request_id + "/" + token,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var result = response.data.result;
                var data = [];
                for (var i = 0; i < result.length; i++) {
                    var path = "'" + result[i].path + "'";
                    var id = "'" + result[i].purchase_request_attachment_id + "'";
                    data.push({
                        "file": result[i].path,
                        "view": '<button type= "button" class="btn btn-primary" onclick="viewAttachment(' + path + ');"><i class="fa fa-eye" aria-hidden="true"></i></button> ',
                        "download": '<button type= "button" class="btn btn-success" onclick="downloadAttachment(' + path + ');"><i class="fa fa-download" aria-hidden="true"></i></button> ',
                        "delete": '<button type= "button" class="btn btn-danger" onclick="deleteAttachment(' + id + ');"><i class="fa fa-trash" aria-hidden="true"></i></button> ',
                    });
                }
                var table = $('#tblPurchaseRequestAttachment').DataTable();
                //table.clear();
                table.rows.add(data).draw();
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);

        },

    });
}


function viewAttachment(file) {
    window.open('/purchase_request/' + file);

}


function downloadAttachment(file) {
    var link = document.createElement("a");
    link.download = file;
    link.href = "/purchase_request/" + file;
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
    delete link;
}



function deleteAttachment(id) {

    $.ajax({
        type: 'DELETE',
        url: '/sc/perchaseRequestHeaderController/deleteAttachment/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Purchase Request Attachment has been deleted successfully...");
                location.reload();

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });


}



function change_status_confirmation(id, status, msg) {
    swal({
        title: msg,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                change_status(id, status);
            }
        });

}

function change_status(id, status) {

    $.ajax({
        type: "PUT",
        url: '/sc/purchaseRequestListController/change_status/' + id,
        data: {
            status: status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            // document.getElementById('btnApproveGrn').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                if (status == 1) {
                    toastr.success("Purchase Request approved.");
                } else if (status == 2) {
                    toastr.success("Purchase Request rejected.");
                }

            } else {
                showErrorMessage();
            }
            location.href = '/sc/PurchaseRequestList';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
            // document.getElementById('approve'+id).innerHTML = '<i class="fa fa-times" aria-hidden="true"></i>';
        }

    });
}



/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "0000",
        2: "000",
        3: "00",
        4: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message, 'Success Alert', { timeOut: 5000 });
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message, 'Warning Alert', { timeOut: 5000 });
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}