@extends('sc::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="{{ Module::asset('sc:css/settings.css') }}" type="text/css">

<meta name="csrf-token" content="{{ csrf_token() }}">
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Settings</h6>
                <div class="accordion" id="accordionExample">

                    <div class="col-md-12 mb-3">
                        <div class="card ">
                            <div class="card-header" id="headingTown">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" id="settingsModal" data-toggle="collapse" data-target="#collapseStores" aria-expanded="false" aria-controls="collapseStores" onclick="getAllStores()">
                                        <i class="ti-settings mr-2"></i> Stores
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseStores" class="collapse" aria-labelledby="headingStores" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModalStores('save',null)">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th>Prefix</th>
                                                    <th hidden>Site</th>
                                                    <th hidden>Code</th>
                                                    <th class="edit edit_stores">Edit</th>
                                                    <th class="disable disable_stores">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblStores"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>



                    <div class="col-md-12 mb-3">
                        <div class="card ">
                            <div class="card-header">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" id="settingsModal" data-toggle="collapse" data-target="#collapseOrderType" aria-expanded="false" aria-controls="collapseOrderType" onclick="getAllOrderType()">
                                        <i class="ti-settings mr-2"></i> OrderType
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseOrderType" class="collapse" aria-labelledby="headingOrderType" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModalOrderType('save',null)">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th class="edit edit_order">Edit</th>
                                                    <th class="disable disable_stores">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblOrderType"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="col-md-12 mb-3">
                        <div class="card ">
                            <div class="card-header">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" id="settingsModal" data-toggle="collapse" data-target="#collapseMaterialRequestReason" aria-expanded="false" aria-controls="collapseMaterialRequestReason" onclick="getAllMaterialRequestReason()">
                                        <i class="ti-settings mr-2"></i> Material Request Reason
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseMaterialRequestReason" class="collapse" aria-labelledby="headingMaterialRequestReason" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showMaterialRequestReason('save',null)">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Reason</th>
                                                    <th class="edit edit_reasonr">Edit</th>
                                                    <th class="disable disable_reason">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblMaterialRequestReason"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="settingsAddModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="settingsAddModalTitle">Modal title</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <form method="POST" id="myForm">
                    {{csrf_field()}}
                    <input type="hidden" id="settingID" name="settingID" value>
                    <div class="modal-body" id="settingsAddModalBody">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                        </button>
                        <div id="btnDiv">
                            <button type="button" class="btn btn-primary" id="btnSetting">Save</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- App scripts -->
<script src="{{ Module::asset('hr:js/special_character.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('sc:js/setting2.js') }}?random=<?php echo uniqid(); ?>"></script>
<!-- Sweet alert -->
<script src="{{ url('assets/js/examples/sweet-alert.js') }}"></script>
<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection