<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Route;
use Modules\Sc\Http\Controllers\AvailableQuantityBeforeSaveController;
use Modules\Sc\Http\Controllers\GoodsReceivedMrController;
use Modules\Sc\Http\Controllers\GoodsReceivedMrListController;
use Modules\Sc\Http\Controllers\GoodsReturnListController;
use Modules\Sc\Http\Controllers\GoodsTransferController;
use Modules\Sc\Http\Controllers\GoodsTransferListController;
use Modules\Sc\Http\Controllers\GoodsTransferMRController;
use Modules\Sc\Http\Controllers\GoodsTransferMRListController;
use Modules\Sc\Http\Controllers\GoodsTransferMrRetrieveController;
use Modules\Sc\Http\Controllers\GoodsTransferMrRetrieveContrommerController;
use Modules\Sc\Http\Controllers\GrnHeaderController;
use Modules\Sc\Http\Controllers\GrnListController;
use Modules\Sc\Http\Controllers\GrnReturnController;
use Modules\Sc\Http\Controllers\MaterialRequisitionController;
use Modules\Sc\Http\Controllers\MaterialReturnController;
use Modules\Sc\Http\Controllers\MaterialReturnListController;
use Modules\Sc\Http\Controllers\MaterialRiquisitionListController;
use Modules\Sc\Http\Controllers\MiHeaderControllrController;
use Modules\Sc\Http\Controllers\MiListController;
use Modules\Sc\Http\Controllers\ProductHistoryController;
use Modules\Sc\Http\Controllers\ProductListReportController;
use Modules\Sc\Http\Controllers\PurchaseOrderController;
use Modules\Sc\Http\Controllers\PurchaseOrderListController;
use Modules\Sc\Http\Controllers\PurchaseRequestController;
use Modules\Sc\Http\Controllers\PurchaseRequestListController;
use Modules\Sc\Http\Controllers\ReferenceIDController;
use Modules\Sc\Http\Controllers\RetrieveMRController;
use Modules\Sc\Http\Controllers\SettingsController;
use Modules\Sc\Http\Controllers\StockReportController;
use Modules\Sc\Http\Controllers\StockValuationReportController;
use Modules\Sc\Http\Controllers\NotificationController;

Route::prefix('sc')->group(function () {

    Route::get('/dashboard', function () {
        return view('sc::dashboard');
    })->middleware('is.logged');

    Route::get('/grn', function () {
        return view('sc::grn_header');
    })->middleware(['is.logged', 'can:sc_goods_received_create']);

    Route::get('/grnList', function () {
        return view('sc::grn_list');
    })->middleware(['is.logged', 'can:sc_goods_received_list']);

    Route::get('/grnApproval', function () {
        return view('sc::grn_approval');
    })->middleware(['is.logged', 'can:sc_goods_received_approval']);

    Route::get('/goodsReturn', function () {
        return view('sc::goods_return');
    })->middleware(['is.logged', 'can:sc_goods_return_create']);

    Route::get('/materialIssue', function () {
        return view('sc::mi_header');
    })->middleware(['is.logged', 'can:sc_material_issue_create']);

    Route::get('/materialIssueList', function () {
        return view('sc::mi_list');
    })->middleware(['is.logged', 'can:sc_material_issue_list']);

    Route::get('/materialIssueApproval', function () {
        return view('sc::mi_approval');
    })->middleware(['is.logged', 'can:sc_material_issue_approval']);

    Route::get('/stockReport', function () {
        return view('sc::stock_report');
    })->middleware(['is.logged', 'can:sc_report_stock_balance']);


    Route::get('/productListReport', function () {
        return view('sc::product_list_report');
    })->middleware(['is.logged', 'can:sc_report_product_list']);


    Route::get('/settings', function () {
        return view('sc::settings');
    })->middleware(['is.logged', 'can:sc_setting']);

    Route::get('/materialReturn', function () {
        return view('sc::material_return');
    })->middleware(['is.logged', 'can:sc_material_return_create']);

    Route::get('/productHistoryReport', function () {
        return view('sc::product_history_report');
    })->middleware(['is.logged', 'can:sc_report_product_history']);

    Route::get('/PurchaseRequest', function () {
        return view('sc::purchase_request');
    })->middleware(['is.logged', 'can:sc_purchase_request_create']);

    Route::get('/PurchaseRequestList', function () {
        return view('sc::purchase_request_list');
    })->middleware(['is.logged', 'can:sc_purchase_request_list']);

    Route::get('/PurchaseOrder', function () {
        return view('sc::purchase_order');
    })->middleware(['is.logged', 'can:sc_purchase_order_create']);

    Route::get('/PurchaseOrderList', function () {
        return view('sc::purchase_order_list');
    })->middleware(['is.logged', 'can:sc_purchase_order_list']);

    Route::get('/materialRequisition', function () {
        return view('sc::material_requisition');
    })->middleware(['is.logged', 'can:sc_material_request_create']);

    Route::get('/materialRequisitionView', function () {
        return view('sc::material_requisition_view');
    })->middleware(['is.logged', 'can:sc_material_request_create']);

    Route::get('/materialRequisitionList', function () {
        return view('sc::material_requisition_list');
    })->middleware(['is.logged', 'can:sc_material_request_list']);

    Route::get('/goodsReturnList', function () {
        return view('sc::goods_return_list');
    })->middleware(['is.logged', 'can:sc_goods_return_list']);

    Route::get('/goodsReturnApproval', function () {
        return view('sc::goods_return_approval');
    })->middleware(['is.logged', 'can:sc_goods_return_approval']);

    Route::get('/materialReturnList', function () {
        return view('sc::material_return_list');
    })->middleware(['is.logged', 'can:sc_material_return_list']);

    Route::get('/materialReturnApproval', function () {
        return view('sc::material_return_approvel');
    })->middleware(['is.logged', 'can:sc_material_return_approval']);

    Route::get('/goods_received_mr', function () {
        return view('sc::goods_received_mr');
    })->middleware(['is.logged', 'can:sc_goods_received_m_r_create']);

    Route::get('/goods_received_mr_list', function () {
        return view('sc::goods_received_mr_list');
    })->middleware(['is.logged', 'can:sc_goods_received_m_r_list']);


    Route::get('/goods_transfer', function () {
        return view('sc::goods_transfer');
    })->middleware(['is.logged', 'can:sc_goods_transfer_create']);


    Route::get('/goods_transfer_list', function () {
        return view('sc::goods_transfer_list');
    })->middleware(['is.logged', 'can:sc_goods_transfer_list']);

    Route::get('/goods_transfer_approval', function () {
        return view('sc::goods_transfer_approval');
    })->middleware(['is.logged', 'can:sc_goods_transfer_approval']);

    Route::get('/BomModal', function () {
        return view('sc::BomModal');
    })->middleware(['is.logged']);

    Route::get('/goods_transfer_mr', function () {
        return view('sc::goods_transfer_mr');
    })->middleware(['is.logged', 'can:sc_goods_transfer_m_r_create']);

    Route::get('/goods_transfer_mr_list', function () {
        return view('sc::goods_transfer_mr_list');
    })->middleware(['is.logged', 'can:sc_goods_transfer_m_r_list']);

    Route::get('/report', function () {
        return view('sc::report');
    })->middleware(['is.logged']);

    Route::get('/material_requisition_approval_list', function () {
        return view('sc::material_requisition_approval_list');
    })->middleware(['is.logged']);

    Route::get('/grn_reports', function () {
        return view('sc::grn_reports');
    })->middleware(['is.logged']);


    /**ReferenceIDController */
    Route::get('/ReferenceIDController/grnHeaderMaxID/{store_id}', [ReferenceIDController::class, 'grnHeaderMaxID']);
    Route::get('/ReferenceIDController/grnReturnMaxID/{store_id}', [ReferenceIDController::class, 'grnReturnMaxID']);
    Route::get('/ReferenceIDController/miHeaderMaxID/{store_id}', [ReferenceIDController::class, 'miHeaderMaxID']);
    Route::get('/ReferenceIDController/purchaseRequestMaxID/{store_id}', [ReferenceIDController::class, 'purchaseRequestMaxID']);
    Route::get('/ReferenceIDController/purchaseOrderMaxID/{store_id}', [ReferenceIDController::class, 'purchaseOrderMaxID']);
    Route::get('/ReferenceIDController/materialRequisitionMaxIDMaxID/{store_id}', [ReferenceIDController::class, 'materialRequisitionMaxIDMaxID']);
    Route::get('/ReferenceIDController/goodsReceivedMrMaxID/{store_id}', [ReferenceIDController::class, 'goodsReceivedMrMaxID']);
    Route::get('/ReferenceIDController/goodsTransferMaxID/{store_id}', [ReferenceIDController::class, 'goodsTransferMaxID']);
    Route::get('/ReferenceIDController/goodsTransferMRMaxID/{store_id}', [ReferenceIDController::class, 'goodsTransferMRMaxID']);
    Route::get('/ReferenceIDController/materialIssueMaxID/{store_id}', [ReferenceIDController::class, 'materialIssueMaxID']);
    Route::get('/ReferenceIDController/materialReturnMaxID/{store_id}', [ReferenceIDController::class, 'materialReturnMaxID']);
    /**End of ReferenceIDController */


    /**Grn Header Controller */
    Route::get('/grnHeaderController/allEmployees', [GrnHeaderController::class, 'allEmployees']);
    Route::get('/grnHeaderController/allSuppliers', [GrnHeaderController::class, 'allSuppliers']);
    Route::get('/grnHeaderController/allProduct', [GrnHeaderController::class, 'allProduct']);
    Route::get('/grnHeaderController/allStores', [GrnHeaderController::class, 'allStores']);
    Route::get('/grnHeaderController/isApproved/{id}', [GrnHeaderController::class, 'isApproved']);
    Route::get('/grnHeaderController/getGrn/{id}', [GrnHeaderController::class, 'getGrn']);
    Route::get('/grnHeaderController/getUom/{id}', [GrnHeaderController::class, 'getUom']);
    Route::post('/grnHeaderController/save', [GrnHeaderController::class, 'save']);
    Route::put('/grnHeaderController/update/{id}', [GrnHeaderController::class, 'update']);
    Route::put('/grnHeaderController/change_status/{id}', [GrnHeaderController::class, 'change_status']);
    Route::post('/grnHeaderController/uploadAttachment', [GrnHeaderController::class, 'uploadAttachment'])->name('/grnHeaderController/uploadAttachment');
    Route::get('/grnHeaderController/allAttachment/{id}/{token}', [GrnHeaderController::class, 'allAttachment']);
    Route::get('/grnHeaderController/getPoFromSupplier/{id}', [GrnHeaderController::class, 'getPoFromSupplier']);
    /**End of Grn Header Controller */

    /**Grn List Controller */
    Route::get('/grnListController/allGrn', [GrnListController::class, 'allGrn']);
    Route::get('/grnListController/goodsReceivedReport/{id}', [GrnListController::class, 'goodsReceivedReport']);
    /**End of Grn List Controller */



    /**Grn Return Controller */
    Route::get('/grnReturnController/allEmployees', [GrnReturnController::class, 'allEmployees']);
    Route::get('/grnReturnController/allProjects', [GrnReturnController::class, 'allProjects']);
    Route::get('/grnReturnController/allSuppliers', [GrnReturnController::class, 'allSuppliers']);
    Route::get('/grnReturnController/allProduct', [GrnReturnController::class, 'allProduct']);
    Route::get('/grnReturnController/getUom/{id}', [GrnReturnController::class, 'getUom']);
    Route::get('/grnReturnController/allStores', [GrnReturnController::class, 'allStores']);
    Route::get('/grnReturnController/getGrn/{id}', [GrnReturnController::class, 'getGrn']);
    Route::get('/grnReturnController/getGoodsReturn/{id}', [GrnReturnController::class, 'getGoodsReturn']);
    Route::get('/grnReturnController/getQty/{product_id}/{store_id}', [GrnReturnController::class, 'getQty']);
    Route::get('/grnReturnController/allGrn', [GrnReturnController::class, 'allGrn']);
    Route::get('/grnReturnController/allProductUnit', [GrnReturnController::class, 'allProductUnit']);
    Route::post('/grnReturnController/save', [GrnReturnController::class, 'save']);
    Route::put('/grnReturnController/update/{id}', [GrnReturnController::class, 'update']);
    /**End of Grn Return Controller */



    /**Mi Header Controller */
    Route::get('/miHeaderController/allEmployees', [MiHeaderControllrController::class, 'allEmployees']);
    Route::get('/miHeaderController/allProjects', [MiHeaderControllrController::class, 'allProjects']);
    Route::get('/miHeaderController/allDepartment', [MiHeaderControllrController::class, 'allDepartment']);
    Route::get('/miHeaderController/allProduct', [MiHeaderControllrController::class, 'allProduct']);
    Route::get('/miHeaderController/allStores', [MiHeaderControllrController::class, 'allStores']);
    Route::get('/miHeaderController/allMachine', [MiHeaderControllrController::class, 'allMachinery']);
    Route::get('/miHeaderController/getMaterialIssue/{id}', [MiHeaderControllrController::class, 'getMaterialIssue']);
    Route::get('/miHeaderController/allProductUnit', [MiHeaderControllrController::class, 'allProductUnit']);
    Route::get('/miHeaderController/allProductCustomer', [MiHeaderControllrController::class, 'allProductCustomer']);
    Route::get('/miHeaderController/getQty/{product_id}/{store_id}', [MiHeaderControllrController::class, 'getQty']);
    Route::get('/miHeaderController/getUom/{id}', [MiHeaderControllrController::class, 'getUom']);
    Route::post('/miHeaderController/save', [MiHeaderControllrController::class, 'save']);
    Route::put('/miHeaderController/update/{id}', [MiHeaderControllrController::class, 'update']);
    Route::put('/miHeaderController/change_status/{id}', [MiHeaderControllrController::class, 'change_status']);
    Route::get('/miHeaderController/isApproved/{id}', [MiHeaderControllrController::class, 'isApproved']);
    Route::delete('/miHeaderController/deleteMaterialIssue/{id}', [MiHeaderControllrController::class, 'deleteMaterialIssue']);
    /**End of Mi Header Controller */

    /**Mi List Controller */
    Route::get('/miListController/allMaterialIssue', [MiListController::class, 'allMaterialIssue']);
    Route::get('/miListController/materialIssueReport/{id}', [MiListController::class, 'materialIssueReport']);
    /**End of Mi List Controller */


    /** Stock Report */
    Route::get('/stockReport/allSettings', [StockReportController::class, 'allSettings']);
    Route::get('/stockReport/category_level2/{id}', [StockReportController::class, 'category_level2']);
    Route::get('/stockReport/category_level3/{id}', [StockReportController::class, 'category_level3']);
    Route::get('/stockReport/stockBalanceReport/{setting}/{date_from}/{date_to}', [StockReportController::class, 'stockBalanceReport']);
    Route::get('/stockReport/stockBalanceAsAtReport/{setting}/{date_from}/{date_to}', [StockReportController::class, 'stockBalanceAsAtReport']);
    
    Route::get('/stockReport/productHistoryReport/{setting}/{date_from}/{date_to}', [StockReportController::class, 'productHistoryReport']);
    Route::get('/stockReport/purchaseOrderReport/{setting}/{date_from}/{date_to}', [StockReportController::class, 'purchaseOrderReport']);
    /** End of Stock Report */


    /** Product List Report */
    Route::get('/productListReport/allSettings', [ProductListReportController::class, 'allSettings']);
    Route::get('/productListReport/Report/{setting}/{date_from}/{date_to}', [ProductListReportController::class, 'productListReport']);
    /** End of Product List Report */


    /** Product History Report */
    Route::get('/producrtHistoryReport/allSettings', [ProductHistoryController::class, 'allSettings']);
    Route::get('/producrtHistoryReport/productHistoryReport/{setting}/{date_from}/{date_to}', [ProductHistoryController::class, 'productHistoryReport']);
    /** End of Product History Report */


    /** Settings */
    Route::get('/settings/allStores', [SettingsController::class, 'allStores']);
    Route::get('/settings/allSite', [SettingsController::class, 'allSite']);
    Route::post('/settingController/saveStores', [SettingsController::class, 'saveStores']);
    Route::post('/settingController/saveOrderType', [SettingsController::class, 'saveOrderType']);
    Route::post('/settingController/saveMaterialRequestReason', [SettingsController::class, 'saveMaterialRequestReason']);
    Route::get('/stockController/getAllStores', [SettingsController::class, 'getAllStores']);
    Route::get('/stockController/getAllOrderType', [SettingsController::class, 'getAllOrderType']);
    Route::get('/stockController/getAllMaterialRequestReason', [SettingsController::class, 'getAllMaterialRequestReason']);
    Route::get('/stockController/getOrderType/{id}', [SettingsController::class, 'getOrderType']);
    Route::get('/stockController/getStore/{id}', [SettingsController::class, 'getStore']);
    Route::get('/stockController/getMaterialRequestReason/{id}', [SettingsController::class, 'getMaterialRequestReason']);
    Route::put('/stockController/updateOrderType/{id}', [SettingsController::class, 'updateOrderType']);
    Route::put('/stockController/updateStores/{id}', [SettingsController::class, 'updateStores']);
    Route::put('/stockController/updateMaterialRequestReason/{id}', [SettingsController::class, 'updateMaterialRequestReason']);
    Route::put('/stockController/disableStores/{id}', [SettingsController::class, 'disableStores']);
    Route::put('/stockController/disableOrderType/{id}', [SettingsController::class, 'disableOrderType']);
    Route::put('/stockController/disableMaterialRequestReason/{id}', [SettingsController::class, 'disableMaterialRequestReason']);
    /** End of settings */


    /**Material Return Controller */
    Route::get('/MaterialReturnController/allEmployees', [MaterialReturnController::class, 'allEmployees']);
    Route::get('/MaterialReturnController/allProjects', [MaterialReturnController::class, 'allProjects']);
    Route::get('/MaterialReturnController/allDepartment', [MaterialReturnController::class, 'allDepartment']);
    Route::get('/MaterialReturnController/allProduct', [MaterialReturnController::class, 'allProduct']);
    Route::get('/MaterialReturnController/allStores', [MaterialReturnController::class, 'allStores']);
    Route::get('/MaterialReturnController/allMachine', [MaterialReturnController::class, 'allMachinery']);
    Route::get('/MaterialReturnController/allProductUnit', [MaterialReturnController::class, 'allProductUnit']);
    Route::get('/MaterialReturnController/allProductCustomer', [MaterialReturnController::class, 'allProductCustomer']);
    Route::get('/MaterialReturnController/allMi', [MaterialReturnController::class, 'allMi']);
    Route::get('/MaterialReturnController/getMaterialIssue/{id}', [MaterialReturnController::class, 'getMaterialIssue']);
    Route::get('/MaterialReturnController/getQty/{product_id}/{store_id}', [MaterialReturnController::class, 'getQty']);
    Route::get('/MaterialReturnController/getMaterialReturn/{id}', [MaterialReturnController::class, 'getMaterialReturn']);
    Route::get('/MaterialReturnController/getUom/{id}', [MaterialReturnController::class, 'getUom']);
    Route::post('/MaterialReturnController/save', [MaterialReturnController::class, 'save']);
    /**End of Material Return Controller */



    /**Perchase Request Header Controller */
    Route::get('/perchaseRequestHeaderController/allEmployees', [PurchaseRequestController::class, 'allEmployees']);
    Route::get('/perchaseRequestHeaderController/allProjects', [PurchaseRequestController::class, 'allProjects']);
    Route::get('/perchaseRequestHeaderController/allDepartment', [PurchaseRequestController::class, 'allDepartment']);
    Route::get('/perchaseRequestHeaderController/allProduct', [PurchaseRequestController::class, 'allProduct']);
    Route::get('/perchaseRequestHeaderController/allStores', [PurchaseRequestController::class, 'allStores']);
    Route::get('/perchaseRequestHeaderController/getPurchaseRequest/{id}', [PurchaseRequestController::class, 'getPurchaseRequest']);
    Route::get('/perchaseRequestHeaderController/getPurchaseRequestByExternalID/{id}', [PurchaseRequestController::class, 'getPurchaseRequestByExternalID']);
    Route::get('/perchaseRequestHeaderController/allProductUnit', [PurchaseRequestController::class, 'allProductUnit']);
    Route::get('/perchaseRequestHeaderController/allProductCustomer', [PurchaseRequestController::class, 'allProductCustomer']);
    Route::get('/perchaseRequestHeaderController/getQty/{product_id}/{store_id}', [PurchaseRequestController::class, 'getQty']);
    Route::post('/perchaseRequestHeaderController/uploadAttachment', [PurchaseRequestController::class, 'uploadAttachment'])->name('/perchaseRequestHeaderController/uploadAttachment');
    Route::get('/perchaseRequestHeaderController/allAttachment/{id}/{token}', [PurchaseRequestController::class, 'allAttachment']);
    Route::post('/perchaseRequestHeaderController/save', [PurchaseRequestController::class, 'save']);
    Route::put('/perchaseRequestHeaderController/update/{id}', [PurchaseRequestController::class, 'update']);
    Route::put('/perchaseRequestHeaderController/approve/{id}', [PurchaseRequestController::class, 'approve']);
    Route::delete('/perchaseRequestHeaderController/deleteAttachment/{id}', [PurchaseRequestController::class, 'deleteAttachment']);
    /**End of Perchase Request Controller */



    /**Purchase Request List Controller */
    Route::get('/purchaseRequestListController/allPurchaseRequest', [PurchaseRequestListController::class, 'allPurchaseRequest']);
    Route::get('/purchaseRequestListController/allPr', [PurchaseRequestListController::class, 'allPr']);
    Route::delete('/purchaseRequestListController/deletePurchaseRequest/{id}', [PurchaseRequestListController::class, 'deletePurchaseRequest']);
    Route::get('/purchaseRequestListController/purchaseRequestReport/{id}', [PurchaseRequestListController::class, 'purchaseRequestReport']);
    Route::put('/purchaseRequestListController/change_status/{id}', [PurchaseRequestListController::class, 'change_status']);
    /**End of Purchase Request List Controller */





    /**Perchase Order Header Controller */
    Route::get('/perchaseOrderController/allEmployees', [PurchaseOrderController::class, 'allEmployees']);
    Route::get('/perchaseOrderController/allDepartment', [PurchaseOrderController::class, 'allDepartment']);
    Route::get('/perchaseOrderController/allProduct', [PurchaseOrderController::class, 'allProduct']);
    Route::get('/perchaseOrderController/allStores', [PurchaseOrderController::class, 'allStores']);
    Route::get('/perchaseOrderController/getPurchaseOrder/{id}', [PurchaseOrderController::class, 'getPurchaseOrder']);
    Route::get('/perchaseOrderController/getPurchaseOrderByExternalID/{id}', [PurchaseOrderController::class, 'getPurchaseOrderByExternalID']);

    Route::get('/perchaseOrderController/allProductUnit', [PurchaseOrderController::class, 'allProductUnit']);
    Route::get('/perchaseOrderController/allProductCustomer', [PurchaseOrderController::class, 'allProductCustomer']);
    Route::get('/perchaseOrderController/getQty/{product_id}/{store_id}', [PurchaseOrderController::class, 'getQty']);
    Route::get('/perchaseOrderController/allPayTerms', [PurchaseOrderController::class, 'allPayTerms']);
    Route::get('/perchaseOrderController/allOrderType', [PurchaseOrderController::class, 'allOrderType']);
    Route::get('/perchaseOrderController/getUom/{id}', [PurchaseOrderController::class, 'getUom']);
    Route::get('/perchaseOrderController/allCurrency', [PurchaseOrderController::class, 'allCurrency']);
    Route::get('/perchaseOrderController/allAttachment/{id}/{token}', [PurchaseOrderController::class, 'allAttachment']);

    Route::post('/perchaseOrderController/save', [PurchaseOrderController::class, 'save']);
    Route::put('/perchaseOrderController/update/{id}', [PurchaseOrderController::class, 'update']);
    Route::put('/perchaseOrderController/approve/{id}', [PurchaseOrderController::class, 'approve']);
    Route::post('/perchaseOrderController/uploadAttachment', [PurchaseOrderController::class, 'uploadAttachment'])->name('/perchaseOrderController/uploadAttachment');
    /**End of Perchase Order Controller */




    /**Purchase Order List Controller */
    Route::get('/purchaseOrderListController/allPurchaseOrder', [PurchaseOrderListController::class, 'allPurchaseOrder']);
    Route::get('/purchaseOrderListController/purchaseOrderReport/{id}', [PurchaseOrderListController::class, 'purchaseOrderReport']);
    Route::delete('/purchaseOrderListController/deletePurchaseOrder/{id}', [PurchaseOrderListController::class, 'deletePurchaseOrder']);
    Route::put('/purchaseOrderListController/change_status/{id}', [PurchaseOrderListController::class, 'change_status']);
    /**End of Purchase Order List Controller */





    /**Material Requisition Header Controller */
    Route::get('/materialRequisitionController/allEmployees', [MaterialRequisitionController::class, 'allEmployees']);
    Route::get('/materialRequisitionController/allProjects', [MaterialRequisitionController::class, 'allProjects']);
    Route::get('/materialRequisitionController/allDepartment', [MaterialRequisitionController::class, 'allDepartment']);
    Route::get('/materialRequisitionController/allProduct', [MaterialRequisitionController::class, 'allProduct']);
    Route::get('/materialRequisitionController/allStores', [MaterialRequisitionController::class, 'allStores']);
    Route::get('/materialRequisitionController/allMachine', [MaterialRequisitionController::class, 'allMachinery']);
    Route::get('/materialRequisitionController/allMaterialRequestReason', [MaterialRequisitionController::class, 'allMaterialRequestReason']);
    Route::get('/materialRequisitionController/getMaterialRequisition/{id}', [MaterialRequisitionController::class, 'getMaterialRequisition']);
    Route::get('/materialRequisitionController/allProductUnit', [MaterialRequisitionController::class, 'allProductUnit']);
    Route::get('/materialRequisitionController/allProductCustomer', [MaterialRequisitionController::class, 'allProductCustomer']);
    Route::get('/materialRequisitionController/getQty/{product_id}/{store_id}', [MaterialRequisitionController::class, 'getQty']);
    Route::get('/materialRequisitionController/getUom/{id}', [MaterialRequisitionController::class, 'getUom']);
    Route::get('/materialRequisitionController/getScheduledFactoryPO', [MaterialRequisitionController::class, 'getScheduledFactoryPO']);
    Route::get('/materialRequisitionController/getProductFromOrder/{id}', [MaterialRequisitionController::class, 'getProductFromOrder']);
    Route::get('/materialRequisitionController/getBomHeader/{order_plan_data_id}', [MaterialRequisitionController::class, 'getBomHeader']);
    Route::get('/materialRequisitionController/setScheduleBom/{order_plan_data_id}/{product_id}', [MaterialRequisitionController::class, 'setScheduleBom']);

    Route::post('/materialRequisitionController/save', [MaterialRequisitionController::class, 'save']);
    Route::put('/materialRequisitionController/update/{id}', [MaterialRequisitionController::class, 'update']);
    Route::put('/materialRequisitionController/approve/{id}', [MaterialRequisitionController::class, 'approve']);
    /**End of Material Requisition Header Controller */

    /** Material Requisition List Controller */
    Route::get('/materialRequisitionListController/allMaterialRequisition/{department}/{status}', [MaterialRiquisitionListController::class, 'allMaterialRequisition']);
    Route::get('/materialRequisitionListController/allMaterialApprovalRequisition', [MaterialRiquisitionListController::class, 'allMaterialApprovalRequisition']);
    Route::get('/materialRequisitionListController/materialRequisitionReport/{id}', [MaterialRiquisitionListController::class, 'materialRequisitionReport']);
    Route::put('/materialRequisitionListController/change_status/{id}', [MaterialRiquisitionListController::class, 'change_status']);
    Route::get('/materialRequisitionListController/loadDepartments', [MaterialRiquisitionListController::class, 'loadDepartments']);
    /**End of Material Requisition List Controller */



    /**Goods Return List Controller */
    Route::get('/goodsReturnListController/allGoodsReturn', [GoodsReturnListController::class, 'allGoodsReturn']);
    Route::get('/goodsReturnListController/goodsReturnReport/{id}', [GoodsReturnListController::class, 'goodsReturnReport']);
    Route::delete('/goodsReturnListController/deleteGoodsReturn/{id}', [GoodsReturnListController::class, 'deleteGoodsReturn']);
    Route::put('/goodsReturnListController/change_status/{id}', [GoodsReturnListController::class, 'change_status']);
    /**End of Goods Return Controller */


    /**Material Return List Controller */
    Route::get('/materialReturnListController/allMaterialReturn', [MaterialReturnListController::class, 'allMaterialReturn']);
    Route::get('/materialReturnListController/materialReturnReport/{id}', [MaterialReturnListController::class, 'materialReturnReport']);
    /**Material Return List Controller */


    /** Goods Received MR */
    Route::get('/GoodsReceivedMrController/allProduct', [GoodsReceivedMrController::class, 'allProduct']);
    Route::get('/GoodsReceivedMrController/allStores', [GoodsReceivedMrController::class, 'allStores']);
    Route::get('/GoodsReceivedMrController/sites', [GoodsReceivedMrController::class, 'sites']);
    Route::get('/GoodsReceivedMrController/allProduct', [GoodsReceivedMrController::class, 'allProduct']);
    Route::get('/GoodsReceivedMrController/allSuppliers', [GoodsReceivedMrController::class, 'allSuppliers']);
    Route::get('/GoodsReceivedMrController/getSelectedGoodsReceivedMR/{id}', [GoodsReceivedMrController::class, 'getSelectedGoodsReceivedMR']);
    Route::post('/GoodsReceivedMrController/save', [GoodsReceivedMrController::class, 'save']);
    Route::put('/GoodsReceivedMrController/update/{id}', [GoodsReceivedMrController::class, 'update']);
    Route::put('/GoodsReceivedMrController/change_status/{id}', [GoodsReceivedMrController::class, 'change_status']);
    /** End of Goods Received MR */


    /** Goods Received MR List */
    Route::get('/GoodsReceivedMrListController/allGoodsReceivedMR', [GoodsReceivedMrListController::class, 'allGoodsReceivedMR']);
    Route::delete('/GoodsReceivedMrListController/delete/{id}', [GoodsReceivedMrListController::class, 'delete']);
    /** End Of Goods Received MR List */


    /** Goods Transfer Controller */
    Route::get('/GoodsTransferController/allEmployees', [GoodsTransferController::class, 'allEmployees']);
    Route::get('/GoodsTransferController/allSuppliers', [GoodsTransferController::class, 'allSuppliers']);
    Route::get('/GoodsTransferController/allProduct', [GoodsTransferController::class, 'allProduct']);
    Route::get('/GoodsTransferController/allStores', [GoodsTransferController::class, 'allStores']);
    Route::get('/GoodsTransferController/isApproved/{id}', [GoodsTransferController::class, 'isApproved']);
    Route::get('/GoodsTransferController/getGoodsTransfer/{id}', [GoodsTransferController::class, 'getGoodsTransfer']);
    Route::get('/GoodsTransferController/getUom/{id}', [GoodsTransferController::class, 'getUom']);
    Route::post('/GoodsTransferController/save', [GoodsTransferController::class, 'save']);
    Route::put('/GoodsTransferController/update/{id}', [GoodsTransferController::class, 'update']);
    Route::post('/GoodsTransferController/uploadAttachment', [GoodsTransferController::class, 'uploadAttachment'])->name('/GoodsTransferController/uploadAttachment');
    Route::get('/GoodsTransferController/allAttachment/{id}/{token}', [GoodsTransferController::class, 'allAttachment']);
    Route::get('/GoodsTransferController/getPoFromSupplier/{id}', [GoodsTransferController::class, 'getPoFromSupplier']);
    Route::get('/GoodsTransferController/getPoFromSupplier/{id}', [GoodsTransferController::class, 'getPoFromSupplier']);
    Route::get('/GoodsTransferController/getQty/{product_id}/{store_id}', [GoodsTransferController::class, 'getQty']);
    Route::get('/GoodsTransferController/getQtyUpdate/{product_id}/{store_id}', [GoodsTransferController::class, 'getQtyUpdate']);
    Route::delete('/GoodsTransferController/deleteGoodsTransfer/{id}', [GoodsTransferController::class, 'deleteGoodsTransfer']);
    Route::put('/GoodsTransferController/change_status/{id}', [GoodsTransferController::class, 'change_status']);
    Route::get('/GoodsTransferController/isApproved/{id}', [GoodsTransferController::class, 'isApproved']);
    Route::get('/GoodsTransferController/isValiedToUpdate/{id}', [GoodsTransferController::class, 'isValiedToUpdate']);
    Route::get('/GoodsTransferController/isMaterialIssue/{id}', [GoodsTransferController::class, 'isMaterialIssue']);
    /**End of Goods Transfer Controller Controller */




    /** Goods Transfer MR Controller */
    Route::get('/GoodsTransferMRController/allEmployees', [GoodsTransferMRController::class, 'allEmployees']);
    Route::get('/GoodsTransferMRController/allSuppliers', [GoodsTransferMRController::class, 'allSuppliers']);
    Route::get('/GoodsTransferMRController/allProduct', [GoodsTransferMRController::class, 'allProduct']);
    Route::get('/GoodsTransferMRController/allStores', [GoodsTransferMRController::class, 'allStores']);
    Route::get('/GoodsTransferMRController/isApproved/{id}', [GoodsTransferMRController::class, 'isApproved']);
    Route::get('/GoodsTransferMRController/getGoodsTransfer/{id}', [GoodsTransferMRController::class, 'getGoodsTransfer']);
    Route::get('/GoodsTransferMRController/getUom/{id}', [GoodsTransferMRController::class, 'getUom']);
    Route::post('/GoodsTransferMRController/save', [GoodsTransferMRController::class, 'save']);
    Route::put('/GoodsTransferMRController/update/{id}', [GoodsTransferMRController::class, 'update']);
    Route::post('/GoodsTransferMRController/uploadAttachment', [GoodsTransferMRController::class, 'uploadAttachment'])->name('/GoodsTransferMRController/uploadAttachment');
    Route::get('/GoodsTransferMRController/allAttachment/{id}/{token}', [GoodsTransferMRController::class, 'allAttachment']);
    Route::get('/GoodsTransferMRController/getPoFromSupplier/{id}', [GoodsTransferMRController::class, 'getPoFromSupplier']);
    Route::get('/GoodsTransferMRController/getPoFromSupplier/{id}', [GoodsTransferMRController::class, 'getPoFromSupplier']);
    Route::get('/GoodsTransferMRController/getQty/{product_id}/{store_id}', [GoodsTransferMRController::class, 'getQty']);
    Route::get('/GoodsTransferMRController/getQtyUpdate/{product_id}/{store_id}', [GoodsTransferMRController::class, 'getQtyUpdate']);
    Route::delete('/GoodsTransferMRController/deleteGoodsTransfer/{id}', [GoodsTransferMRController::class, 'deleteGoodsTransfer']);
    Route::put('/GoodsTransferMRController/change_status/{id}', [GoodsTransferMRController::class, 'change_status']);
    Route::get('/GoodsTransferMRController/isApproved/{id}', [GoodsTransferMRController::class, 'isApproved']);
    Route::get('/GoodsTransferMRController/isValiedToUpdate/{id}', [GoodsTransferMRController::class, 'isValiedToUpdate']);
    /**End of Goods Transfer MR Controller Controller */



    /** Goods Transfer List Controller */
    Route::get('/GoodsTransferListController/allGoodsTransfer', [GoodsTransferListController::class, 'allGoodsTransfer']);
    Route::delete('/GoodsTransferListController/delete/{id}', [GoodsTransferListController::class, 'delete']);
    /**End of Goods Transfer List Controller */


    /** Goods Transfer MR List Controller */
    Route::get('/GoodsTransferMRListController/allGoodsTransfer', [GoodsTransferMRListController::class, 'allGoodsTransfer']);
    Route::delete('/GoodsTransferMRListController/delete/{id}', [GoodsTransferMRListController::class, 'delete']);
    /**End of Goods Transfer MR List Controller */

    /** Goods Transfer MR Retrieve Controller */
    Route::get('/GoodsTransferMrRetrieveController/allMaterialRequisition', [GoodsTransferMrRetrieveController::class, 'allMaterialRequisition']);
    Route::get('/GoodsTransferMrRetrieveController/allMaterialRequisitionData/{id}', [GoodsTransferMrRetrieveController::class, 'allMaterialRequisitionData']);
    Route::get('/GoodsTransferMrRetrieveController/getSelectedMR/{id}/{data_id}', [GoodsTransferMrRetrieveController::class, 'getSelectedMR']);
    Route::get('/GoodsTransferMrRetrieveController/getSelectedMRHeader/{id}', [GoodsTransferMrRetrieveController::class, 'getSelectedMRHeader']);
    /** End of Goods Transfer MR Retrieve Controller */


    /** Retrieve MR Controller */
    Route::get('/RetrieveMRController/allMaterialRequisition', [RetrieveMRController::class, 'allMaterialRequisition']);
    Route::get('/RetrieveMRController/allMaterialRequisitionData/{id}', [RetrieveMRController::class, 'allMaterialRequisitionData']);
    Route::get('/RetrieveMRController/getSelectedMR/{id}', [RetrieveMRController::class, 'getSelectedMR']);
    Route::get('/RetrieveMRController/getSelectedMRHeader/{id}', [RetrieveMRController::class, 'getSelectedMRHeader']);
    Route::put('/RetrieveMRController/change_status/{id}', [RetrieveMRController::class, 'change_status']);
    /** End of Retrieve MR Controller */




    /** Available Quantity Before Save Controller */
    Route::get('/AvailableQuantityBeforeSaveController/getAvailableQuantitySaveBefore/{product_id}/{store_id}', [AvailableQuantityBeforeSaveController::class, 'getAvailableQuantitySaveBefore']);
    Route::get('/AvailableQuantityBeforeSaveController/getAvailableQuantityUpdateBefore/{product_id}/{store_id}', [AvailableQuantityBeforeSaveController::class, 'getAvailableQuantityUpdateBefore']);
    /** End of Available Quantity Before Save Controller */



    /** Stock Valuation Report */
    Route::get('/StockValuationReportController/allSettings', [StockValuationReportController::class, 'allSettings']);
    Route::get('/stockReport/supplier_type', [StockValuationReportController::class, 'supplier_type']);
    Route::get('/StockValuationReportController/stockValuationAverageReport/{settings}/{fromDate}/{toDate}', [StockValuationReportController::class, 'showStockValuationAverageReport']);
    Route::get('/StockValuationReportController/stockValuationAverageAsAtReport/{settings}/{fromDate}/{toDate}', [StockValuationReportController::class, 'showStockValuationAverageAsAtReport']);
    Route::get('/StockValuationReportController/showStockValuationBatchWiseReport/{settings}/{fromDate}/{toDate}', [StockValuationReportController::class, 'showStockValuationBatchWiseReport']);
    Route::get('/StockValuationReportController/grnReport/{settings}/{fromDate}/{toDate}', [StockValuationReportController::class, 'grnReport']);
    Route::get('/StockValuationReportController/ginReport/{settings}/{fromDate}/{toDate}', [StockValuationReportController::class, 'ginReport']);
    Route::get('/StockValuationReportController/goodTransferReport/{settings}/{fromDate}/{toDate}', [StockValuationReportController::class, 'goodTransferReport']);
    Route::get('/StockValuationReportController/supplierListReport/{settings}', [StockValuationReportController::class, 'supplierListReport']);
    /** End of Stock Valuation Report */


// 2025-02-17
/** Goods transfer report */
Route::get('/GoodsTransferListController/goodsTransferReport/{id}', [GoodsTransferListController::class, 'goodsTransferReport']);
/** End of Goods transfer report */

//get product reorder notification
Route::get('/NotificationController/getProductReorderNotification', [NotificationController::class, 'getProductReorderNotification']);

    
});
