<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateComplianceRenewalsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cm_compliance_renewals', function (Blueprint $table) {
            $table->id('renewal_id'); 

            $table->unsignedBigInteger('task_id'); 
            $table->string('document_name', 255); 
            $table->date('renewal_due_date'); 
            $table->enum('renewal_status', ['Pending', 'Completed', 'Overdue']); 
            $table->date('next_remind_date')->nullable(); 
            $table->unsignedBigInteger('responsible_employee_id');
            $table->timestamps();

            // Foreign Key Constraints
            $table->foreign('task_id')->references('task_id')->on('cm_compliance_tasks');
            $table->foreign('responsible_employee_id')->references('id')->on('employees');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cm_compliance_renewals');
    }
}
