<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateComplianceTasksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cm_compliance_tasks', function (Blueprint $table) {
            $table->id('task_id');
            $table->string('task_name', 255);
            $table->text('task_description')->nullable();
            $table->unsignedBigInteger('responsible_employee_id');
            $table->enum('task_frequency', ['One-Time', 'Monthly', 'Quarterly', 'Yearly']);
            $table->date('next_due_date')->nullable();
            $table->date('next_remind_date')->nullable();
            $table->enum('status', ['Pending', 'Completed', 'Overdue']);
            $table->enum('alert_status', ['Pending', 'Sent', 'Acknowledged']);
            $table->text('findings')->nullable();
            $table->timestamps(); 

            // Foreign Key Constraint
            // $table->foreign('responsible_employee_id')->references('id')->on('employees')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cm_compliance_tasks');
    }
}
