<?php

namespace Modules\Cm\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Cm\Entities\ComplianceTask;
use Modules\Cm\Entities\ComplianceRenewal;
use Modules\Hr\Entities\Employee;

class ComplianceRenewalController extends Controller
{

    public function save(Request $request) {
        try {
            // Create a new compliance renewal
            $complianceRenewal = new ComplianceRenewal();
            $complianceRenewal->document_name = $request->document_name;
            $complianceRenewal->task_id = $request->task_id;
            $complianceRenewal->renewal_due_date = $request->renewal_due_date;
            $complianceRenewal->next_remind_date = $request->next_remind_date;
            $complianceRenewal->renewal_status = $request->renewal_status;
            $complianceRenewal->responsible_employee_id = $request->responsible_employee_id;

            // Save the renewal record
            $result = $complianceRenewal->save();

            if ($result) {
                $responseBody = $this->responseBody(true, "Compliance Renewal", "saved", $complianceRenewal);
            } else {
                $responseBody = $this->responseBody(false, "Compliance Renewal", "error", null);
            }
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "Compliance Renewal", "error", $ex->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }

    public function getAllComplianceRenewals() {
        try {
            // Fetch all compliance renewals with related data, ordered by renewal_id (latest first)
            $complianceRenewals = ComplianceRenewal::orderBy('renewal_id', 'desc')->get();
            
            // Map the renewals to the desired format
            $mappedRenewals = $complianceRenewals->map(function ($renewal) {
                return [
                    'renewal_id' => $renewal->renewal_id,
                    'task_id' => $renewal->task_id,
                    'task_name' => $this->getTaskNameById($renewal->task_id),
                    'document_name' => $renewal->document_name,
                    'renewal_due_date' => $renewal->renewal_due_date,
                    'renewal_status' => $renewal->renewal_status,
                    'next_remind_date' => $renewal->next_remind_date,
                    'employee_name' => $this->getEmployeeNameById($renewal->responsible_employee_id),
                ];
            });

            // Return a success response with the fetched renewals
            $responseBody = $this->responseBody(true, "Compliance Renewals", "found", $mappedRenewals);

        } catch (\Exception $ex) {
            // Return an error response if something goes wrong
            $responseBody = $this->responseBody(false, "Compliance Renewals", "error", $ex->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }

    public function getAllComplianceTasksForSelect(){
        try {
            $comp_task_arr = [];
            $comp_task_data = ComplianceTask::all();
            foreach ($comp_task_data as $compliance) {
                array_push($comp_task_arr, [
                "img" => "", 
                "id" => $compliance['task_id'], 
                "value" => $compliance->task_id . ' - ' . $compliance->task_name
            ]);
            }
            $responseBody = $this->responseBody(true, "allCompTasks", "Found", $comp_task_arr);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "allCompTasks", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);

    }

    public function getComplianceRenewal($id) {
        try {
            $complianceRenewal = ComplianceRenewal::find($id);
            $responseBody = $this->responseBody(true, "Compliance Renewal", "found", $complianceRenewal);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "Compliance Renewal", "error", $ex->getMessage());
        }
        return response()->json(["data" => $responseBody]);
    }

    public function updateRenewal(Request $request, $id) {
        try {
            $complianceRenewal = ComplianceRenewal::find($id);
            $complianceRenewal->document_name = $request->document_name;
            $complianceRenewal->task_id = $request->task_id;
            $complianceRenewal->renewal_due_date = $request->renewal_due_date;
            $complianceRenewal->next_remind_date = $request->next_remind_date;
            $complianceRenewal->renewal_status = $request->renewal_status;
            $complianceRenewal->responsible_employee_id = $request->responsible_employee_id;
            $result = $complianceRenewal->save();

            if ($result) {
                $responseBody = $this->responseBody(true, "Compliance Renewal", "updated", $complianceRenewal);
            } else {
                $responseBody = $this->responseBody(false, "Compliance Renewal", "error", null);
            }
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "Compliance Renewal", "error", $ex->getMessage());
        }
        return response()->json(["data" => $responseBody]);
    }

    public function deleteRenewal($id) {
        try {
            $complianceRenewal = ComplianceRenewal::find($id);
            $result = $complianceRenewal->delete();

            if ($result) {
                $responseBody = $this->responseBody(true, "Compliance Renewal", "deleted", null);
            } else {
                $responseBody = $this->responseBody(false, "Compliance Renewal", "error", null);
            }
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "Compliance Renewal", "error", $ex->getMessage());
        }
        return response()->json(["data" => $responseBody]);
    }

    private function getTaskNameById($taskId){
        $task = ComplianceTask::find($taskId);
        return $task ? $task->task_name : 'Unknown';
    }
   
    private function getEmployeeNameById($employeeId){
        $employee = Employee::find($employeeId);
        return $employee ? $employee->name_withinitial : 'Unknown';
    }

     //response body
    private function responseBody($success, $name, $message, $result){
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
