<?php

namespace Modules\Cm\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Cm\Entities\ComplianceTask;
use Modules\Hr\Entities\Employee;

class ComplianceTaskController extends Controller
{

    public function getAllComplianceTasks(){
        try {

            // Fetch all compliance tasks with related employee data
            // $complianceTasks = ComplianceTask::all();
            $complianceTasks = ComplianceTask::orderBy('task_id', 'desc')->get();

            // Map the tasks to the desired format
            $mappedTasks = $complianceTasks->map(function ($task) {
                return [
                    'task_id' => $task->task_id,
                    'task_name' => $task->task_name,
                    'employee_name' => $this->getEmployeeNameById($task->responsible_employee_id), 
                    'task_frequency' => $task->task_frequency,
                    'next_due_date' => $task->next_due_date,
                    'next_remind_date' => $task->next_remind_date,
                    'status' => $task->status,
                    'alert_status' => $task->alert_status,
                ];
            });

            // Return a success response with the fetched tasks
            $responseBody = $this->responseBody(true, "Compliance Tasks", "found", $mappedTasks);

        } catch (\Exception $ex) {
            // Return an error response if something goes wrong
            $responseBody = $this->responseBody(false, "Compliance Tasks", "error", $ex->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }

    public function getComplianceTask($id){
        try {
            $complianceTask = ComplianceTask::find($id);

            if (!$complianceTask) {
                return response()->json([
                    'data' => $this->responseBody(false, "Compliance Task", "not found", null)
                ]);
            }

            // Format the task data
            $taskData = [
                'task_id' => $complianceTask->task_id,
                'task_name' => $complianceTask->task_name,
                'responsible_employee_id' => $complianceTask->responsible_employee_id,
                'employee_name' => $this->getEmployeeNameById($complianceTask->responsible_employee_id),
                'task_frequency' => $complianceTask->task_frequency,
                'next_due_date' => $complianceTask->next_due_date,
                'next_remind_date' => $complianceTask->next_remind_date,
                'status' => $complianceTask->status,
                'alert_status' => $complianceTask->alert_status,
                'task_description' => $complianceTask->task_description,
                'findings' => $complianceTask->findings,
            ];
            
            $responseBody = $this->responseBody(true, "Compliance Task", "found", $taskData);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "Compliance Task", "error", $ex->getMessage());
        }
        return response()->json(["data" => $responseBody]);
    }
   
    public function save(Request $request){
        try {
            // Extract data from the request
            $taskName = $request->get('task_name');
            $taskDescription = $request->get('task_description');
            $responsibleEmployeeId = $request->get('responsible_employee_id');
            $taskFrequency = $request->get('task_frequency');
            $nextDueDate = $request->get('next_due_date');
            $nextRemindDate = $request->get('next_remind_date');
            $status = $request->get('status');
            $alertStatus = $request->get('alert_status');
            $findings = $request->get('findings');
            

            // Create a new compliance task
            $complianceTask = new ComplianceTask();
            $complianceTask->task_name = $taskName;
            $complianceTask->task_description = $taskDescription;
            $complianceTask->responsible_employee_id = $responsibleEmployeeId;
            $complianceTask->task_frequency = $taskFrequency;
            $complianceTask->next_due_date = $nextDueDate;
            $complianceTask->next_remind_date = $nextRemindDate;
            $complianceTask->status = $status;
            $complianceTask->alert_status = $alertStatus;
            $complianceTask->findings = $findings;

            // Save the compliance task
            $result = $complianceTask->save();

            if ($result) {
                $responseBody = $this->responseBody(true, "Compliance Task", "saved", $complianceTask);
            } else {
                $responseBody = $this->responseBody(false, "Compliance Task", "error", null);
            }
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "Compliance Task", "error", $ex->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }

    public function update(Request $request, $task_id){
        try {
            // Extract data from the request
            $taskId = $request->get('task_id');
            $taskName = $request->get('task_name');
            $taskDescription = $request->get('task_description');
            $responsibleEmployeeId = $request->get('responsible_employee_id');
            $taskFrequency = $request->get('task_frequency');
            $nextDueDate = $request->get('next_due_date');
            $nextRemindDate = $request->get('next_remind_date');
            $status = $request->get('status');
            $alertStatus = $request->get('alert_status');
            $findings = $request->get('findings');

            // Find the compliance task to update
            $complianceTask = ComplianceTask::find($taskId);
            $complianceTask->task_name = $taskName;
            $complianceTask->task_description = $taskDescription;
            $complianceTask->responsible_employee_id = $responsibleEmployeeId;
            $complianceTask->task_frequency = $taskFrequency;
            $complianceTask->next_due_date = $nextDueDate;
            $complianceTask->next_remind_date = $nextRemindDate;
            $complianceTask->status = $status;
            $complianceTask->alert_status = $alertStatus;
            $complianceTask->findings = $findings;

            // Save the updated compliance task
            $result = $complianceTask->save();

            if ($result) {
                $responseBody = $this->responseBody(true, "Compliance Task", "updated", $complianceTask);
            } else {
                $responseBody = $this->responseBody(false, "Compliance Task", "error", null);
            }
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "Compliance Task", "error", $ex->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }

    public function delete(Request $request, $taskId){
        try {
            // Find the compliance task by ID
            $complianceTask = ComplianceTask::find($taskId);

            if (!$complianceTask) {
                return response()->json([
                    'data' => $this->responseBody(false, "Compliance Task", "not found", null)
                ]);
            }

            // Delete the compliance task
            $result = $complianceTask->delete();

            if ($result) {
                $responseBody = $this->responseBody(true, "Compliance Task", "deleted", null);
            } else {
                $responseBody = $this->responseBody(false, "Compliance Task", "error", null);
            }
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "Compliance Task", "error", $ex->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }

    // public function getAllEmployees1()
    // {
    //     try {
    //         $employees =  Employee::select('employee_id As id', 'name_withinitial As value0')->get();
    //         return $this->responseBody(true, "ComplianceTaskController", "allEmployees", $employees);
    //     } catch (\Exception $exception) {
    //         return $this->responseBody(false, "ComplianceTaskController", "error", $exception);
    //     }
    // }

    function getAllEmployees()
    {
        try {
            $emp_arr = [];
            $emp_data = Employee::all();
            foreach ($emp_data as $emp) {
                array_push($emp_arr, [
                "img" => "", 
                "id" => $emp['employee_id'], 
                "value" => $emp->employee_id . ' - ' . $emp->name_withinitial
            ]);
            }
            $responseBody = $this->responseBody(true, "allempName", "Found", $emp_arr);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "allempName", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    private function getEmployeeNameById($employeeId)
    {
        $employee = Employee::find($employeeId);
        return $employee ? $employee->name_withinitial : 'Unknown';
    }


    //response body
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }

}
