
$(document).ready(function () {
    
    var compliance_renewals_table = $("#complianceRenewalsTable").DataTable({
        responsive: true,
        paging: false,
        searching: false,
        info: false,
        ordering: false,
        lengthChange: false,
        order: [],
        columns: [
            { data: "renewal_id" },
            { data: "task_id" },
            { data: "task" },
            { data: "document_name" },
            { data: "employee" },
            { data: "renewal_due_date" },
            { data: "next_remind_date" },
            { data: "renewal_status" },
            { data: "edit" },
            { data: "view" },
            { data: "delete" },
        ],
        columnDefs: [
            { width: 100, targets: 0, visible: false },
            { width: 100, targets: 1, visible: false },
            { width: 100, targets: 2 },
            { width: 50, targets: 3 },
            { width: 50, targets: 4 },
            { width: 50, targets: 5 },
            { width: 50, targets: 6 },
            { width: 50, targets: 7 },
            { width: 50, targets: 8 },
            { width: 50, targets: 9 },
            { width: 50, targets: 10 },
        ],
    });

    $('input[type="date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {format: "YYYY-MM-DD",},
    });

    getAllComplianceRenewals();
    getAllEmployeesForSelect();
    getAllComplianceTasksForSelect();

    $("#btnSave").on("click", function () {
        if ($(this).text().trim().toLowerCase() === "update") {
            updateRenewal();
        } else {
            saveRenewal();
        }
    });
});

function getAllComplianceRenewals() {
    $.ajax({
        type: "GET",
        url: "/cm/compliance_renewals/load",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            if (response.data.success) {
                var data = [];
                response.data.result.forEach(function (renewal) {
                    data.push({
                        renewal_id: renewal.renewal_id,
                        task_id: renewal.task_id,
                        task: renewal.task_name, 
                        document_name: renewal.document_name,
                        renewal_due_date: renewal.renewal_due_date,
                        next_remind_date: renewal.next_remind_date,
                        renewal_status: renewal.renewal_status,
                        employee: renewal.employee_name, 
                        edit:
                            '<button class="btn btn-primary" onclick="showRenewalEditModal(' +
                            renewal.renewal_id +
                            ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        view:
                            '<button class="btn btn-success" onclick="showRenewalViewModal(' +
                            renewal.renewal_id +
                            ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        delete:
                            '<button class="btn btn-danger" onclick="_deleteRenewal(' +
                            renewal.renewal_id +
                            ')"><i class="fa fa-trash" aria-hidden="true"></i></button>',
                    });
                });

                // Clear and redraw the DataTable with new data
                var table = $("#complianceRenewalsTable").DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },
        error: function (error) {
            console.error("Error loading compliance renewals:", error);
        },
    });
}

function getAllEmployeesForSelect() {
    $.ajax({
        type: "GET",
        url: "/cm/compliance_tasks/get_all_employees_data",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            if (response.data.success) {
                console.log(response.data.result);
                let options =
                    '<option value="">Select Responsible Employee</option>';
                response.data.result.forEach(function (emp) {
                    options += `<option value="${emp.id}">${emp.value}</option>`; // Corrected the key names
                });
                $("#responsible_employee_id").html(options);
            } else {
                $("#responsible_employee_id").html(
                    '<option value="">No Employees Available</option>'
                );
            }
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {},
    });
}

function getAllComplianceTasksForSelect() {
    $.ajax({
        type: "GET",
        url: "/cm/compliance_tasks/get_all_for_select",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            if (response.data.success) {
                let options =
                    '<option value="">Select Compliance Task</option>';

                response.data.result.forEach(function (task) {
                    options += `<option value="${task.id}">${task.value}</option>`;
                });

                $("#task_id").html(options);
            } else {
                $("#task_id").html(
                    '<option value="">No Tasks Available</option>'
                );
            }
        },
        error: function (error) {
            console.error("Error fetching compliance tasks:", error);
            $("#task_id").html('<option value="">Error loading tasks</option>');
        },
        complete: function () {
            // Optional: Any cleanup actions after request completes
        },
    });
}

function showComplianceRenewalsModal() {
    resetForm();
    $("#btnSave").show();
    $("#btnSave").text("Save");
    $("#complianceRenewalModal").modal("show");
}

function showRenewalEditModal(renewalId) {
    resetForm(); 
    editRenewal(renewalId);
    $("#btnSave").show();
    $("#btnSave").text("Update");
    $("#complianceRenewalModal").modal("show");
}

function showRenewalViewModal(renewalId) {
    resetForm();
    editRenewal(renewalId);
    $("#btnSave").hide();
    $("#complianceRenewalModal").modal("show");
}

function saveRenewal() {
    
    const documentName = $("#document_name").val().trim();
    const taskId = $("#task_id").val();
    const renewalDueDate = $("#renewal_due_date").val();
    const nextRemindDate = $("#next_remind_date").val();
    const renewalStatus = $("#renewal_status").val();
    // const responsibleEmployeeId = $("#responsible_employee_id").attr("data-id");
    const responsibleEmployeeId = $("#responsible_employee_id").val();
    
    if (!documentName) {
        showWarningMessage("Document name is required.");
        $("#document_name").focus();
        return;
    }

    if (!taskId) {
        showWarningMessage("Please select a task.");
        $("#task_id").focus();
        return;
    }

    if (!renewalDueDate) {
        showWarningMessage("Renewal due date is required.");
        $("#renewal_due_date").focus();
        return;
    }

    const today = new Date().toISOString().split("T")[0];
    if (!renewalDueDate) {
        showWarningMessage("Enter Renewal due date.");
        $("#renewal_due_date").focus();
        return;
    }

    if (!nextRemindDate) {
        showWarningMessage("Enter Next remind date.");
        $("#next_remind_date").focus();
        return;
    }

    if (!renewalStatus) {
        showWarningMessage("Please select a renewal status.");
        $("#renewal_status").focus();
        return;
    }

    if (!responsibleEmployeeId) {
        showWarningMessage("Please select a responsible employee.");
        return;
    }
   
    var data = new FormData();
    data.append("document_name", documentName);
    data.append("task_id", taskId);
    data.append("renewal_due_date", renewalDueDate);
    data.append("next_remind_date", nextRemindDate);
    data.append("renewal_status", renewalStatus);
    data.append("responsible_employee_id", responsibleEmployeeId);

    $.ajax({
        url: "/cm/compliance_renewals/save",
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        type: "POST",
        enctype: "multipart/form-data",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        success: function (response) {
            if (response.data && response.data.success) {
                showSuccessMessage(
                    "Compliance renewal has been saved successfully."
                );
                resetForm();
                $("#complianceRenewalModal").modal("hide");
                getAllComplianceRenewals();
            } else {
                showErrorMessage(
                    response.data.message ||
                        "Failed to save the compliance renewal."
                );
            }
        },
        error: function (error) {
            console.error("Error saving compliance renewal:", error);
            showErrorMessage(
                "An error occurred while saving the compliance renewal."
            );
        },
    });
}

function editRenewal(renewalId) {
    $.ajax({
        type: "GET",
        url: "/cm/compliance_renewals/get/" + renewalId,
        success: function (response) {
            if (response.data.success) {
                var renewal = response.data.result;
                
                document.getElementById("renewal_id").value = renewalId;
                document.getElementById("task_id").value = renewal.task_id;
                document.getElementById("document_name").value = renewal.document_name;
                document.getElementById("responsible_employee_id").value = renewal.responsible_employee_id;
                document.getElementById("renewal_due_date").value = renewal.renewal_due_date;
                document.getElementById("next_remind_date").value = renewal.next_remind_date;
                document.getElementById("renewal_status").value = renewal.renewal_status;
               
            } else {
                showErrorMessage("Failed to load the renewal data.");
            }
        },
        error: function (error) {
            console.error("Error loading renewal:", error);
            showErrorMessage("An error occurred while loading the renewal data.");
        },
    });
}

function updateRenewal() {
    let renewal_id = document.getElementById("renewal_id").value;
     const documentName = $("#document_name").val().trim();
     const taskId = $("#task_id").val();
     const renewalDueDate = $("#renewal_due_date").val();
     const nextRemindDate = $("#next_remind_date").val();
     const renewalStatus = $("#renewal_status").val();
     // const responsibleEmployeeId = $("#responsible_employee_id").attr("data-id");
     const responsibleEmployeeId = $("#responsible_employee_id").val();

     if (!documentName) {
         showWarningMessage("Document name is required.");
         $("#document_name").focus();
         return;
     }

     if (!taskId) {
         showWarningMessage("Please select a task.");
         $("#task_id").focus();
         return;
     }

     if (!renewalDueDate) {
         showWarningMessage("Renewal due date is required.");
         $("#renewal_due_date").focus();
         return;
     }
     
     if (!renewalDueDate) {
         showWarningMessage("Enter Renewal due date.");
         $("#renewal_due_date").focus();
         return;
     }

     if (!nextRemindDate) {
         showWarningMessage("Enter Next remind date.");
         $("#next_remind_date").focus();
         return;
     }

     if (!renewalStatus) {
         showWarningMessage("Please select a renewal status.");
         $("#renewal_status").focus();
         return;
     }

     if (!responsibleEmployeeId) {
         showWarningMessage("Please select a responsible employee.");
         return;
    }
    
    var data = new FormData();
    data.append("renewal_id", renewal_id);
    data.append("document_name", documentName);
    data.append("task_id", taskId);
    data.append("renewal_due_date", renewalDueDate);
    data.append("next_remind_date", nextRemindDate);
    data.append("renewal_status", renewalStatus);
    data.append("responsible_employee_id", responsibleEmployeeId);

    $.ajax({
        url: "/cm/compliance_renewals/update/" + renewal_id,
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        type: "POST",
        enctype: "multipart/form-data",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        success: function (response) {
            if (response.data && response.data.success) {
                showSuccessMessage(
                    "Compliance task has been update successfully."
                );
                resetForm();
                $("#btnSave").text("Save");
                $("#complianceRenewalModal").modal("hide");
                getAllComplianceRenewals();
            } else {
                showErrorMessage(response.data.message ||"Failed to update the compliance task");
            }
        },
        error: function (error) {
            console.error("Error updating compliance task:", error);
            showErrorMessage(
                "An error occurred while updating the compliance task."
            );
        },
    });
}

function _deleteRenewal(renewalId) {
    if (confirm("Are you sure you want to delete this compliance renewal?")) {
        $.ajax({
            url: "/cm/compliance_renewals/delete/" + renewalId,
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
            type: "DELETE",
            success: function (response) {
                if (response.data.success) {
                    showSuccessMessage(
                        "Compliance task has been deleted successfully."
                    );
                    getAllComplianceRenewals();
                } else {
                    showErrorMessage(
                        response.data.message ||
                            "Failed to delete the compliance task."
                    );
                }
            },
            error: function (error) {
                console.error("Error deleting compliance task:", error);
                showErrorMessage(
                    "An error occurred while deleting the compliance task."
                );
            },
        });
    }
}








function getAllEmployees() {
    $.ajax({
        type: "GET",
        url: "/cm/compliance_tasks/get_all_employees_data",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            if (response.data.success) {
                $("#responsible_employee_id").empty();
                $("#responsible_employee_id").setData(response.data.result);
            }
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {},
    });
}








function update() {
    // Validate employee selection
    let task_id = document.getElementById("task_id").value;
    if (!task_id) {
        showWarningMessage("Task ID is missing");
        return;
    }
    let taskName = $("#task_name").val().trim();
    if (!taskName) {
        showWarningMessage("Task name is required");
        $("#task_name").focus();
        return;
    }
    if (!$("#responsible_employee_id").attr("data-id")) {
        showWarningMessage("Please select a responsible employee");
        return;
    }

    var data = new FormData();
    data.append("task_id", document.getElementById("task_id").value);
    data.append("task_name", document.getElementById("task_name").value);
    data.append(
        "task_description",
        document.getElementById("task_description").value
    );
    data.append(
        "responsible_employee_id",
        $("#responsible_employee_id").attr("data-id")
    );
    data.append(
        "task_frequency",
        document.getElementById("task_frequency").value
    );
    data.append(
        "next_due_date",
        document.getElementById("next_due_date").value
    );
    data.append(
        "next_remind_date",
        document.getElementById("next_remind_date").value
    );
    data.append("status", document.getElementById("status").value);
    data.append("alert_status", document.getElementById("alert_status").value);
    data.append("findings", document.getElementById("findings").value);

    $.ajax({
        url: "/cm/compliance_tasks/update/" + task_id,
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        type: "POST",
        enctype: "multipart/form-data",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        success: function (response) {
            if (response.data && response.data.success) {
                showSuccessMessage(
                    "Compliance task has been update successfully."
                );
                resetForm();
                $("#btnSave").text("Save");
                $("#complianceRenewalModal").modal("hide");
                getAllComplianceTasks();
            } else {
                showErrorMessage(
                    response.data.message ||
                        "Failed to update the compliance task"
                );
            }
        },
        error: function (error) {
            console.error("Error updating compliance task:", error);
            showErrorMessage(
                "An error occurred while updating the compliance task."
            );
        },
    });
}

function resetForm() {
    $("#complianceRenewalForm")[0].reset();
    $("#responsible_employee_id").val("");
    $("#responsible_employee_id").attr("data-id", "");
    $("#task_id").val("");
    $("#document_name").val("");
    $("#next_due_date").val("");
    $("#next_remind_date").val("");
    $("#renewal_status").val("");
}

/**
 * showSuccessMessage
 * This function is used to show success message.
 * @param message This is the paramter to require message content
 */
function showSuccessMessage(message) {
    toastr.success(message);
}

/**
 * showWarningMessage
 * This function is used to show warning message.
 * @param message This is the paramter to require message content
 */
function showWarningMessage(message) {
    toastr.warning(message);
}

/**
 * showErrorMessage
 * This function is used to show error message.
 * @param message This is the paramter to require message content
 */
function showErrorMessage() {
    toastr.error("Something went wrong");
}
