
var FORM_ID = undefined;
$(document).ready(function () {

    var compliance_task_table = $("#complianceTasksTable").DataTable({
        responsive: true,
        paging: false,
        searching: false,
        info: false,
        ordering: false,
        lengthChange: false,
        order: [],
        columns: [
            { data: "task_id" },
            { data: "task_name" },
            { data: "employee" },
            { data: "task_frequency" },
            { data: "next_due_date" },
            { data: "next_remind_date" },
            { data: "status" },
            { data: "alert_status" },
            { data: "edit" },
            { data: "view" },
            { data: "delete" },
        ],
        columnDefs: [
            { width: 50, targets: 0, visible: false },
            { width: 100, targets: 1 },
            { width: 100, targets: 2 },
            { width: 50, targets: 3 },
            { width: 50, targets: 4 },
            { width: 50, targets: 5 },
            { width: 50, targets: 6 },
            { width: 50, targets: 7 },
            { width: 30, targets: 8 },
            { width: 30, targets: 9 },
            { width: 30, targets: 10 },
        ],
    });

    $('input[type="date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: "YYYY-MM-DD",
        },
    });

    getAllComplianceTasks();
    getAllEmployees();

    $("#btnSave").on("click", function () {
        if ($(this).text().trim().toLowerCase() === "update") {
            update();
        } else {
            save();
        }
    });

});


function getAllComplianceTasks() {
    
    $.ajax({
        type: "GET",
        url: "/cm/compliance_tasks/load",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            if (response.data.success) {
                var data = [];
                response.data.result.forEach(function (task) {
                    data.push({
                        task_id: task.task_id,
                        task_name: task.task_name,
                        employee: task.employee_name,
                        task_frequency: task.task_frequency,
                        next_due_date: task.next_due_date,
                        next_remind_date: task.next_remind_date,
                        status: task.status,
                        alert_status: task.alert_status,
                        edit:
                            '<button class="btn btn-primary" onclick="showComplianceEditModal(' +
                            task.task_id +
                            ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        view:
                            '<button class="btn btn-success" onclick="showComplianceViewModal(' +
                            task.task_id +
                            ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        delete:
                            '<button class="btn btn-danger" onclick="_delete(' +
                            task.task_id +
                            ')"><i class="fa fa-trash" aria-hidden="true"></i></button>',
                    });
                });

                // Clear and redraw the DataTable with new data
                var table = $("#complianceTasksTable").DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },
        error: function (error) {
            console.error("Error loading compliance tasks:", error);
        },
    });
}

function getAllEmployees() {
    $.ajax({
        type: "GET",
        url: "/cm/compliance_tasks/get_all_employees_data",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            if (response.data.success) {
                $("#responsible_employee_id").empty();
                $("#responsible_employee_id").setData(response.data.result);
            }
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {},
    });
}

function showComplianceCreateModal() {
    resetForm();
    $("#btnSave").show();
    $("#btnSave").text("Save");
    $("#complianceTaskModal").modal("show");
}

function showComplianceEditModal(taskId) {
    resetForm();
    edit(taskId);

    //save button show
    $("#btnSave").show();
    $("#btnSave").text("Update");
    $("#complianceTaskModal").modal("show");
}

function showComplianceViewModal(taskId) {
    resetForm();
    edit(taskId);
    //hide the save button
    $("#btnSave").hide();
    $("#complianceTaskModal").modal("show");
}


function edit(taskId) {
    $.ajax({
        type: "GET",
        url: "/cm/compliance_tasks/get/" + taskId, 
        success: function (response) {
            if (response.data.success) {
                var task = response.data.result;
                var employee = task.responsible_employee_id +' - '+ task.employee_name;
                // Populate the modal form with the task data
                document.getElementById("task_id").value = taskId;
                document.getElementById('task_name').value = task.task_name;
                document.getElementById('task_description').value = task.task_description;
               
                // Set the value for data-id attribute
                $('#responsible_employee_id').attr('data-id', task.responsible_employee_id);
                $("#responsible_employee_id").val(employee).trigger("change");
                
                document.getElementById('task_frequency').value = task.task_frequency;
                document.getElementById('next_due_date').value = task.next_due_date;
                document.getElementById('next_remind_date').value = task.next_remind_date;
                document.getElementById('status').value = task.status;
                document.getElementById('alert_status').value = task.alert_status;
                document.getElementById('findings').value = task.findings;

                
            } else {
                showErrorMessage("Failed to load the compliance task.");
            }
        },
        error: function (error) {
            console.error("Error loading compliance task:", error);
            showErrorMessage("An error occurred while loading the compliance task.");
        },
    });
}

function _delete(taskId) {
    if (confirm("Are you sure you want to delete this compliance task?")) {
        $.ajax({
            url: "/cm/compliance_tasks/delete/" + taskId,
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
            type: "DELETE",
            success: function (response) {
                if (response.data.success) {
                    showSuccessMessage("Compliance task has been deleted successfully.");
                    getAllComplianceTasks(); 
                } else {
                    showErrorMessage(response.data.message ||"Failed to delete the compliance task.");
                }
            },
            error: function (error) {
                console.error("Error deleting compliance task:", error);
                showErrorMessage("An error occurred while deleting the compliance task.");
            },
        });
    }
}

function save() {

    // Validate employee selection
    const taskName = $("#task_name").val().trim();
    if (!taskName) {
        showWarningMessage("Task name is required");
        $("#task_name").focus();
        return;
    }
    if (!$('#responsible_employee_id').attr('data-id')) {
        showWarningMessage('Please select a responsible employee');
        return;
    }
    
    var data = new FormData();

    // Capture values using their IDs and append to FormData
    data.append('task_name', document.getElementById('task_name').value);
    data.append('task_description', document.getElementById('task_description').value);
    data.append('responsible_employee_id', $('#responsible_employee_id').attr('data-id'));
    data.append('task_frequency', document.getElementById('task_frequency').value);
    data.append('next_due_date', document.getElementById('next_due_date').value);
    data.append('next_remind_date', document.getElementById('next_remind_date').value);
    data.append('status', document.getElementById('status').value);
    data.append('alert_status', document.getElementById('alert_status').value);
    data.append('findings', document.getElementById('findings').value);

    $.ajax({
        url: "/cm/compliance_tasks/save",
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        type: "POST",
        enctype: "multipart/form-data",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        success: function (response) {
            if (response.data && response.data.success) {
                showSuccessMessage("Compliance task has been update successfully.");
                resetForm();
                $("#complianceTaskModal").modal("hide");
                getAllComplianceTasks();
            } else {
                showErrorMessage(response.data.message || "Failed to save the compliance task");
            }
        },
        error: function (error) {
            console.error("Error saving compliance task:", error);
            showErrorMessage("An error occurred while saving the compliance task.");
        },
    });
}

function update() {

    // Validate employee selection
    let task_id = document.getElementById("task_id").value;
    if (!task_id) {
        showWarningMessage("Task ID is missing");
        return;
    }
    let taskName = $("#task_name").val().trim();
    if (!taskName) {
        showWarningMessage("Task name is required");
        $("#task_name").focus();
        return;
    }
    if (!$('#responsible_employee_id').attr('data-id')) {
        showWarningMessage('Please select a responsible employee');
        return;
    }
   
    var data = new FormData();
    data.append("task_id", document.getElementById("task_id").value);
    data.append('task_name', document.getElementById('task_name').value);
    data.append('task_description', document.getElementById('task_description').value);
    data.append('responsible_employee_id', $('#responsible_employee_id').attr('data-id'));
    data.append('task_frequency', document.getElementById('task_frequency').value);
    data.append('next_due_date', document.getElementById('next_due_date').value);
    data.append('next_remind_date', document.getElementById('next_remind_date').value);
    data.append('status', document.getElementById('status').value);
    data.append('alert_status', document.getElementById('alert_status').value);
    data.append('findings', document.getElementById('findings').value);

    $.ajax({
        url: "/cm/compliance_tasks/update/" + task_id,
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        type: "POST",
        enctype: "multipart/form-data",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        success: function (response) {
            if (response.data && response.data.success) {
                showSuccessMessage("Compliance task has been update successfully.");
                resetForm();
                $("#btnSave").text("Save");
                $("#complianceTaskModal").modal("hide");
                getAllComplianceTasks();
            } else {
                showErrorMessage(response.data.message ||"Failed to update the compliance task");
            }
        },
        error: function (error) {
            console.error("Error updating compliance task:", error);
            showErrorMessage("An error occurred while updating the compliance task.");
        },
    });
}

function resetForm() {
    $("#complianceTaskForm")[0].reset();
    $("#responsible_employee_id").val("");
    $("#responsible_employee_id").attr("data-id", "");
    $("#task_name").val("");
    $("#task_description").val("");
    $("#next_due_date").val("");
    $("#next_remind_date").val("");
    $("#findings").val("");
}

/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}