@extends('cm::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/employee.css') }}" type="text/css">
<link rel="stylesheet" href="{{ Module::asset('pp:js/autocomplete2/css/autocomplete.min.css') }}">
<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/settings.css') }}" media="all" type="text/css" />
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">

<meta name="csrf-token" content="{{ csrf_token() }}">

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Compliance Renewals Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Compliance Renewals</h6>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <button type="button" onclick="showComplianceRenewalsModal()" class="btn btn-primary text-end">
                            <i class="fa fa-plus " aria-hidden="true"></i>
                        </button>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="card-body">
                            <h6 class="card-title">Compliance Renewals List</h6>
                            {{ csrf_field() }}
                            <table id="complianceRenewalsTable"
                                class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid">
                                <thead>
                                    <tr>
                                        <th>Renewal ID</th>
                                        <th>Task ID</th>
                                        <th>Task</th>
                                        <th>Document Name</th>
                                        <th>Responsible Employee</th>
                                        <th>Renewal Due Date</th>
                                        <th>Next Remind Date</th>
                                        <th>Renewal Status</th>
                                        <th>Edit</th>
                                        <th>View</th>
                                        <th>Delete</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>

                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<!-- Compliance Renewal Modal -->
<div class="modal fade" id="complianceRenewalModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add Compliance Renewal</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="complianceRenewalForm">
                    @csrf
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="document_name">Document Name</label>
                            <input type="hidden" id="renewal_id" name="renewal_id">
                            <input type="text" class="form-control" id="document_name" name="document_name" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="task_id">Compliance Task</label>
                            <select class="form-control" id="task_id" name="task_id" required>
                                <option value="">Select Compliance Task</option>
                                <!-- Options will be dynamically loaded -->
                            </select>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="responsible_employee_id">Responsible Employee</label>
                            <select class="form-control" id="responsible_employee_id" name="responsible_employee_id" required>
                                <option value="">Select Responsible Employee</option>
                                <!-- Options will be dynamically loaded -->
                            </select>
                            {{-- <input type="text" class="form-control auto-complete required-input"
                                id="responsible_employee_id" name="responsible_employee_id"
                                placeholder="Please Select Employee" required> --}}
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="renewal_status">Renewal Status</label>
                            <select class="form-control" id="renewal_status" name="renewal_status" required>
                                <option value="">Select Renewal Status</option>
                                <option value="Pending">Pending</option>
                                <option value="Completed">Completed</option>
                                <option value="Overdue">Overdue</option>
                            </select>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="next_remind_date">Next Remind Date</label>
                            <input type="date" class="form-control" id="next_remind_date" name="next_remind_date">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="renewal_due_date">Renewal Due Date</label>
                            <input type="date" class="form-control" id="renewal_due_date" name="renewal_due_date" required>
                        </div>
                        
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary" id="btnSave">Save</button>
                        <button type="button" class="btn btn-warning" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>



@endsection
<!-- JQuery -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

@section('script')

<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('assets/js/examples/datatable.js') }}"></script>
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<!-- Sweet alert -->
<script src="{{ url('assets/js/examples/sweet-alert.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('cm:js/autocomplete2/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('cm:js/progress_widget.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('cm:js/components_progress.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('cm:js/data_chooser.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('cm:js/rquired_input.min.js') }}?random=<?php echo uniqid(); ?>"></script>


<script src="{{ Module::asset('cm:js/compliance_renewals.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection
