<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
use App\Http\Controllers\OrderStatusHistoryController;
use Illuminate\Support\Facades\Route;
use Modules\Cm\Http\Controllers\ComplianceTaskController;
use Modules\Cm\Http\Controllers\ComplianceRenewalController;

Route::prefix('cm')->group(function() {
     
    Route::get('/dashboard', function () {
        return view('cm::dashboard');
    })->middleware('is.logged');

    Route::get('/compliance_tasks', function () {
        return view('cm::compliance_tasks');
    })->middleware('is.logged');

    Route::get('/compliance_renewals', function () {
        return view('cm::compliance_renewals');
    })->middleware('is.logged');

    // Compliance Task 
    Route::post('compliance_tasks/save', [ComplianceTaskController::class, 'save']);
    Route::get('compliance_tasks/get_all_employees_data', [ComplianceTaskController::class, 'getAllEmployees']);
    Route::get('compliance_tasks/load', [ComplianceTaskController::class, 'getAllComplianceTasks']);
    Route::get('compliance_tasks/get/{id}', [ComplianceTaskController::class, 'getComplianceTask']);
    Route::post('compliance_tasks/update/{id}', [ComplianceTaskController::class, 'update']);
    Route::delete('compliance_tasks/delete/{id}', [ComplianceTaskController::class, 'delete']);
    // End Of Compliance Task

    // Compliance Renewal
    Route::post('compliance_renewals/save', [ComplianceRenewalController::class, 'save']);
    Route::get('compliance_renewals/load', [ComplianceRenewalController::class, 'getAllComplianceRenewals']);
    Route::get('compliance_renewals/get/{id}', [ComplianceRenewalController::class, 'getComplianceRenewal']);
    Route::post('compliance_renewals/update/{id}', [ComplianceRenewalController::class, 'updateRenewal']);
    Route::delete('compliance_renewals/delete/{id}', [ComplianceRenewalController::class, 'deleteRenewal']);
    Route::get('compliance_tasks/get_all_for_select', [ComplianceRenewalController::class, 'getAllComplianceTasksForSelect']);
    // End Of Compliance Renewal

});
