<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEmployeeSupplyPlansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fo_employee_supply_plans', function (Blueprint $table) {
            $table->id('employee_supply_plan_id');
            $table->string('employee_id')->default('Unspecified');
            $table->string('supplier_id');
            $table->date('trans_date');
            $table->string('product_id');
            $table->string('quantity');
            $table->boolean('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_supply_plans');
    }
}
