<?php

namespace Modules\Fo\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class EmployeeSupplyCollection extends Model
{
    protected $table = 'fo_employee_supply_collections';
    protected $primaryKey = 'employee_supply_collection_id';
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'employee_supply_collection_id',
        'employee_id',
        'supplier_id',
        'trans_date',
        'product_id',
        'collection_quantity',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "fo_employee_supply_collections";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }

    // protected $fillable = [];
    
    // protected static function newFactory()
    // {
    //     return \Modules\Fo\Database\factories\EmployeeSupplyCollectionFactory::new();
    // }
}
