<?php

namespace Modules\Fo\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class PlanProductEmployeeDaily extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'fo_plan_product_employee_dailies';
    protected $primaryKey = 'plan_product_employee_dailie_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'plan_product_employee_dailie_id',
        'site_id',
        'field_officer_id',
        'product_primary_id',
        'supplier_id',
        'date',
        'quantity',
        'supplier_name',
        'visit_area',
        'remarks',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "fo_plan_product_employee_dailies";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
