<?php

namespace Modules\Fo\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use App\Models\employees;
use Illuminate\Support\Facades\DB;

use Illuminate\Routing\Controller;

class EmlpoyeeSupplierController extends Controller
{
    function GetSupplierId() {
        //this function is debuged by nipuna
        try{
            $field_officers_array = [];
            $field_officers = employees::where('designation_id','=',30)->get();
            for($i = 0; $i < count($field_officers); $i++) {
                array_push($field_officers_array, ["img" => $field_officers[$i]['photo_parth'], "id" => $field_officers[$i]['employee_id'], "value" =>  $field_officers[$i]['employee_id']]);
            }
            $field_officers = employees::where('designation_id','=',108)->get();
            for($i = 0; $i < count($field_officers); $i++) {
                array_push($field_officers_array, ["img" => $field_officers[$i]['photo_parth'], "id" => $field_officers[$i]['employee_id'], "value" =>  $field_officers[$i]['employee_id']]);
            }
            $responseBody = $this->responseBody(true, "Supplier", "All", $field_officers_array);
        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "Supplier", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);    }
     //by nipuma end

     function GetAllSupplierData() {
        try{
            $products = DB::table('st_suppliers')
            ->join('fo_employee_supply_plans', 'st_suppliers.supplier_id', '=', 'fo_employee_supply_plans.supplier_id')
            ->join('st_towns', 'st_suppliers.town_id', '=', 'st_towns.town_id')
            ->join('st_supplier_contacts', 'st_suppliers.supplier_id', '=', 'st_supplier_contacts.supplier_foriegn_id')
            ->join('st_products', 'fo_employee_supply_plans.product_id', 'st_products.product_id')
            ->get();

            $responseBody = $this->responseBody(true, "Suppliers", "All", $products);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "Suppliers", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);
    }
    function GetFieldOfficerName() {
        try{
            $field_officers_array = [];
            $field_officers = employees::where('designation_id', 30)->get();
            for($i = 0; $i < count($field_officers); $i++) {
                array_push($field_officers_array, ["img" => $field_officers[$i]['photo_parth'], "id" => $field_officers[$i]['employee_id'], "value" => $field_officers[$i]['name_withinitial'] ]);
            }
            $field_officers = employees::where('designation_id', 108)->get();
            for($i = 0; $i < count($field_officers); $i++) {
                array_push($field_officers_array, ["img" => $field_officers[$i]['photo_parth'], "id" => $field_officers[$i]['employee_id'], "value" => $field_officers[$i]['name_withinitial'] ]);
            }
            $responseBody = $this->responseBody(true, "Supplier", "All", $field_officers_array);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "Supplier", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);    }

    function GetOfficerNameById($id) {
        try{$officer = employees::where('employee_id', '=', $id)->get();
            $responseBody = $this->responseBody(true, "Officer Name", "Found", $officer);

        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Officer Name", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);
    }
    function GetSupplierPlanByEmployee($id) {
        try{
            $result = DB::table('fo_employee_supply_plans')->where('employee_id', '=', $id)
            ->join('st_suppliers', 'fo_employee_supply_plans.supplier_id', '=', 'st_suppliers.supplier_id')
            ->join('st_towns', 'st_suppliers.town_id', '=', 'st_towns.town_id')
            ->join('st_supplier_contacts', 'st_suppliers.supplier_id', '=', 'st_supplier_contacts.supplier_foriegn_id')
            ->join('st_products', 'fo_employee_supply_plans.product_id', 'st_products.product_id')
            ->get();

            $responseBody = $this->responseBody(true, "Supplier Plan By Employee", "Found", $result);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "Supplier Plan By Employee", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);
    }
    function GetSuppliersByEmployee($id) {
        try{$result = DB::table('fo_employee_supplier')->where('employee_id', '=', $id)
                        ->join('st_suppliers', 'fo_employee_supplier.supplier_id', '=', 'st_suppliers.supplier_id')
                        ->get();

            $responseBody = $this->responseBody(true, "Suppliers By Employee", "Found", $result);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "Suppliers By Employee", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);
    }
    function responseBody($success, $name, $message, $result) {
        $body = [
            "success" => $success,
            "name" => $name,
            "message" => $message,
            "result" => $result
        ];
        return $body;
    }
}
