<?php

namespace Modules\Fo\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use App\Models\employees;
use App\Models\suppliers;
use Illuminate\Support\Facades\DB;
use Modules\Fo\Entities\EmployeeSupplier;
use Modules\Fo\Entities\OtherActivityType;
use Modules\Fo\Entities\SupplierVisit;
use Modules\Hr\Entities\Employee;

class FoController extends Controller
{

    function getFieldOfficerNametoId($id)
    {
        try {
            $field_officers = employees::select('name_withinitial', 'photo_parth')->where('employee_id', $id)->first();
            $responseBody = $this->responseBody(true, "employee name", "All", $field_officers);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "employee name", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }
    function GetSingleFiledOfficer($id)
    {
        try { //$field_officers = hr_employees::select('employee_id')->where('employee_id', $id)->first();

            $field_officer = DB::table('hr_employees')
                ->select('name_withinitial')
                ->where('employee_id', $id)
                ->first();


            // $field_officers_array = [];
            // for($i = 0; $i < count($field_officers); $i++) {
            //     array_push($field_officers_array, ["img" => $field_officers[$i]['photo_parth'], "id" => $field_officers[$i]['employee_id'], "value" => $field_officers[$i]['name_withinitial'] ]);
            // }
            $responseBody = $this->responseBody(true, "employee name", "All", $field_officer);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "employee name", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    function getDesignationId($id)
    {
        try {
            $field_officerId = Employee::select('designation_id')->where('employee_id', $id)->first();

            // $field_officerId = DB::table('hr_employees')
            //     ->select('designation_id')
            //     ->where('employee_id', $id)
            //     ->first();


            // $field_officers_array = [];
            // for($i = 0; $i < count($field_officers); $i++) {
            //     array_push($field_officers_array, ["img" => $field_officers[$i]['photo_parth'], "id" => $field_officers[$i]['employee_id'], "value" => $field_officers[$i]['name_withinitial'] ]);
            // }
            $responseBody = $this->responseBody(true, "employee id", "All", $field_officerId);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "employee id", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    //by nipuna start

    //by nipuma end

    function GetSupplierPlanByEmployeeToCalendar($id)
    {
        try {
            $result = DB::table('fo_employee_supply_plans')->where('employee_id', '=', $id)
                ->join('st_suppliers', 'fo_employee_supply_plans.supplier_id', '=', 'st_suppliers.supplier_id')
                ->join('st_towns', 'st_suppliers.town_id', '=', 'st_towns.town_id')
                ->join('st_supplier_contacts', 'st_suppliers.supplier_id', '=', 'st_supplier_contacts.supplier_foriegn_id')
                ->join('st_products', 'fo_employee_supply_plans.product_id', 'st_products.product_id')
                ->where('fo_employee_supply_plans.employee_id', '=', $id)
                ->groupBy('fo_employee_supply_plans.supplier_id', 'fo_employee_supply_plans.trans_date')
                ->get();

            $responseBody = $this->responseBody(true, "Supplier Plan By Employee", "Found", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Supplier Plan By Employee", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    function GetDataToDisplayInModal($id)
    {
        try {
            $result = DB::table('fo_employee_supply_plans')->where('employee_id', '=', $id)
                ->join('st_suppliers', 'fo_employee_supply_plans.supplier_id', '=', 'st_suppliers.supplier_id')
                ->join('st_towns', 'st_suppliers.town_id', '=', 'st_towns.town_id')
                ->join('st_supplier_contacts', 'st_suppliers.supplier_id', '=', 'st_supplier_contacts.supplier_foriegn_id')
                ->join('st_products', 'fo_employee_supply_plans.product_id', 'st_products.product_id')
                ->get();

            $responseBody = $this->responseBody(true, "Data To Modal", "Error", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Data To Modal", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    function GetSupplyPlanDataToModal(Request $request)
    {
        try {
            $employee_id = $request->get('employee_id');
            $trans_date = $request->get('date');

            $result = DB::table('fo_employee_supply_plans')
                ->where('employee_id', '=', $employee_id)
                ->where('trans_date', '=', $trans_date)
                ->join('st_products', 'st_products.product_id', '=', 'fo_employee_supply_plans.product_id')
                ->get();

            $responseBody = $this->responseBody(true, "Supply Plan Data To Modal", "Found", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Supply Plan Data To Modal", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    
    function allType()
    {
        try {
            $types = OtherActivityType::all();

            $responseBody = $this->responseBody(true, "FoController", "allType", $types);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "FoController", "allType", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    function GetEmployees()
    {
        try {
            $result = DB::table('hr_employees')->where('designation_id', '=', 30)->get();

            $responseBody = $this->responseBody(true, "Employees", "Found", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employees", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    function GetSuppliers()
    {
        try {
            $result = DB::table('st_suppliers')
                    ->where('supplier_type_id', 1)
                    ->get();

            $responseBody = $this->responseBody(true, "Row Suppliers", "Found", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Suppliers", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    function GetSupplierAddressBySupplierID($id)
    {
        try {
            $result = DB::table('st_suppliers')->where('supplier_id', '=', $id)->get();

            $responseBody = $this->responseBody(true, "Supplier Address By ID", "Found", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Supplier Address By ID", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    function AssignNewSuppliers(Request $request)
    {
        try {
            $EmployeeSupplier = new EmployeeSupplier();

            $EmployeeSupplier->employee_id = $request->get('employee_id');
            $EmployeeSupplier->supplier_id = $request->get('supplier_id');

            $save = $EmployeeSupplier->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Assigned New Supplier", "Done", $request->get('employee_id'));
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Assigned New Supplier", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    function DeleteAssignedSuppliers($id)
    {
        try {
            $Employeeid = EmployeeSupplier::where('employee_supplier_id', $id)->select('employee_id')->first();

            $EmployeeSupplier = EmployeeSupplier::find($id);
            $delete = $EmployeeSupplier->delete();

            if ($delete) {
                $responseBody = $this->responseBody(true, "Employee Supplier", "Deleted", $Employeeid);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee Supplier", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "name" => $name,
            "message" => $message,
            "result" => $result
        ];
        return $body;
    }
}
