<?php

namespace Modules\Fo\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Fo\Entities\PlanProductEmployeeDaily;

class PlanProductEmployeeDailyListController extends Controller
{

    public function getOfficerPlanList()
    {

        try {
            $officerPlanList = DB::select('SELECT DISTINCT hr_employee_sites.site,hr_employee_sites.site_id,
            hr_employees.name_withinitial,
            hr_employees.employee_id,
            YEAR(fo_plan_product_employee_dailies.date) AS year,
            MONTH(fo_plan_product_employee_dailies.date) AS month,
            st_products.product_name,st_products.product_primary_id FROM fo_plan_product_employee_dailies
            INNER JOIN hr_employee_sites ON fo_plan_product_employee_dailies.site_id = hr_employee_sites.site_id
            INNER JOIN hr_employees ON fo_plan_product_employee_dailies.field_officer_id =  hr_employees.employee_id
            INNER JOIN st_products ON fo_plan_product_employee_dailies.product_primary_id = st_products.product_primary_id');

            $responseBody = $this->responseBody(true, "PlanProductEmployeeController", "getOfficerPlanList", $officerPlanList);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanProductEmployeeController", "getOfficerPlanList", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function delete($site_id, $officer_id, $product_primary_id, $year, $month)
    {
        try {
            PlanProductEmployeeDaily::where([['site_id', '=', $site_id], ['field_officer_id', '=', $officer_id], ['product_primary_id', '=', $product_primary_id]])->whereYear('date', $year)->whereMonth('date', $month)->delete();

            $responseBody = $this->responseBody(true, "PlanProductEmployeeController", "delete", true);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanProductEmployeeController", "delete", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
