//alert('JS loading');
$(document).ready(function () {

    var fieldOfficer = is_fieldOfficer(uid);
    if (fieldOfficer) {
        loadEmployee(uid);
        $('#txtFieldOfficerID').attr("data-id", uid);
        $('#txtFieldOfficerName').attr("data-id", uid);
    } else {
        loadFieldOfficer();
    }


    var datepicker = $('input[name="daterangepicker"]').daterangepicker({
        singleDatePicker: false,
        showDropdowns: true,
        locale: {
            format: 'YYYY/MM/DD',
        }
    });

    datepicker.bind("change", function () {
        var start_date = $('#txtDate').data('daterangepicker').startDate.toISOString().slice(0, 10);
        var end_date = $('#txtDate').data('daterangepicker').endDate.toISOString().slice(0, 10);
        var id = $('#txtFieldOfficerID').optionID();
        loadSupplyPlan(id, start_date, end_date);

    });

    $('#txtFieldOfficerID').on('change', function () {
        var id = $(this).optionID();
        $('#txtFieldOfficerName').attr("data-id", id);
        loadEmployee(id);
    });

    $('#txtFieldOfficerName').on('change', function () {
        var id = $(this).optionID();
        $('#txtFieldOfficerID').attr("data-id", id);

        loadEmployee(id);
    });


    $('#myTable').DataTable({
        responsive: true,
        "order": [],
        "columns": [
            { "data": "supplier_id" },
            { "data": "supplier_name" },
            { "data": "trans_date" },
            { "data": "edit", className: "edit" },
            // { "data": "view" },
            // { "data": "delete" },
        ],
    });

})



function edit(id) {
    //console.log(supply_plan_id);
    location.href = '/fo/planned_materials?' + id;
}


// sampath //

function is_fieldOfficer(id) {
    var bool = false;
    $.ajax({
        type: "GET",
        url: '/fo/supplyplan/isFieldOfficer/' + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                bool = response.data.result;

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });

    return bool;
}



function loadEmployee(employee_id) {

    $.ajax({
        type: "GET",
        url: '/fo/supplyplan/employee/' + employee_id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                var employee = response.data.result;
                $('#imgEmployee').attr("src", employee.photo_parth);
                $('#txtFieldOfficerName').val(employee.name_withinitial);
                $('#txtFieldOfficerID').val(employee.employee_id);

                var start_date = $('#txtDate').data('daterangepicker').startDate.toISOString().slice(0, 10);
                var end_date = $('#txtDate').data('daterangepicker').endDate.toISOString().slice(0, 10);
                loadSupplyPlan(employee.employee_id, start_date, end_date);
            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });

}


/**
* fieldofficer_ID
* This function is used to load fieldofficer id 
*/
function loadFieldOfficer() {


    $.ajax({
        type: "GET",
        url: '/fo/supplyplan/allFieldOfficer',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                var id = response.data.result.id;
                var name = response.data.result.name;

                $('#txtFieldOfficerID').setData(id);
                $('#txtFieldOfficerName').setData(name);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });

}


function loadSupplyPlan(id, start_date, end_date) {
    $.ajax({
        type: "GET",
        url: '/fo/supplyplan/GetSupplyPlanList/' + id + "/" + start_date + "/" + end_date,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var data = [];
                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['plan_id'];
                    var supplier_name = response.data.result[i]['supplier_name'];
                    var date = response.data.result[i]['trans_date'];
                    data.push({
                        "supplier_id": id,
                        "supplier_name": supplier_name,
                        "trans_date": date,
                        "edit": '<button class="btn btn-primary" onclick="edit(' + id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                    });
                }

                //table
                var table = $('#myTable').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}
