$(document).ready(function () {

    $('#tableOfficerPlanList').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "site" },
            { "data": "officer" },
            { "data": "year" },
            { "data": "month" },
            { "data": "item" },
            { "data": "edit" },
            { "data": "view" },
            { "data": "delete" },
        ],
        columnDefs: [
            { width: 80, targets: 2 },
            { width: 80, targets: 3 },
            { width: 30, targets: 5 },
            { width: 30, targets: 6 },
            { width: 30, targets: 7 }
        ],
    });

    getOfficerPlanList();


});




function getOfficerPlanList() {


    var MONTH_NAME_EN = {
        1: 'january',
        2: 'February',
        3: 'March',
        4: 'April',
        5: 'May',
        6: 'June',
        7: 'July',
        8: 'August',
        9: 'September',
        10: 'October',
        11: 'November',
        12: 'December',
    }


    $.ajax({
        type: "GET",
        url: "/fo/PlanProductEmployeeDailyListController/getOfficerPlanList",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(response);
            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {

                    var site_id = response.data.result[i]['site_id'];
                    var officer_id = response.data.result[i]['employee_id'];
                    var product_primary_id = response.data.result[i]['product_primary_id'];

                    var site = response.data.result[i]['site'];
                    var officer = response.data.result[i]['name_withinitial'];
                    var year = response.data.result[i]['year'];
                    var month = response.data.result[i]['month'];
                    var item = response.data.result[i]['product_name'];

                    var str_site_id = "'" + site_id + "'";
                    var str_officer_id = "'" + officer_id + "'";
                    var str_product_primary_id = "'" + product_primary_id + "'";
                    var str_year = "'" + year + "'";
                    var str_month = "'" + month + "'";

                    var edit_button = '<button type="button" class="btn btn-primary" onclick="edit(' + str_site_id + ',' + str_officer_id + ',' + str_product_primary_id + ',' + str_year + ',' + str_month + ')" ><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>';
                    var view_button = '<button type="button" class="btn btn-success" onclick="view(' + str_site_id + ',' + str_officer_id + ',' + str_product_primary_id + ',' + str_year + ',' + str_month + ')" ><i class="fa fa-eye" aria-hidden="true"></i></button>';
                    var delete_button = '<button type="button" class="btn btn-danger" onclick="_delete(' + str_site_id + ',' + str_officer_id + ',' + str_product_primary_id + ',' + str_year + ',' + str_month + ')" ><i class="fa fa-trash" aria-hidden="true"></i></button>';

                    data.push({
                        "site": site,
                        "officer": officer,
                        "year": year,
                        "month": MONTH_NAME_EN[month],
                        "item": item,
                        "edit": edit_button,
                        "view": view_button,
                        "delete": delete_button,
                    });
                }

                var table = $('#tableOfficerPlanList').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}


function edit(site_id, officer_id, product_primary_id, year, month) {
    location.href = "/fo/plan_product_employee_daily?officer_id=" + officer_id + "&site=" + site_id + "&product_id=" + product_primary_id + "&year=" + year + "&month=" + month + "&action=edit";
}


function view(site_id, officer_id, product_primary_id, year, month) {
    location.href = "/fo/plan_product_employee_daily?officer_id=" + officer_id + "&site=" + site_id + "&product_id=" + product_primary_id + "&year=" + year + "&month=" + month + "&action=view";
}


function _delete(site_id, officer_id, product_primary_id, year, month) {
    $.ajax({
        type: 'DELETE',
        url: '/fo/PlanProductEmployeeDailyListController/delete/' + site_id + "/" + officer_id + "/" + product_primary_id + "/" + year + "/" + month,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Officer Plan has been deleted successfully...")
                getOfficerPlanList();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}