
var setting_array = {
    "officer": null,
    "supplier": null,
    "material": null
};

var REPORT_ID = 1;


$(document).ready(function () {
    fieldOfficers();
    suppliers();
    materials();
    showDate('DATE_RANGE');
    $('#selcOfficer').prop("disabled", true);
    $('#selcSupplier').prop("disabled", true);
    $('#selcMaterial').prop("disabled", true);

    $('#checkOfficerSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcOfficer').prop("disabled", false);
            setting_array.officer = $('#selcOfficer').val();
        } else {
            $('#selcOfficer').prop("disabled", true);
            setting_array.officer = null;
        }
        //switch_settings('checkSiteSearch');
    });
    $('#selcOfficer').on('change', function () {
        setting_array.officer = $(this).val();
    });


    $('#checkSupplierSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcSupplier').prop("disabled", false);
            setting_array.supplier = $('#selcSupplier').val();
        } else {
            $('#selcSupplier').prop("disabled", true);
            setting_array.supplier = null;
        }
        //switch_settings('checkSiteSearch');checkSupplierSearch
    });

    $('#selcSupplier').on('change', function () {
        setting_array.supplier = $(this).val();
    });



    $('#checkMaterialSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcMaterial').prop("disabled", false);
            setting_array.material = $('#selcMaterial').val();
        } else {
            $('#selcMaterial').prop("disabled", true);
            setting_array.material = null;
        }
        //switch_settings('checkSiteSearch');checkSupplierSearch
    });
    $('#selcMaterial').on('change', function () {
        setting_array.material = $(this).val();
    });




    $('input[name="startDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    $('input[name="startDate"]').on('apply.daterangepicker', function (ev, picker) {
        setDateRangeToDatePicker('endDate', picker.startDate.format('YYYY MM D'));

    });

    $('input[name="endDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    setDateRangeToDatePicker('endDate', $('input[name="startDate"]').val());


    $('#cmbReport').change(function () {
        REPORT_ID = $(this).val();
        if (REPORT_ID == 1) {
            showDate('DATE_RANGE');
        } else if (REPORT_ID == 2) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 3) {
            showDate('YEAR_MONTH');
        } else if (REPORT_ID == 4) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 5) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 6) {
            showDate('DATE_RANGE');
        } else if (REPORT_ID == 7) {
            showDate('DATE_RANGE');
        } else if (REPORT_ID == 8) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 11) {
            showDate('SINGLE_DATE');
            $('#lblEmployee').text('Supervisor');
        } else {
            showDate('DATE_RANGE');
        }
    });
});


function showDate(args) {

    if (args == 'YEAR_MONTH') {
        $('#divDate1').hide();
        $('#divDate2').show();
    } else {
        $('#divDate1').show();
        $('#divDate2').hide();
    }

    if (args == 'SINGLE_DATE') {
        $('#endDate').hide();
    } else {
        $('#endDate').show();
    }


}







function fieldOfficers() {
    $.ajax({
        type: 'GET',
        url: '/fo/PlanVsActualController/fieldOfficers',
        async: false,
        success: function (response) {
            console.log(response.data.result);
            $('#selcOfficer').empty();
            if (response.data.success) {

                var html = '';
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.employee_id + '">' + value.name_withinitial + '</option>';
                })
                $('#selcOfficer').html(html);
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}




function suppliers() {
    $.ajax({
        type: 'GET',
        url: '/fo/PlanVsActualController/suppliers',
        async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {

                var html = '';
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.supplier_id + '">' + value.supplier_name + '</option>';
                })
                $('#selcSupplier').html(html);
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}




function materials() {
    $.ajax({
        type: 'GET',
        url: '/fo/PlanVsActualController/materials',
        async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {

                var html = '';
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.product_primary_id + '">' + value.product_name + '</option>';
                })
                $('#selcMaterial').html(html);
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}




function settings() {

    return "officer=" + setting_array.officer + "&"
        + "supplier=" + setting_array.supplier + "&"
        + "material=" + setting_array.material;
}


function createReport(flag) {



    if (REPORT_ID == 0) {
        showWarningMessage("Please select Report");
        return;
    }


    if (REPORT_ID == 1) {


        $.ajax({
            type: "GET",
            url: "/fo/PlanVsActualController/visitPlanActualReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                showVisitPlanActualReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });

    }

}




function showVisitPlanActualReport(result, flag) {

    var Body = [];



    var Title = [
        {
            text: '\n',
            alignment: 'center'
        },
        {
            text: 'Riococo Lanka Pvt Ltd',
            alignment: 'center',
            fontSize: 12,
            bold: true,
        },

    ];



    var column1 = visitPlanBody(result.visit_plan);
    var column2 = visitActualBody(result.visit_actual);


    var Header = [
        {
            content: [
                {
                    text: 'Visit Plan Actual Report',
                    alignment: 'center'
                },
                {
                    text: '\n',
                    alignment: 'center'
                },
            ]
        }
    ]

    //for (i = 0; i < column1.length; i++) {
    var pageBreak = 'after';
    if (i == (column1.length) - 1) {
        pageBreak = '';
    }
    Body.push([
        {
            columns: [
                column1,
                column2,

            ]
        },


        { text: '', pageBreak: pageBreak },



    ]);
    //}

    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];




    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([5, 5, 5, 5]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function visitPlanBody(result) {


    console.log(result);

    var body = [
        [
            { text: 'Visit Plan', fontSize: 10, bold: true, alignment: 'center', border: [true, true, true, true], colSpan: 4 },
            { text: '', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: '', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: '', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] }
        ],
        [
            { text: 'Date', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Supplier Name', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Material', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Quantity (Ton)', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] }
        ],

    ];

    for (var i = 0; i < result.length; i++) {
        var qty = parseFloat(result[i].quantity).toFixed(2);
        if (isNaN(qty)) {
            qty = parseFloat(0).toFixed(2);
        }
        body.push(
            [
                { text: result[i].date, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: result[i].supplier_name, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: result[i].product_name, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: qty, fontSize: 8, bold: false, alignment: 'right', border: [true, true, true, true] }
            ],
        );
    }

    return [
        [{
            table: {
                widths: [50, 100, 100, 50],
                headerRows: 2,
                body: body,

            },
            margin: [0, 0],
        }],
    ];
}



function visitActualBody(result) {


    var body = [
        [
            { text: 'Actual Visit', fontSize: 10, bold: true, alignment: 'center', border: [true, true, true, true], colSpan: 2 },
            { text: '', fontSize: 9, bold: true, alignment: 'center', border: [true, true, true, true] },

        ],
        [
            { text: 'Date', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Supplier Name', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },

        ],
    ];

    for (var i = 0; i < result.length; i++) {
        body.push([
            { text: result[i].date, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
            { text: result[i].supplier_name, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },

        ],);
    }
    return [

        [{
            table: {
                widths: [50, 100],
                headerRows: 2,
                body: body,

            },
            margin: [5, 0],
        }],
    ];


}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}