@extends('fo::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">

<!-- <link rel="stylesheet" href="{{ url('assets/css/hr/planned.css') }}"> -->

<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<link href="{{ asset('assets/css/hr/settings.css') }}" media="all" rel="stylesheet" type="text/css" />

<link rel="stylesheet" href="{{ Module::asset('fo:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">
<meta name="csrf-token" content="{{ csrf_token() }}">
<script>
    var uid = "{{Auth::user()->user_id}}";
</script>
@endsection

@section('content')

<!-- <div class="page-header">
    <div>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div> -->

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Supply Collection</h6>
                <form method="POST" id="Employee_supply_plan_form">
                    {{csrf_field()}}
                    <div class="row">
                        <!--Left side -->
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                    <label for="txtSupplyDate">Date</label>
                                    <input type="text" class="form-control" id="txtSupplyDate" name="txtSupplyDate" required="" autocomplete="off">
                                    <div class="valid-feedback">
                                        Looks good!
                                    </div>

                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <i class="fa fa-user-o text-info" aria-hidden="true"></i>
                                    <label>Supplier</label>
                                    <input type="hidden" id="hidSupplierID" name="hidSupplierID" value="">
                                    <input type="hidden" id="hidSupCollectionId" name="hidSupCollectionId" value="">
                                    <input type="text" class="form-control auto-complete" id="txtSupplier3" name="txtSupplier3" placeholder="Supplier" required="" autocomplete="off">
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-12">
                                    <i class="fa fa-address-book-o text-info" aria-hidden="true"></i>
                                    <label>Address</label>
                                    <textarea class="form-control" id="txtEmployeeAddress" name="txtEmployeeAddress" placeholder="Address"></textarea>
                                </div>
                            </div>
                            <br> <br>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="table-responsive">
                                        <table id="supplyCollectionTbl" class="table table-bordered">
                                            <!-- PlannedTable -->
                                            <thead>
                                                <tr>
                                                    <th style="width:40%;">Material</th>
                                                    <th style="display:none;">product_id</th>
                                                    <th style="width:20%;">Planned (Tons)</th>
                                                    <th style="width:20%;">Expected (Tons)</th>
                                                    <th style="width:20%">To Be Collected(Tons)</th>
                                                    <th style="display:none;">Primary Id</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tbodyPlannedMaterials">

                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                </form>

                <br><br>






                <hr>

                <div class="row">
                    <div class="col-md-12">
                        <br>
                        <button type="button" class="btn btn-primary" id="btnEmployeeSupplyCollection" name="btnEmployeeSupplyCollection">Submit</button>
                    </div>
                </div>

            </div>



        </div>
    </div>
</div>
</div>
</div>



<div class="modal fade" id="attachmentAddModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="attachmentAddModalTitle">Add attachment here</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body" id="attachmentAddModalBody">
                <div class="row">
                    <div class="col-md-12">
                        <form action="{{route('upload')}}" class="dropzone" method="POST" id="myAwesomeDropzone" name="myAwesomeDropzone">
                            @csrf
                            <input type="hidden" id="employee_id" name="employee_id" value="">
                            <div class="fallback">
                                <input name="file" type="file" multiple />
                            </div>
                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                    </button>
                    <button type="button" class="btn btn-primary" id="btnSetting" onclick="save()">Save</button>
                </div>
            </div>
        </div>
    </div>
    </script>
    <!-- autocomplete  -->
    <script src="{{ Module::asset('fo:js/autocomplete2/js/autocomplete.min.js') }}"></script>


    <!-- jquery ui library  -->
    <script src="{{ url('assets/js/ui/jquery-ui.min.js') }}"></script>

    <script>
        //$(document).ready(function() {

        var supplier_datas2 = LoadSuppliers3();
        console.log(supplier_datas2);


        $('#txtSupplier3').setData(supplier_datas2);


        function autoCompleteSelectedOption(input, data) {

            if (input.id == "txtSupplier3") {
                var id = data.id;
                console.log(id);
                $('#hidSupplierID').val(id);
                GetSupplierAddressToPlanned(id);
            }
        }




        function LoadSuppliers3() {
            var supplier_data = [];
            $.ajax({
                type: 'GET',
                url: '/fo/EmployeeSupplyCollection/getSupplier',
                success: function(response) {

                    response.data.result.forEach(function(element) {
                        supplier_data.push({
                            "img": "",
                            "id": element['supplier_id'],
                            "value": element['supplier_name']
                        });
                    });

                    // var supplier_data = response.data.result.map((array) => ({ img: array.address, id: array.supplier_id, value: array.supplier_name }));
                    // var supplier_data = response.data.result.map(function (array) { return {img: array.address, id: array.supplier_id, value: array.supplier_name}; });

                },
                error: function(data) {
                    console.log('something went wrong!');
                }
            });
            return supplier_data;
        }
        // });
    </script>
    @endsection

    <!-- Javascript -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    @section('script')
    <!-- DataTable -->
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ url('assets/js/examples/datatable.js') }}"></script>

    <!-- Javascript -->
    <script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
    <!-- <script src="{{ url('assets/js/hr/planned_material.js') }}"></script> -->

    <!-- unique JS file for this view  -->
    <!-- <script src="{{ url('assets/js/hr/employee_supply_collection.js') }}"></script> -->
    <script src="{{ Module::asset('fo:js/fo/supply_collection.js') }}"></script>


    @endsection