@extends('fo::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<!-- Datepicker -->
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('assets/css/hr/employeeList.css') }}" type="text/css">

<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('fo:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">
<script>
    var edit_permission = "{{ Auth::user()->can('fo_collection_create_edit')}} ";
    var uid = "{{Auth::user()->user_id}}";
</script>

@endsection

@section('content')

<!-- <div class="page-header">
    <div>
        <h3>Form Page</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div> -->

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Employee Supply Collection List</h6>
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <div class="row">
                            <div class="col-md-12 mb-2">
                                <i class="fa fa-search text-info" aria-hidden="true"></i>
                                <label>Field Officer ID</label>
                                <input type="text" class="form-control auto-complete" id="txtFieldOfficerID" autocomplete="off">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 mb-2">
                                <i class="fa fa-search text-info" aria-hidden="true"></i>
                                <label>Field Officer Name</label>
                                <input type="text" class="form-control auto-complete" id="txtFieldOfficerName" autocomplete="off">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 mb-2">
                                <i class="fa fa-search text-info" aria-hidden="true"></i>
                                <label>Date Range</label>
                                <input type="text" name="daterangepicker" id="txtDate" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2 mb-3">
                        <br>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="imgContainer">
                                    <img class="img img-thumbnail" src="/images/employee.jpg" id="imgEmployee" alt="image/">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-12 mb-3">
                        <table id="myTable" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                            <thead>
                                <tr>
                                    <!-- <th class="id" style="display:none;">Supplier ID</th> -->
                                    <th>Supplier Name</th>
                                    <th>Date</th>
                                    <th class="edit">Edit</th>
                                </tr>
                            </thead>
                            <tbody id="tPlanListBody">
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('assets/js/examples/datatable.js') }}"></script>
<!-- Datepicker -->
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<script src="{{ url('assets/js/examples/datepicker.js') }}"></script>

<!-- AutoComplete -->
<script src="{{ Module::asset('fo:js/autocomplete2/js/autocomplete.min.js') }}"></script>

<!-- JS File  -->
<script src="{{ Module::asset('fo:js/fo/supply_collection_list.js') }}"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
@endsection