<?php

namespace Modules\Fo\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class PlanProductEmployee extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'fo_plan_product_employees';
    protected $primaryKey = 'plan_product_employee_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'plan_product_employee_id',
        'plan_product_id',
        'product_primary_id',
        'field_officer_id',
        'quantity',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "fo_plan_product_employees";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    
}
