<?php

namespace Modules\Fo\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class supplierMaterial extends Model
{
    protected $table = 'fo_supplier_materials';
    protected $primaryKey = 'supplier_materials_id';
    use HasFactory,LogsActivity;

    protected $fillable = [];
    protected static $logAttributes = [
        'supplier_materials_id',
        'supplier_id',
        'product_Id',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "fo_supplier_materials";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    
    /*protected static function newFactory()
    {        
        return \Modules\Fo\Database\factories\SupplierMaterialFactory::new();
    }*/
}
