<?php

namespace Modules\Fo\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class suppliers extends Model
{
    use HasFactory;

    protected $table = 'st_suppliers';
    protected $primaryKey = 'supplier_id';
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'supplier_id',
        'supplier_name',
        'address',
        'web_address',
        'country_id',
        'district_id',
        'town_id',
        'gmap',
        'supplier_type_id',
        'account_group_id',
        'tax1_no',
        'tax2_no',
        'alert_credit_limit',
        'alert_credit_period',
        'hold_credit_limit',
        'distance',
        'hold_credit_period',
        'status_id',
        'notes',
        'bank_id',
        'bank_branch_id',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "st_suppliers";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    // protected $fillable = [];

    // protected static function newFactory()
    // {
    //     // return \Modules\Fo\Database\factories\SuppliersFactory::new();
    // }
}
