<?php

namespace Modules\Fo\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Fo\Entities\fo_other_activities;

class OtherActivitiesController extends Controller
{
    function createOtherActivity(Request $request) {
        try{

            // $otheActivity = new fo_other_activities();
            // $otheActivity->supplier_id=$request->supplier_id;
            // $otheActivity->employee_id=$request->employee_id;
            // $otheActivity->Date=$request->Date;
            // $otheActivity->description=$request->description;
            // $save=$otheActivity->save();


             $save = DB::table('fo_other_activities')
                ->insert([
                    'employee_id' => $request->employee_id,
                    'supplier_id' => $request->supplier_id,
                    'Date' => $request->Date,
                    'description' => $request->description,
                    'type_id' => $request->type_id,

                ]);

            if($save) {
                $responseBody = $this->responseBody(true, "other_activities", "Success", $request->employee_id);
            }
            // $responseBody = $this->responseBody(true, "other_activities", "Success", $request->description);

        } catch(\Exception $exception) {
                $responseBody = $this->responseBody(false, "other_activities", "Error", $exception->getMessage());
        }
        return response()->json([ "data" => $responseBody ]);
    }
    function LoadOtherActivityByOfficer($id) {
        try{
            $result = DB::table('fo_other_activities')->where('employee_id', '=', $id)
                        ->join('st_suppliers', 'fo_other_activities.supplier_id', 'st_suppliers.supplier_id')->get();

            $responseBody = $this->responseBody(true, "other_activities By Employee", "Got", $result);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(true, "other_activities By Employee", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);
    }
    function GetOtherActivityDataToModal($id) {
        try{$result = DB::table('fo_other_activities')
            ->join('st_suppliers', 'fo_other_activities.supplier_id', '=', 'fo_other_activities.supplier_id')
            ->where('id', '=', $id)->get();

            $responseBody = $this->responseBody(true, "other_activities Data", "All", $result);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "other_activities Data", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);
    }
    function UpdateOtherActivity(Request $request, $id) {
        try{

            $save =DB::table('fo_other_activities')->where('id',$id)
            ->update([
                'employee_id'=>$request->employee_id,
                'Supplier_id'=>$request->supplier_id,
                'Date'=>$request->Date,
                'description'=> $request->description,
                'type_id' => $request->type_id,
            ]);
            if ($save) {
                $responseBody = $this->responseBody(true, "other_activities Updated", "Done", $request->employee_id);
            }


        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "other_activities Update", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);
    }
    function CreateOtherActivitySchedule($id) {
        try{
            $result = DB::table('fo_other_activities')->where('fo_other_activities.employee_id', '=', $id)
            ->join('st_suppliers', 'fo_other_activities.supplier_id', '=', 'st_suppliers.supplier_id')
            ->get();

            $responseBody = $this->responseBody(true, "other_activities By Employee To Calander", "Found", $result);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "other_activities By Employee To Calander", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);
    }
    function GetOtherActivitiesToModal(Request $request){
        try{
            $employee_id = $request->get('employee_id');
            $date = $request->get('date');

            $result = DB::table('fo_other_activities')
            ->where('employee_id', '=', $employee_id)
            ->where('Date', '=', $date)
            ->get();

            $responseBody = $this->responseBody(true, "other_activities  To Modal", "Got", $result);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "other_activities To Modal" , "Error" , $exception);
        }
        return response()->json([ "data" => $responseBody ]);

    }
    function responseBody($success, $name, $message, $result) {
        $body = [
            "success" => $success,
            "name" => $name,
            "message" => $message,
            "result" => $result
        ];
        return $body;
    }
}
