<?php

namespace Modules\Fo\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Fo\Entities\PlanProductEmployeeDaily;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeSite;
use Modules\St\Entities\Product;
use Modules\St\Entities\Suppliers;

class PlanProductEmployeeDailyController extends Controller
{

    function sites()
    {
        try {
            $Site = EmployeeSite::all();

            $responseBody = $this->responseBody(true, "PlanProductEmployeeDailyController", "sites", $Site);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanProductEmployeeDailyController", "sites", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    function mainRawMaterials($officer_id)
    {
        try {
            $materials = DB::select('SELECT st_products.* FROM st_products 
            INNER JOIN fo_plan_product_employees 
            ON st_products.product_primary_id = fo_plan_product_employees.product_primary_id 
            WHERE fo_plan_product_employees.field_officer_id = "' . $officer_id . '"');
            $responseBody = $this->responseBody(true, "PlanProductEmployeeDailyController", "mainRawMaterials", $materials);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanProductEmployeeDailyController", "mainRawMaterials", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    function fieldOfficers()
    {
        try {
            $fieldOfficers = Employee::where([['employeestatus_id', '!=', '4'], ['employeestatus_id', '!=', '5'], ['designation_id', '=', '30']])->get();
            $responseBody = $this->responseBody(true, "PlanProductEmployeeDailyController", "fieldOfficers", $fieldOfficers);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanProductEmployeeDailyController", "fieldOfficers", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }


    function suppliers()
    {
        try {
            $fieldOfficers = Suppliers::all();
            $responseBody = $this->responseBody(true, "PlanProductEmployeeDailyController", "suppliers", $fieldOfficers);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanProductEmployeeDailyController", "suppliers", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }




    function getOfficerQuantity($officer_id, $item_id, $year, $month)
    {
        try {
            $qty = 0;
            $result = DB::select('SELECT SUM(fo_plan_product_employees.quantity) AS quantity FROM fo_plan_product_employees 
            INNER JOIN fo_plan_products ON fo_plan_product_employees.plan_product_id = fo_plan_products.plan_product_id
            WHERE fo_plan_product_employees.field_officer_id = "' . $officer_id . '" AND fo_plan_product_employees.product_primary_id = "' . $item_id . '" AND fo_plan_products.`year` = "' . $year . '" AND fo_plan_products.`month` = "' . $month . '"');
            foreach ($result as $res) {
                $qty = $res->quantity;
            }
            $responseBody = $this->responseBody(true, "PlanProductEmployeeDailyController", "getOfficerQuantity", $qty);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanProductEmployeeDailyController", "getOfficerQuantity", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    function save(Request $request)
    {
        try {
            $data = $request->get("data");
            for ($i = 0; $i < count($data); $i++) {
                $dd = json_decode($data[$i]);
                $site_id = $dd->site_id;
                $field_officer_id = $dd->field_officer_id;
                $item_id =  $dd->item_id;
                $supplier_id =  $dd->supplier_id;
                $date =  $dd->date;
                PlanProductEmployeeDaily::where([['site_id', '=', $site_id], ['field_officer_id', '=', $field_officer_id], ['product_primary_id', '=', $item_id], ['date', '=', $date]])->delete();
            }
            for ($i = 0; $i < count($data); $i++) {
                $dd = json_decode($data[$i]);
                $site_id = $dd->site_id;
                $field_officer_id = $dd->field_officer_id;
                $item_id =  $dd->item_id;
                $supplier_id =  $dd->supplier_id;
                $date =  $dd->date;
                $quantity =  $dd->quantity;



                if ($dd->supplier_id != "null") {
                    $planDaily = new PlanProductEmployeeDaily();
                    $planDaily->site_id = $site_id;
                    $planDaily->field_officer_id = $field_officer_id;
                    $planDaily->product_primary_id = $item_id;
                    $planDaily->supplier_id = $supplier_id;
                    $planDaily->date = $date;
                    $planDaily->quantity = $quantity;
                    $planDaily->save();
                }
            }
            $responseBody = $this->responseBody(true, "PlanProductEmployeeDailyController", "save", true);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanProductEmployeeDailyController", "save", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function allSuppliers()
    {
        try {
            $products =  Suppliers::select('supplier_id As id', 'supplier_name As value0')->get();
            return $this->responseBody(true, "PlanProductEmployeeDailyController", "allSuppliers", $products);
        } catch (\Exception $exception) {
            return $this->responseBody(false, "PlanProductEmployeeDailyController", "error", $exception);
        }
    }


    public function loadDailyPlan($site_id, $year, $month, $field_officer_id, $item_id)
    {
        try {
            $query = 'SELECT fo_plan_product_employee_dailies.plan_product_employee_dailie_id,st_suppliers.supplier_name,st_suppliers.supplier_id,fo_plan_product_employee_dailies.date,fo_plan_product_employee_dailies.quantity FROM fo_plan_product_employee_dailies
            INNER JOIN st_suppliers ON fo_plan_product_employee_dailies.supplier_id = st_suppliers.supplier_id  WHERE fo_plan_product_employee_dailies.site_id = "' . $site_id . '"
            AND fo_plan_product_employee_dailies.field_officer_id = "' . $field_officer_id . '" AND fo_plan_product_employee_dailies.product_primary_id = "' . $item_id . '"
            AND YEAR(fo_plan_product_employee_dailies.date) = "' . $year . '" AND MONTH(fo_plan_product_employee_dailies.date) = "' . $month . '"';
            $plan = DB::select($query);
            $responseBody = $this->responseBody(true, "PlanProductEmployeeController", "saveFieldOfficerQuantity", $plan);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanProductEmployeeController", "saveFieldOfficerQuantity", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
