<?php

namespace Modules\Fo\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Fo\Entities\SupplierVisit;
use Illuminate\Support\Facades\DB;
use app\Models\fo_supplier_visit;
use Exception;

class SupplierVisitController extends Controller
{
    function CreateSupplierVisit(Request $request) {
        try{
            // $supplierVisit = new fo_supplier_visit;

            // $supplierVisit->employee_id = $request->employee_id;
            // $supplierVisit->supplier_id = $request->supplier_id;
            // $supplierVisit->arrival = $request->arrived_on;
            // $supplierVisit->depature = "Not Updated Yet";
            // $supplierVisit->latitude = $request->latitude;
            // $supplierVisit->longitude = $request->longitude;

            // $save =  $supplierVisit->save();
            $save=DB::table('fo_supplier_visit')
                ->insert([
                    'employee_id' => $request->employee_id,
                    'supplier_id' => $request->supplier_id,
                    'arrival' => $request->arrived_on,
                    'depature' => "Not Updated Yet",
                    'latitude' => $request->latitude,
                    'longitude' => $request->longitude]);

            if($save) {
                $responseBody = $this->responseBody(true, "Supplier Visit", "Success", $request->employee_id);
            }
        } catch(\Exception $exception) {
                $responseBody = $this->responseBody(false, "Supplier Visit", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);
    }

    function GetSupplierVist() {
        try{

            // $query = "SELECT f.*, s.* 
            //         FROM fo_supplier_visit f
            //         INNER JOIN st_suppliers s ON f.supplier_id = s.supplier_id
            //         WHERE s.supplier_type_id = 1";
            // $result = DB::select($query);

            $result = DB::table('fo_supplier_visit')
                        ->join('st_suppliers', 'fo_supplier_visit.supplier_id', '=', 'st_suppliers.supplier_id')
                        ->get();

            $responseBody = $this->responseBody(true, "Supplier Visit", "All", $result);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "Supplier Visit", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);
    }

    function GetSupplierVisitDataToModal($id) {
        try{$result = DB::table('fo_supplier_visit')
            ->join('st_suppliers', 'fo_supplier_visit.supplier_id', '=', 'st_suppliers.supplier_id')
            ->where('supplier_visit_id', '=', $id)->get();

            $responseBody = $this->responseBody(true, "Supllier Visit Data", "All", $result);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "Supplier Visit Data", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);
    }

    function UpdateSupplierVisit(Request $request, $id) {
        try{
            $supplierVisit = SupplierVisit::find($id);

            $supplierVisit->employee_id = $request->employee_id;
            $supplierVisit->Supplier_id = $request->supplier_id;
            $supplierVisit->arrival = $request->arrived_on;
            $supplierVisit->depature = $request->depature_on;
            $supplierVisit->observation = $request->observation;

            $save = $supplierVisit->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Supplier Visit Updated", "Done", $request->employee_id);
            }

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "Supplier Visit Update", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);
    }

    function GetSupplierByOfficer($id) {
        try{$result = DB::table('fo_employee_supplier')->where('employee_id', '=', $id)
            ->join('st_suppliers', 'fo_employee_supplier.supplier_id', '=', 'st_suppliers.supplier_id')->get();

            $responseBody = $this->responseBody(true, "Supplier By Employee", "Found", $result);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "Supplier By Employee", "error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);
    }

    function GetSupplierVisitByEmployee($id) {
        try{$result = DB::table('fo_supplier_visit')->where('employee_id', '=', $id)
                        ->join('st_suppliers', 'fo_supplier_visit.supplier_id', 'st_suppliers.supplier_id')->get();

            $responseBody = $this->responseBody(true, "supplier Visit By Employee", "Got", $result);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(true, "Supplier Visit By Employee", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);
    }

    function GetSupplierVisitByEmployeeToCalander($id) {
        try{
            // $result = DB::table('fo_supplier_visit')->where('employee_id', '=', $id)
            // ->join('st_suppliers', 'fo_supplier_visit.supplier_id', '=', 'st_suppliers.supplier_id')
            // ->groupBy('st_suppliers.supplier_id')->get();
            $result = DB::table('fo_supplier_visit')->where('fo_supplier_visit.employee_id', '=', $id)
            ->join('st_suppliers', 'fo_supplier_visit.supplier_id', '=', 'st_suppliers.supplier_id')
            ->get();

            $responseBody = $this->responseBody(true, "Supplier Visit By Employee To Calander", "Found", $result);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "Supplier Visit By Employee To Calander", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);
    }
    //function by nipuna start
    function GetSupplierVisitByDate(Request $request){
        try{

            $result = DB::table('fo_supplier_visit')
                        ->whereBetween('fo_supplier_visit.arrival', [$request->St_date, $request->End_date])
                        ->join('st_suppliers', 'fo_supplier_visit.supplier_id', 'st_suppliers.supplier_id')
                        ->get();

            $responseBody = $this->responseBody(true, "Supplier Visit By Date", "Found", $result);

        } catch(Exception $exception) {
            $responseBody = $this->responseBody(false, "Supplier Visit By Date", "Error", $exception->getMessage());
        }
        return response()->json([ "data" => $responseBody ]);
    }
    function GetSupplierVisitByDateToOfficer(Request $request , $id){
        try{

            $result = DB::table('fo_supplier_visit')
                        ->whereBetween('fo_supplier_visit.arrival', [$request->St_date, $request->End_date])
                        ->where('fo_supplier_visit.employee_id', $id)
                        ->join('st_suppliers', 'fo_supplier_visit.supplier_id', 'st_suppliers.supplier_id')
                        ->get();

            $responseBody = $this->responseBody(true, "Supplier Visit By Date", "Found", $result);

        } catch(Exception $exception) {
            $responseBody = $this->responseBody(false, "Supplier Visit By Date", "Error", $exception->getMessage());
        }
        return response()->json([ "data" => $responseBody ]);
    }
    //function by nipuna end


    function GetSupplierVisitToModal(Request $request){
        try{
            $employee_id = $request->get('employee_id');
            $date = $request->get('date');

            $result = DB::table('fo_supplier_visit')
            ->where('employee_id', '=', $employee_id)->get();

            $responseBody = $this->responseBody(true, "Supplier Visit To Modal", "Got", $result);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "Supplier Visit To Modal" , "Error" , $exception);
        }
        return response()->json([ "data" => $responseBody ]);

    }

    function responseBody($success, $name, $message, $result) {
        $body = [
            "success" => $success,
            "name" => $name,
            "message" => $message,
            "result" => $result
        ];
        return $body;
    }
}
