<?php

namespace Modules\Fo\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;

class VisitPlanCalanderController extends Controller
{
    function loadVisitPlanToCalander($filed_officer_id, $start_date, $end_date)
    {
        try {
            $query = 'SELECT fo_supplier_visit_plans.supplier_visit_plan_id,
            st_suppliers.supplier_id,
            st_suppliers.supplier_name,
            st_supplier_contacts.mobile,
            fo_supplier_visit_plans.year,
            fo_supplier_visit_plans.month,
            fo_supplier_visit_plans.visit_date,
            fo_supplier_visit_plans.visit_detail FROM fo_supplier_visit_plans
            INNER JOIN st_suppliers ON fo_supplier_visit_plans.supplier_id = st_suppliers.supplier_id
            LEFT JOIN st_supplier_contacts ON st_suppliers.supplier_id = st_supplier_contacts.supplier_foriegn_id
            WHERE fo_supplier_visit_plans.employee_id = "' . $filed_officer_id . '" AND fo_supplier_visit_plans.visit_date BETWEEN "' . $start_date . '" AND "' . $end_date . '"';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "VisitPlanCalanderController", "loadVisitPlanToCalander", $result);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "VisitPlanCalanderController", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
