<?php

namespace Modules\Fo\Http\Controllers;

use App\Models\employees;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;

class VisitPlanController extends Controller
{
    function allFieldOfficerID()
    {
        try {
            $field_officers = employees::where('designation_id', 30)->get();

            $field_officers_array = [];
            for ($i = 0; $i < count($field_officers); $i++) {
                array_push($field_officers_array, ["img" => $field_officers[$i]['photo_parth'], "id" => $field_officers[$i]['employee_id'], "value" =>  $field_officers[$i]['employee_id']]);
            }
            $responseBody = $this->responseBody(true, "VisitPlanController", "allFieldOfficerID", $field_officers_array);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "VisitPlanController", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    function allFieldOfficerName()
    {
        try {
            $field_officers = employees::where('designation_id', 30)->get();

            $field_officers_array = [];
            for ($i = 0; $i < count($field_officers); $i++) {
                array_push($field_officers_array, ["img" => $field_officers[$i]['photo_parth'], "id" => $field_officers[$i]['employee_id'], "value" => $field_officers[$i]['name_withinitial']]);
            }
            $responseBody = $this->responseBody(true, "VisitPlanController", "allFieldOfficerName", $field_officers_array);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "VisitPlanController", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    function getSelectedFieldOfficerName($id)
    {
        try {
            $name = "";
            $officer = employees::where('employee_id', '=', $id)->first();
            if ($officer) {
                $name = $officer->name_withinitial;
            }
            $responseBody = $this->responseBody(true, "VisitPlanController", "getSelectedFieldOfficerName", $name);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "VisitPlanController", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function loadPlan($field_officer_id, $start_date, $end_date)
    {
        try {
            $query = 'SELECT fo_supplier_visit_plans.supplier_visit_plan_id,
            st_suppliers.supplier_id,
            st_suppliers.supplier_name,
            st_supplier_contacts.mobile,
            fo_supplier_visit_plans.visit_date,
            fo_supplier_visit_plans.visit_detail FROM fo_supplier_visit_plans
            INNER JOIN st_suppliers ON fo_supplier_visit_plans.supplier_id = st_suppliers.supplier_id
            LEFT JOIN st_supplier_contacts ON st_suppliers.supplier_id = st_supplier_contacts.supplier_foriegn_id
            WHERE fo_supplier_visit_plans.employee_id = "' . $field_officer_id . '" AND fo_supplier_visit_plans.visit_date BETWEEN "' . $start_date . '" AND "' . $end_date . '"';
            $plan = DB::select($query);
            $responseBody = $this->responseBody(true, "PlanProductEmployeeController", "saveFieldOfficerQuantity", $plan);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanProductEmployeeController", "saveFieldOfficerQuantity", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
