/**Sampath perera DataChooser */
$(document).ready(function () {
    (function ($) {
        $.fn.dataChooser = function (property) {
            this.ID = this[0].id;
            this.columns = property.columns;
            this.columns.push({ 'data': 'Select' })
            this.columnDefs = property.columnDefs;
            this.chooser = dataChooser(this);
            this.data = [];
            this.input = undefined;
            this.showChooser = function (input) {
                this.input = input;
                this.chooser.modal('toggle');
                $("input[type=search]").val(input.val());
            };
            this.setDataSource = function (data) {
                var id = "'" + this.ID + "'";
                var chooser_obj = "'" + this.chooser + "'";
                for (var i = 0; i < data.length; i++) {
                    data[i].Select = '<button id="btnSelect_' + this.ID + '_' + i + '"  class="btn btn-primary btnChooserSelect_' + this.ID + '" onclick="selectedItem(event,' + id + ')">select</button>';
                }

                var table = $('#' + this.ID + '-table').DataTable();
                table.clear();
                table.rows.add(data).draw();

                var input = document.getElementsByClassName('btnChooserSelect_' + this.ID);

                // Execute a function when the user presses a key on the keyboard
                /*for (var i = 0; i < input.length; i++) {
                    console.log(input[i]);
                    input[i].addEventListener("click", selectOnClick);
                    input[i].data_row = $('#' + this.ID + '-table').closest("tr");
                    input[i].data = this.data;
                    input[i].modal = this.chooser;
                    input[i].ID = this.ID;
                }*/

            }
            this.getInput = function () {
                return this.input;
            };

            return this;
        };
    })(jQuery);

    $(window).on('shown.bs.modal', function () {
        $("input[type=search]").focus();
    });

});



function dataChooser(obj) {

    var modal = '<div class="modal fade" id="' + obj.ID + '_modal" tabindex="-1" role="dialog" aria-hidden="true">';
    modal += '<div class="modal-dialog modal-dialog-centered modal-lg" role="document">';
    modal += '<div class="modal-content">';
    modal += '<div class="modal-body" id="' + obj.ID + '_modalBody"></div></div></div></div>';
    obj.append(modal);

    var table = '<table id="' + obj.ID + '-table"  class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid"><thead><tr id="' + obj.ID + '_trHead"></tr></thead></table>';

    $('#' + obj.ID + '_modalBody').append(table);
    for (var i = 0; i < obj.columns.length; i++) {
        $('#' + obj.ID + '_trHead').append('<th>' + obj.columns[i].data + '</th>');
    }


    $('#' + obj.ID + '-table').DataTable({
        "scrollX": true,
        "order": [],
        "columns": obj.columns,
        columnDefs: obj.columnDefs,
        "pageLength": 5,

    });
    return $('#' + obj.ID + '_modal');
}


//function selectOnClick(event) {}



function selectedItem(event, id) {
    var data = [];
    var row = event.currentTarget.closest('tr');
    var cells = row.getElementsByTagName('td');
    for (var ic = 0, it = cells.length; ic < it; ic++) {
        data.push(cells[ic].innerHTML);
    }
    var object = $('#' + event.currentTarget.id);
    object.trigger('select', [data]);
    $('#' + id + '_modal').modal('hide');
}











