var events = [];

$(document).ready(function () {
    $('#calendar-demo').fullCalendar({
        header: {
            left: 'prev,next today',
            center: 'title',
            right: 'month,agendaWeek,agendaDay,listMonth'
        },
        editable: true,
        droppable: true,
        drop: function () {
            $(this).remove();

        },
        weekNumbers: true,
        eventLimit: false, // allow "more" link when too many events
        dayClick: function () {
            $('#createEventModal').modal();

        },
        eventClick: function (event, jsEvent, view) {
            var employee_id = event.description.employee_id;
            var date = event.description.date;
            var arrival = event.description.arrival;
            // alert(employee_id);
            // alert(date);
            $.ajax({
                type: 'POST',
                url: '/fo/SupplierVist/GetSupplierVisitToModal',
                headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                },
                data: {
                    "employee_id" : employee_id,
                    "date" : date,
                    // "arrival" : arrival,
                },
                success: function(response) {
                    console.log(response);

                    if(response.data.success) {
                        var html = '';
                        html += '<table class="table table-striped">';
                        html += '<thead>';
                        html += '<tr>';
                        html += '<th>Arrived At</th> <th>Depatured At</th>';
                        html += '</tr>';
                        html += '</thead>';
                        $.each(response.data.result, function(index, value) {
                            html += '<tbody>';
                            html += '<tr>';
                            html += '<td>' +value.arrival+ '</td>';
                            html += '<td>' +value.depature+ '</td>';
                            html += '</tr>';
                            html += '</tbody>';
                        })
                        html += '</table>';
                        modal.find('.event-body').html(html);
                    }

                }, error: function(data) {
                    console.log('Something went wrong!');
                }
            })
            var modal = $('#viewEventModal');
            modal.find('.event-icon').html("<i class='fa fa-" + event.icon + "'></i>");
            modal.find('.event-title').html(event.title);
            modal.modal();
        },
    });
});




function addShedule(shift_id, supplier_name, date, date, employee_id, arrival) {
    // var R = (parseInt(shift_id) *  215);
    // if (R > 255) R = (R - 255);
    // var G = (parseInt(shift_id) * 100);
    // if (G > 255) R = (G - 255);
    // var B = (parseInt(shift_id) * 50);
    // if (B > 255) R = (B - 255);
    //comented by nipuna

    //by nipuna start
    var R = (parseInt(shift_id) * 215);
    while(R>255) {R=R-100}
    var G = (parseInt(shift_id) * 100);
    while(G>255) {G=G-50}
    var B = (parseInt(shift_id) * 50);
    while(B>255) {B=B-50}


    console.log(shift_id)
    console.log(" R-"+R+" G-"+G+" B-"+B);


    // var R=2;
    // var G=4;
    // var B=6;

    //by nipuna end
    events.push({
        title: supplier_name,
        start: date,
        end: date,
        backgroundColor: 'rgb(' + R + ',' + G + ',' + B + ')',
        icon: "building-o",
        description: {"employee_id": employee_id , "date": date, "arrival": arrival},
    });

}


function clearCalander() {
    // alert();
    $('#calendar-demo').fullCalendar('removeEvents');
    events = [];
}


function createCalendar() {
    $('#calendar-demo').fullCalendar('removeEvents');
    $('#calendar-demo').fullCalendar('addEventSource', events);

}
