console.log('producttion_plan_calender.js')

var events = [];

$(document).ready(function () {
    $('#calendar-demo').fullCalendar({
        header: {
            left: 'prev,next today',
            center: 'title',
            right: 'month,agendaWeek,agendaDay,listMonth'
        },
        editable: true,
        droppable: true,
        drop: function () {
            $(this).remove();

        },
        weekNumbers: true,
        eventLimit: false, // allow "more" link when too many events
        dayClick: function () {
            $('#createEventModal').modal();

        },
        eventClick: function (event, jsEvent, view) {

            var supplier = event.description.supplier;
            var visit_date = event.description.date;
            var year = event.description.year;
            var month = event.description.month;

            var html = '';
            html += '<table class="table table-striped">';
            html += '<thead>';
            html += '<tr>';
            html += '<th>Supplier</th><th>Visit Date</th> <th>Year</th><th>Month</th>';
            html += '</tr>';
            html += '</thead>';
            html += '<tbody>';
            html += '<tr>';
            html += '<td>' + supplier + '</td>';
            html += '<td>' + visit_date + '</td>';
            html += '<td>' + year + '</td>';
            html += '<td>' + month + '</td>';
            html += '</tr>';
            html += '</tbody>';
            html += '</table>';

            var modal = $('#viewEventModal');
            modal.find('.event-body').html(html);
            modal.find('.event-icon').html("<i class='fa fa-" + event.icon + "'></i>");
            modal.find('.event-title').html(event.title);
            modal.modal();
        },
    });

    loadVisitCalanderPlan();

});

function loadVisitCalanderPlan() {

    clearCalander();

    var officer_id = $('#auto-comp1').optionID();
    var startDate = $('#dashboard-daterangepicker').data('daterangepicker').startDate.format('YYYY-MM-DD');
    var endDate = $('#dashboard-daterangepicker').data('daterangepicker').endDate.format('YYYY-MM-DD');

    $.ajax({
        type: 'GET',
        url: '/fo/VisitPlanCalanderController/loadVisitPlanToCalander/' + officer_id + "/" + startDate + "/" + endDate,
        success: function (response) {
            if (response.data.success) {
                console.log(response);

                for (i = 0; i < response.data.result.length; i++) {
                    var year = response.data.result[i]['year'];
                    var month = response.data.result[i]['month'];
                    var supplier = response.data.result[i]['supplier_name'];
                    var newend_date = response.data.result[i]['visit_date'];
                    var newstart_date = response.data.result[i]['visit_date'];

                    // console.log(newDate);
                    addShedule(newstart_date, newend_date, supplier, year, month);
                }
                createCalendar();
            }

        }, error: function (data) {
            console.log('Something went wrong!');
        }
    })
}



function addShedule(newstart_date, newend_date, supplier, year, month) {




    var R = (parseInt(123) * 215);
    while (R > 255) { R = R - 100 }
    var G = (parseInt(123) * 100);
    while (G > 255) { G = G - 50 }
    var B = (parseInt(123) * 50);
    while (B > 255) { B = B - 50 }



    events.push({
        title: supplier,
        start: newstart_date,
        end: newend_date,
        backgroundColor: 'rgb(2, 117, 216)',
        icon: "building-o",
        description: { "date": newstart_date, "supplier": supplier, "year": year, "month": month },
    });

}


function clearCalander() {
    // alert();
    $('#calendar-demo').fullCalendar('removeEvents');
    events = [];
}


function createCalendar() {
    $('#calendar-demo').fullCalendar('removeEvents');
    $('#calendar-demo').fullCalendar('addEventSource', events);

}
