@extends('fo::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<!-- Fullcalendar -->
<link rel="stylesheet" href="{{ url('vendors/fullcalendar/fullcalendar.min.css') }}" type="text/css">
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/clockpicker/bootstrap-clockpicker.min.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('fo:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">

<meta name="csrf-token" content="{{ csrf_token() }}">


@endsection

@section('content')

<!-- <div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div> -->


<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Field Operation Visit Plan</h6>
                <div class="row">
                    <div class="col-md-7">
                        <div class="row">
                            <div class="col-md-5 mb-3">
                                <i class="fa fa-search text-info" aria-hidden="true"></i>
                                <label>Field Officer ID</label>
                                <input type="hidden" value="1" id="employee_id" name="employee_id">
                                <input type="text" class="form-control auto-complete" id="auto-comp1" autocomplete="off">
                            </div>
                            <div class="col-md-7 mb-3">
                                <i class="fa fa-search text-info" aria-hidden="true"></i>
                                <label>Field Officer</label>
                                <input type="text" class="form-control auto-complete" id="auto-comp2" autocomplete="off">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-5 mb-3">
                                <div id="dashboard-daterangepicker" class="btn btn-outline-light">
                                    <span>Jan, 05, 2021</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="imgContainer">
                                    <img class="img img-thumbnail" src="/images/employee.jpg" id="imgEmployee" alt="image/">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <ul class="nav nav-pills mb-3" role="tablist" id="navMenuItem">
                            <li class="nav-item">
                                <a class="nav-link active" id="pills-general-tab" data-toggle="pill" href="#tbGeneral" role="tab" aria-controls="pills-general" aria-selected="true">Schedule List</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="pills-contact-tab" data-toggle="pill" href="#tbContactInfo" role="tab" aria-controls="pills-contact" aria-selected="false">Calander</a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="tbGeneral" role="tabpanel" aria-labelledby="pills-general-tab">
                                <div class="row">
                                    <div class="col-md-12 seperator">
                                        <div class="card bg-primary">
                                            <div class="card-header">Schedule List</div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12">
                                        <table id="tblEmployeeSchedule" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                                            <thead>
                                                <tr>
                                                    <th class="id">Supplier ID</th>
                                                    <th>Supplier Name</th>
                                                    <th>Telephone Number</th>
                                                    <th>Visit Date</th>
                                                    <th>Visit Detail</th>
                                                    <!--<th>Action</th>!-->
                                                </tr>
                                            </thead>
                                            <tbody id="tbody"></tbody>
                                        </table>
                                    </div>
                                </div>



                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <hr>
                                    </div>
                                </div>




                                <!-- <div class="row">
                                    <div class="col-md-12 seperator">
                                        <div class="card bg-primary">
                                            <div class="card-header">Employee List</div>
                                        </div>
                                    </div>
                                </div> -->


                                <!-- <div class="row">
                                    <div class="col-md-12">
                                        <table id="tblEmployeeSupervisor" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                                            <thead>
                                                <tr>
                                                    <th class="id">Employee ID</th>
                                                    <th>Name</th>
                                                    <th>Category</th>
                                                    <th>Site</th>
                                                    <th>Department</th>
                                                    <th>Section</th>
                                                    <th>Subsection</th>
                                                    <th>Set</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tbody"></tbody>
                                        </table>
                                    </div>
                                </div> -->
                            </div>
                            <div class="tab-pane fade" id="tbContactInfo" role="tabpanel" aria-labelledby="pills-contact-tab">
                                <div class="card ">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-12 app-content">
                                                <div class="row">
                                                    <div class="col-md-12 seperator">
                                                        <div class="card bg-primary">
                                                            <div class="card-header">Calander</div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="app-content-overlay"></div>
                                                <div class="card app-content-body">
                                                    <div class="card-body">
                                                        <!--<a href="#" class="app-sidebar-menu-button btn btn-outline-light mb-3">
                                                            <i data-feather="menu"></i>
                                                        </a>!-->
                                                        <!-- <div class="row">
                                                            <div class="col-md-12" style="text-align: right;">
                                                                <div id="dashboard-daterangepicker" class="btn btn-outline-light">
                                                                    <span>Jan, 05, 2021</span>
                                                                </div>
                                                            </div>
                                                        </div> -->
                                                        <br>
                                                        <div id="calendar-demo"></div>
                                                    </div>
                                                </div>
                                            </div>



                                            <!-- begin::Event Info Modal -->
                                            <div class="modal fade" id="viewEventModal" tabindex="-1" role="dialog" aria-hidden="true">
                                                <div class="modal-dialog modal-lg" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">
                                                                <span class="event-icon mr-2"></span>
                                                                <span class="event-title">Modal Title</span>
                                                            </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <i class="ti-close"></i>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="event-body"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end::Event Info Modal -->
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>







    <div class="modal fade" id="scheduleAddModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="scheduleAddModalTitle">Add Schedule</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <form method="POST" id="frmSchedule">
                    {{csrf_field()}}
                    <input type="hidden" id="scheduleID" name="scheduleID" value>
                    <div class="modal-body" id="scheduleAddModalBody">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Shift</label>
                                        <select class="form-control" id="cmbShift" name="shift" onchange=""></select>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <i class="fa fa-clock-o text-info" aria-hidden="true"></i>
                                        <label>In time</label>
                                        <div class="input-group clockpicker-example">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">
                                                    <i class="fa fa-clock-o"></i>
                                                </span>
                                            </div>
                                            <input type="text" class="form-control" value="18:30" id="txtIntime" name="intime">
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <i class="fa fa-clock-o text-info" aria-hidden="true"></i>
                                        <label>Out time</label>
                                        <div class="input-group clockpicker-example">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">
                                                    <i class="fa fa-clock-o"></i>
                                                </span>
                                            </div>
                                            <input type="text" class="form-control" value="18:30" id="txtOuttime" name="outtime">
                                        </div>
                                    </div>

                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                        <label>Schedule From</label>
                                        <input type="text" class="form-control" name="date" id="txtFromDate" placeholder="YYYY-MM-DD">
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                        <label>Schedule To</label>
                                        <input type="text" class="form-control" name="date" id="txtToDate" placeholder="YYYY-MM-DD">
                                    </div>

                                </div>

                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                        <label>Remark</label>
                                        <input type="text" class="form-control" id="txtRemark" name="remark">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                        </button>
                        <button type="button" class="btn btn-primary" id="btnSetting">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</div>

@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')

<script src="{{ Module::asset('fo:js/autocomplete2/js/autocomplete.min.js') }}"></script>

<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('vendors/clockpicker/bootstrap-clockpicker.min.js') }}"></script>
<!-- AutoComplete -->
{{-- <script src="{{ url('assets/js/fo/autocomplete.min.js') }}"></script> --}}

<!-- Fullcalendar -->
<script src="{{ url('vendors/fullcalendar/moment.min.js') }}"></script>
<script src="{{ url('vendors/fullcalendar/fullcalendar.min.js') }}"></script>


<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>



<!-- <script src="{{ url('assets/js/fo_visit_plan/calander.js') }}"></script> -->
<!-- <script src="{{ url('assets/js/fo_visit_plan/employeeScheduleSupervisor.js') }}"></script> -->

<!-- customize JS  -->
<!-- <script src="{{ url('assets/js/fo_visit_plan/fo_visit_plan.js') }}"></script> -->
<script src="{{ Module::asset('fo:js/visitplan.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('fo:js/visitplan_calander.js') }}?random=<?php echo uniqid(); ?>"></script>




<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
@endsection
