<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// use Illuminate\Routing\Route;
use Illuminate\Support\Facades\Route;
use Modules\Fo\Http\Controllers\FoController;
use Modules\Fo\Http\Controllers\SupplierMaterialController; 
use Modules\Fo\Http\Controllers\SupplierVisitController;
use Modules\Fo\Http\Controllers\Supply_planController;
use Modules\Fo\Http\Controllers\SupplyCollectionController;
use Modules\Fo\Http\Controllers\EmlpoyeeSupplierController;
use Modules\Fo\Http\Controllers\OtherActivitiesController;
use Modules\Fo\Http\Controllers\PlanProductController;
use Modules\Fo\Http\Controllers\PlanProductEmployeeDailyController;
use Modules\Fo\Http\Controllers\PlanProductEmployeeDailyListController;
use Modules\Fo\Http\Controllers\PlanProductListController;
use Modules\Fo\Http\Controllers\PlanVsActualController;
use Modules\Fo\Http\Controllers\PlanVsIntakeController;
use Modules\Fo\Http\Controllers\SupplierVisitPlanController;
use Modules\Fo\Http\Controllers\VisitPlanCalanderController;
use Modules\Fo\Http\Controllers\VisitPlanController;

Route::prefix('fo')->group(function () {
        //Route::get('/', 'FoController@index');
    Route::get('/dashboard', function () {
        return view('fo::dashboard');
    })->middleware('is.logged');

    Route::get('/plan_product', function () {
        return view('fo::fo_plan_product');
    })->middleware('is.logged');

    Route::get('/plan_product_list', function () {
        return view('fo::fo_plan_product_list');
    })->middleware('is.logged');

    Route::get('/plan_product_employee_daily', function () {
        return view('fo::fo_plan_product_employee_daily');
    })->middleware('is.logged');

    Route::get('/plan_product_employee_daily_list', function () {
        return view('fo::fo_plan_product_employee_daily_list');
    })->middleware('is.logged');









    Route::get('/planned_materials', function () {
        return view('fo::supply_plan');
    })->middleware('is.logged');

    Route::get('/planned_materials_list', function () {
        return view('fo::supply_plan_list');
    })->middleware('is.logged');

    Route::get('/employee_supply_collection', function () {
        return view('fo::supply_collection');
    })->middleware('is.logged');

    Route::get('/employee_supply_collection_list', function () {
        return view('fo::supply_collection_list');
    })->middleware('is.logged');

    Route::get('/visit_plan', function () {
        return view('fo::fo_visit_plan');
    })->middleware('is.logged');

    Route::get('/supplier_material', function () {
        return view('fo::supplier_material');
    })->middleware(['is.logged', 'can:fo_material_assign_to_supplier']);

    Route::get('/employee_supplier', function () {
        return view('fo::employee_supplier');
    })->middleware('is.logged');

    Route::get('/supplier_visit', function () {
        return view('fo::supplier_visit');
    })->middleware('is.logged');

    Route::get('/other_activities', function () {
        return view('fo::other_activities');
    })->middleware('is.logged');


    Route::get('/visit_plan_vs_actual', function () {
        return view('fo::fo_visit_plan_vs_actual');
    })->middleware('is.logged');

    Route::get('/visit_plan_vs_intake', function () {
        return view('fo::fo_visit_plan_vs_intake');
    })->middleware('is.logged');

   Route::get('/supplier_visit_plan', function () {
        return view('fo::supplier_visit_plan');
    })->middleware('is.logged');


   //*  Supplier Materials  */
    Route::get('/supplierMaterials/getSupplier', [SupplierMaterialController::class, 'GetSuppliers']);
    Route::get('/supplierMaterials/products', [SupplierMaterialController::class, 'GetProducts']);
    Route::get('/supplierMaterials/GetSupplierAddress/{id}', [SupplierMaterialController::class, 'GetSupplierAddress']);
    Route::get('/supplierMaterials/GetAssignProducts/{id}', [SupplierMaterialController::class, 'GetNewlyAssignedProducts']);
    Route::get('/supplierMaterials/GetSupplierAssignedProducts/{id}', [SupplierMaterialController::class, 'GetSupplierAssignedProducts']);
    Route::post('/supplierMaterials/InsertCheckedProducts', [SupplierMaterialController::class, 'InsertCheckedData']);
    route::post('/supplierMaterials/assignProducts', [SupplierMaterialController::class, 'AssignProduct']);
    // Route::get('/supplierMaterials/GetAssignProducts/{id}', [EmployeeSupplyPlanController::class, 'GetNewlyAssignedProducts']);
    Route::delete('/supplierMaterials/DeleteAssignProducts/{id}', [SupplierMaterialController::class, 'DeleteAssignProducts']);
    //* End of Supplier Materials */



    //*  Plan Product Controller  */
    Route::get('/PlanProductController/sites', [PlanProductController::class, 'sites']);
    Route::get('/PlanProductController/mainRawMaterials/{year}/{month}/{site}', [PlanProductController::class, 'mainRawMaterials']);
    Route::post('/PlanProductController/savePlanProduct', [PlanProductController::class, 'savePlanProduct']);
    Route::get('/PlanProductController/fieldOfficers/{plan_product_id}', [PlanProductController::class, 'fieldOfficers']);
    Route::post('/PlanProductController/saveFieldOfficerQuantity', [PlanProductController::class, 'saveFieldOfficerQuantity']);
    //* End of Plan Product Controller */


    //*  Plan Product Employee List Controller  */
    Route::get('/PlanProductListController/getMainPlanList', [PlanProductListController::class, 'getMainPlanList']);
    Route::delete('/PlanProductListController/delete/{site}/{year}/{month}', [PlanProductListController::class, 'delete']);
    //*  Plan Product Employee List Controller  */



    //*  Plan Product Employee Daily  */
    Route::get('/PlanProductEmployeeDailyController/sites', [PlanProductEmployeeDailyController::class, 'sites']);
    Route::get('/PlanProductEmployeeDailyController/mainRawMaterials/{officer_id}', [PlanProductEmployeeDailyController::class, 'mainRawMaterials']);
    Route::get('/PlanProductEmployeeDailyController/fieldOfficers', [PlanProductEmployeeDailyController::class, 'fieldOfficers']);
    Route::get('/PlanProductEmployeeDailyController/suppliers', [PlanProductEmployeeDailyController::class, 'suppliers']);
    Route::get('/PlanProductEmployeeDailyController/getOfficerQuantity/{officer_id}/{item_id}/{year}/{month}', [PlanProductEmployeeDailyController::class, 'getOfficerQuantity']);
    Route::post('/PlanProductEmployeeDailyController/save', [PlanProductEmployeeDailyController::class, 'save']);
    Route::get('/PlanProductEmployeeDailyController/allSuppliers', [PlanProductEmployeeDailyController::class, 'allSuppliers']);
    Route::get('/PlanProductEmployeeDailyController/loadDailyPlan/{site_id}/{year}/{month}/{filed_officer_id}/{item_id}', [PlanProductEmployeeDailyController::class, 'loadDailyPlan']);
    //* End of Plan Product Employee Daily */



    //*  Plan Product Employee Daily List  */
    Route::get('/PlanProductEmployeeDailyListController/getOfficerPlanList', [PlanProductEmployeeDailyListController::class, 'getOfficerPlanList']);
    Route::delete('/PlanProductEmployeeDailyListController/delete/{site_id}/{officer_id}/{product_primary_id}/{year}/{month}', [PlanProductEmployeeDailyListController::class, 'delete']);
    //*  End Of Plan Product Employee Daily List  */



    /** Visit Plan Controller */
    Route::get('/VisitPlanController/allFieldOfficerID', [VisitPlanController::class, 'allFieldOfficerID']);
    Route::get('/VisitPlanController/allFieldOfficerName', [VisitPlanController::class, 'allFieldOfficerName']);
    Route::get('/VisitPlanController/getSelectedFieldOfficerName/{id}', [VisitPlanController::class, 'getSelectedFieldOfficerName']);
    Route::get('/VisitPlanController/loadPlan/{officer_id}/{start_date}/{end_date}', [VisitPlanController::class, 'loadPlan']);
    /** End of Visit Plan Controller */


    /** Visit Plan Calander Controller */
    Route::get('/VisitPlanCalanderController/loadVisitPlanToCalander/{filed_officer_id}/{start_date}/{end_date}', [VisitPlanCalanderController::class, 'loadVisitPlanToCalander']);
    /** End of Visit Plan Calander Controller */


    /** Plan Vs Actual Controller */
    Route::get('/PlanVsActualController/fieldOfficers', [PlanVsActualController::class, 'fieldOfficers']);
    Route::get('/PlanVsActualController/suppliers', [PlanVsActualController::class, 'suppliers']);
    Route::get('/PlanVsActualController/materials', [PlanVsActualController::class, 'materials']);
    Route::get('/PlanVsActualController/visitPlanActualReport/{search_option}/{date_from}/{date_to}', [PlanVsActualController::class, 'visitPlanActualReport']);
    /** End of Plan Vs Actual Controller */


    /** Plan Vs Intake Controller */
    Route::get('/PlanVsIntakeController/fieldOfficers', [PlanVsIntakeController::class, 'fieldOfficers']);
    Route::get('/PlanVsIntakeController/suppliers', [PlanVsIntakeController::class, 'suppliers']);
    Route::get('/PlanVsIntakeController/materials', [PlanVsIntakeController::class, 'materials']);
    Route::get('/PlanVsIntakeController/visitPlanIntakeReport/{search_option}/{date_from}/{date_to}', [PlanVsIntakeController::class, 'visitPlanIntakeReport']);
    /** End of Plan Vs Intake Controller */









    //* Employee Supplier Collection */
    Route::get('/EmployeeSupplyCollection/getSupplier', [SupplyCollectionController::class, 'GetSuppliers']);
    Route::post('/SupplyCollection/SaveSupplyCollection', [SupplyCollectionController::class, 'InsertSupplyCollection']);
    Route::get('/SupplyCollectionController/GetSupplyCollectionData/{id}', [SupplyCollectionController::class, 'GetSupplyCollectionData']);
    Route::post('/SupplyCollection/GetProductsOnDateToSupplyCollection', [SupplyCollectionController::class, 'GetProductsOnDateToSupplyCollection']);
    Route::post('/SupplyCollection/UpdateSupplyCollection', [SupplyCollectionController::class, 'UpdateSupplyCollection']);
    Route::get('/SupplyCollection/GetSupplyCollectionList/{id}/{start_date}/{end_date}', [SupplyCollectionController::class, 'GetSupplierCollectionList']);
    Route::get('/SupplyCollection/GetSupplierAddressToCollection/{id}', [SupplyCollectionController::class, 'LoadPlanToCollection']);
    Route::get('/FieldOperation/allType', [FoController::class, 'allType']);
    //* End of Employee Supplier Collection */

    //* Employee Supplier Plan */
    Route::get('/SupplyPlan/getSupplier', [Supply_planController::class, 'GetSuppliers']);
    Route::get('/SupplyPlan/GetSupplyPlan', [Supply_planController::class, 'GetSupplyPlan']);
    Route::get('/SupplyPlan/GetSupplierAddress/{id}', [Supply_planController::class, 'GetSupplierAddress']);
    Route::post('/SupplyPlan/SaveSupplyPlan', [Supply_planController::class, 'InsertSupplyPlan']);
    Route::get('/SupplyPlan/GetSupplyPlanData/{id}', [Supply_planController::class, 'GetSupplyPlanData']);
    Route::post('/SupplyPlan/GetProductsOnDate', [Supply_planController::class, 'GetProductsOnDate']);
    Route::post('/SupplyPlan/UpdateSupplyPlan', [Supply_planController::class, 'UpdateSupplyPlan']);
    //* End of Employee Supplier Collection */
    //routes by nipuna
    // Route::get('/EmployeeSupplyPlan/Getpreviousdata/{date}', [EmployeeSupplyPlanController::class, 'Getpreviousdata']);

    //* Employee Supplier Plan */
    Route::get('/FieldOperation/GetSupplierId', [EmlpoyeeSupplierController::class, 'GetSupplierId']);
    Route::get('/FieldOperation/GetAllSupplierData', [EmlpoyeeSupplierController::class, 'GetAllSupplierData']);
    Route::get('/FieldOperation/GetFieldOfficerName', [EmlpoyeeSupplierController::class, 'GetFieldOfficerName']);
    Route::get('/FieldOperation/GetOfficerNameById/{id}', [EmlpoyeeSupplierController::class, 'GetOfficerNameById']);
    Route::get('/FieldOperation/GetSupplierPlanByEmployee/{id}', [EmlpoyeeSupplierController::class, 'GetSupplierPlanByEmployee']);

    //routes by nipuna
    Route::get('/FieldOperation/getFieldOfficerNametoId/{id}', [FoController::class, 'getFieldOfficerNametoId']);
    Route::get('/FieldOperation/GetSingleFiledOfficer/{id}', [FoController::class, 'GetSingleFiledOfficer']);
    Route::get('/FieldOperation/getDesignationId/{id}', [FoController::class, 'getDesignationId']);

    Route::get('/FieldOperation/GetSupplierPlanByEmployeeToCalender/{id}', [FoController::class, 'GetSupplierPlanByEmployeeToCalendar']);
    Route::post('/FieldOperation/GetSuppplyPlanDataToModal', [FoController::class, 'GetSupplyPlanDataToModal']);
    //* End of Employee Supplier Collection */

    //** Employee Supplier Asssign */
    Route::get('/EmployeeSupplier/getEmployee', [FoController::class, 'GetEmployees']);
    Route::get('/EmployeeSupplier/getSuppliersByEmployee/{id}', [EmlpoyeeSupplierController::class, 'GetSuppliersByEmployee']);
    Route::get('/EmployeeSupplier/getAllSuppliers', [FoController::class, 'GetSuppliers']);
    Route::get('/EmployeeSupplier/GetSupplierAddressBySupplierID/{id}', [FoController::class, 'GetSupplierAddressBySupplierID']);
    // Route::get('/EmployeeSupplier/getEmployeeid/{id}', [EmlpoyeeSupplierController::class, 'getEmployeeid']);

    Route::post('/EmployeeSupplier/AssignNewSupplier', [FoController::class, 'AssignNewSuppliers']);

    Route::delete('/EmployeeSupplier/DeleteAssignedSupplier/{id}', [FoController::class, 'DeleteAssignedSuppliers']);



    //** End of employee supplier Assign */

    //** Supplier Visit */
    Route::post('/SupplierVisit/createSupplierVisit', [SupplierVisitController::class, 'CreateSupplierVisit']);
    Route::get('/SupplierVisit/LoadSupplierVisit', [SupplierVisitController::class, 'GetSupplierVist']);
    Route::get('/SupplierVisit/GetsupplierVisitDataToModal/{id}', [SupplierVisitController::class, 'GetSupplierVisitDataToModal']);
    Route::post('/SupplierVisit/UpdateSupplierVisit/{id}', [SupplierVisitController::class, 'UpdateSupplierVisit']);
    Route::get('/SupplierVisit/GetSupplierByOfficer/{id}', [SupplierVisitController::class, 'GetSupplierByOfficer']);
    Route::get('/SupplierVisit/GetSupplierVisitByEmployee/{id}', [SupplierVisitController::class, 'GetSupplierVisitByEmployee']);
    Route::get('/SupplierVisit/GetSupplierVisitByEmployeeToCalander/{id}', [SupplierVisitController::class, 'GetSupplierVisitByEmployeeToCalander']);
    Route::post('/SupplierVist/GetSupplierVisitToModal', [SupplierVisitController::class, 'GetSupplierVisitToModal']);
    Route::get('/SupplierVisit/GetSupplierVisitByDate', [SupplierVisitController::class, 'GetSupplierVisitByDate']);
    Route::get('/SupplierVisit/GetSupplierVisitByDateToOfficer/{id}', [SupplierVisitController::class, 'GetSupplierVisitByDateToOfficer']);


    //** End of supplier visit */

    //** Other Activities */
    Route::post('/OtherActivities/createOtherActivity', [OtherActivitiesController::class, 'createOtherActivity']);
    Route::get('/OtherActivities/LoadOtherActivityByOfficer/{id}', [OtherActivitiesController::class, 'LoadOtherActivityByOfficer']);
    Route::get('/OtherActivities/GetOtherActivityDataToModal/{id}', [OtherActivitiesController::class, 'GetOtherActivityDataToModal']);
    Route::post('/OtherActivities/UpdateOtherActivity/{id}', [OtherActivitiesController::class, 'UpdateOtherActivity']);
    Route::get('/OtherActivities/CreateOtherActivitySchedule/{id}', [OtherActivitiesController::class, 'CreateOtherActivitySchedule']);
    Route::post('/OtherActivities/GetOtherActivitiesToModal', [OtherActivitiesController::class, 'GetOtherActivitiesToModal']);

    //** End of Other Activities */


    //routes by sampath//
    Route::get('/supplycollection/allFieldOfficer', [SupplyCollectionController::class, 'allFieldOfficer']);
    Route::get('/supplycollection/employee/{id}', [SupplyCollectionController::class, 'getEmployeeByID']);
    Route::get('/supplycollection/isFieldOfficer/{id}', [SupplyCollectionController::class, 'isFieldOfficer']);

    // Supply_planController //
    Route::get('/supplyplan/allFieldOfficer', [Supply_planController::class, 'allFieldOfficer']);
    Route::get('/supplyplan/employee/{id}', [Supply_planController::class, 'getEmployeeByID']);
    Route::get('/supplyplan/isFieldOfficer/{id}', [Supply_planController::class, 'isFieldOfficer']);
    Route::get('/supplyplan/GetSupplyPlanList/{id}/{start_date}/{end_date}', [Supply_planController::class, 'GetSupplierPlanList']);

    //*  Supplier Visit Plan  */
    Route::get('/SupplierVisitPlanController/fieldOfficers', [SupplierVisitPlanController::class, 'fieldOfficers']);
    Route::post('/SupplierVisitPlanController/save', [SupplierVisitPlanController::class, 'save']);
    Route::get('/SupplierVisitPlanController/allSuppliers', [SupplierVisitPlanController::class, 'allSuppliers']);
    Route::get('/SupplierVisitPlanController/loadSavedSupplierVisitPlan/{officer_id}/{year}/{month}', [SupplierVisitPlanController::class, 'loadSavedSupplierVisitPlan']);
    //* End of Supplier Visit Plan */
});
