<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeSubsectionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hr_employee_subsections', function (Blueprint $table) {
            $table->bigIncrements('subsection_id');
            $table->string('subsection',200);
            $table->boolean('status');
            $table->foreignId('section_id');
            $table->foreign('section_id')->references('section_id')->on('hr_employee_sections')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_subsections');
    }
}
