<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionItemSetupsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hr_transaction_item_setups', function (Blueprint $table) {
            $table->string('setup_id',5)->unique();
            $table->foreignId('item_id');
            $table->foreign('item_id')->references('item_id')->on('hr_transaction_items')->onDelete('cascade');
            $table->string('narration',200);
            $table->boolean('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transaction_item_setups');
    }
}
