<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSalaryAdvancesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hr_salary_advances', function (Blueprint $table) {
            $table->id();
            $table->string('employee_id', 25);
            $table->foreign('employee_id')->references('employee_id')->on('hr_employees')->onDelete('cascade');
            $table->double('amount');
            $table->date('tran_date');
            $table->float('deduct_year');
            $table->float('deduct_month');
            $table->integer('requested_by');
            $table->integer('approved_by');
            $table->integer('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('salary_advances');
    }
}
