<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class CategoryRestriction extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'hr_category_restrictions';
    protected $primaryKey = 'category_restriction_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'category_restriction_id',
        'category_id',
        'employee_id',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_category_restrictions";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }

}
